/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit;

import de.brendamour.jpasskit.IPKValidateable;
import de.brendamour.jpasskit.enums.PKBarcodeFormat;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PKBarcode
implements IPKValidateable {
    private static final long serialVersionUID = -7661537217765974179L;
    private static final List<PKBarcodeFormat> BARCODE_TYPES_BEFORE_IOS_9;
    private PKBarcodeFormat format;
    private String altText;
    private String message;
    private String messageEncoding;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public PKBarcodeFormat getFormat() {
        return this.format;
    }

    public void setFormat(PKBarcodeFormat format) {
        this.format = format;
    }

    public Charset getMessageEncoding() {
        if (StringUtils.isNotEmpty((CharSequence)this.messageEncoding)) {
            return Charset.forName(this.messageEncoding);
        }
        return null;
    }

    public String getMessageEncodingAsString() {
        return this.messageEncoding;
    }

    public void setMessageEncoding(Charset messageEncoding) {
        this.messageEncoding = messageEncoding != null ? messageEncoding.name() : null;
    }

    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    protected boolean isValidInIosVersionsBefore9() {
        return BARCODE_TYPES_BEFORE_IOS_9.contains((Object)this.getFormat());
    }

    @Override
    public List<String> getValidationErrors() {
        ArrayList<String> validationErrors = new ArrayList<String>(1);
        if (this.format == null || StringUtils.isEmpty((CharSequence)this.message) || StringUtils.isEmpty((CharSequence)this.messageEncoding)) {
            StringBuilder builder = new StringBuilder();
            builder.append("Not all required Fields are set. Format: ");
            builder.append((Object)this.format);
            builder.append(" Message: ");
            builder.append(this.message);
            builder.append(" MessageEncoding: ");
            builder.append(this.messageEncoding);
            validationErrors.add(builder.toString());
        }
        return validationErrors;
    }

    static {
        ArrayList<PKBarcodeFormat> barcodeTypes = new ArrayList<PKBarcodeFormat>(3);
        barcodeTypes.add(PKBarcodeFormat.PKBarcodeFormatQR);
        barcodeTypes.add(PKBarcodeFormat.PKBarcodeFormatPDF417);
        barcodeTypes.add(PKBarcodeFormat.PKBarcodeFormatAztec);
        BARCODE_TYPES_BEFORE_IOS_9 = Collections.unmodifiableList(barcodeTypes);
    }
}

