/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.signing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import de.brendamour.jpasskit.PKPass;
import de.brendamour.jpasskit.personalization.PKPersonalization;
import de.brendamour.jpasskit.signing.IPKPassTemplate;
import de.brendamour.jpasskit.signing.PKAbstractSigningUtil;
import de.brendamour.jpasskit.signing.PKSigningException;
import de.brendamour.jpasskit.signing.PKSigningInformation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PKInMemorySigningUtil
extends PKAbstractSigningUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKInMemorySigningUtil.class);

    public PKInMemorySigningUtil() {
        super(new ObjectMapper());
    }

    public PKInMemorySigningUtil(ObjectWriter objectWriter) {
        super(objectWriter);
    }

    @Deprecated
    public PKInMemorySigningUtil(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public byte[] createSignedAndZippedPkPassArchive(PKPass pass, IPKPassTemplate passTemplate, PKSigningInformation signingInformation) throws PKSigningException {
        return this.createSignedAndZippedPersonalizedPkPassArchive(pass, null, passTemplate, signingInformation);
    }

    @Override
    public byte[] createSignedAndZippedPersonalizedPkPassArchive(PKPass pass, PKPersonalization personalization, IPKPassTemplate passTemplate, PKSigningInformation signingInformation) throws PKSigningException {
        Map<String, ByteBuffer> allFiles;
        try {
            allFiles = passTemplate.getAllFiles();
        }
        catch (IOException e) {
            throw new PKSigningException("Error when getting files from template", e);
        }
        ByteBuffer passJSONFile = this.createPassJSONFile(pass);
        allFiles.put("pass.json", passJSONFile);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("passJSONFile: {}", (Object)new String(passJSONFile.array(), Charset.forName("UTF-8")));
        }
        if (personalization != null) {
            ByteBuffer personalizationJSONFile = this.createPersonalizationJSONFile(personalization);
            allFiles.put("personalization.json", personalizationJSONFile);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("personalizationJSONFile: {}", (Object)new String(personalizationJSONFile.array(), Charset.forName("UTF-8")));
            }
        }
        ByteBuffer manifestJSONFile = this.createManifestJSONFile(allFiles);
        allFiles.put("manifest.json", manifestJSONFile);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("manifestJSONFile: {}", (Object)new String(manifestJSONFile.array(), Charset.forName("UTF-8")));
        }
        ByteBuffer signature = ByteBuffer.wrap(this.signManifestFile(manifestJSONFile.array(), signingInformation));
        allFiles.put("signature", signature);
        return this.createZippedPassAndReturnAsByteArray(allFiles);
    }

    private ByteBuffer createPassJSONFile(PKPass pass) throws PKSigningException {
        ByteBuffer byteBuffer;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.objectWriter.writeValue((OutputStream)byteArrayOutputStream, (Object)pass);
            byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PKSigningException("Error when writing pass.json", e);
            }
        }
        byteArrayOutputStream.close();
        return byteBuffer;
    }

    private ByteBuffer createPersonalizationJSONFile(PKPersonalization personalization) throws PKSigningException {
        ByteBuffer byteBuffer;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.objectWriter.writeValue((OutputStream)byteArrayOutputStream, (Object)personalization);
            byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PKSigningException("Error when writing personalization.json", e);
            }
        }
        byteArrayOutputStream.close();
        return byteBuffer;
    }

    private ByteBuffer createManifestJSONFile(Map<String, ByteBuffer> allFiles) throws PKSigningException {
        ByteBuffer byteBuffer;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Map<String, String> fileWithHashMap = this.hashFiles(allFiles, Hashing.sha1());
            this.objectWriter.writeValue((OutputStream)byteArrayOutputStream, fileWithHashMap);
            byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PKSigningException("Error when writing manifest.json", e);
            }
        }
        byteArrayOutputStream.close();
        return byteBuffer;
    }

    private Map<String, String> hashFiles(Map<String, ByteBuffer> files, HashFunction hashFunction) {
        HashMap<String, String> fileWithHashMap = new HashMap<String, String>();
        for (Map.Entry<String, ByteBuffer> passResourceFile : files.entrySet()) {
            HashCode hash = hashFunction.hashBytes(passResourceFile.getValue().array());
            fileWithHashMap.put(this.getRelativePathOfZipEntry(passResourceFile.getKey(), ""), Hex.encodeHexString((byte[])hash.asBytes()));
        }
        return fileWithHashMap;
    }

    private byte[] createZippedPassAndReturnAsByteArray(Map<String, ByteBuffer> files) throws PKSigningException {
        ByteArrayOutputStream byteArrayOutputStreamForZippedPass = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStreamForZippedPass);){
            for (Map.Entry<String, ByteBuffer> passResourceFile : files.entrySet()) {
                ZipEntry entry = new ZipEntry(this.getRelativePathOfZipEntry(passResourceFile.getKey(), ""));
                zipOutputStream.putNextEntry(entry);
                IOUtils.copy((InputStream)new ByteArrayInputStream(passResourceFile.getValue().array()), (OutputStream)zipOutputStream);
            }
        }
        catch (IOException e) {
            throw new PKSigningException("Error while creating a zip package", e);
        }
        return byteArrayOutputStreamForZippedPass.toByteArray();
    }
}

