/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.Function;
import de.bwaldvogel.liblinear.MutableDouble;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SparseOperator;

abstract class L2R_ErmFunction
implements Function {
    final double[] C;
    final Problem prob;
    double[] wx;
    double[] tmp;
    private double wTw;
    final boolean regularize_bias;

    L2R_ErmFunction(Problem prob, Parameter parameter, double[] C) {
        int l = prob.l;
        this.prob = prob;
        this.wx = new double[l];
        this.tmp = new double[l];
        this.C = C;
        this.regularize_bias = parameter.regularize_bias;
    }

    void Xv(double[] v, double[] Xv) {
        int l = this.prob.l;
        Feature[][] x = this.prob.x;
        for (int i = 0; i < l; ++i) {
            Xv[i] = SparseOperator.dot(v, x[i]);
        }
    }

    void XTv(double[] v, double[] XTv) {
        int i;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        Feature[][] x = this.prob.x;
        for (i = 0; i < w_size; ++i) {
            XTv[i] = 0.0;
        }
        for (i = 0; i < l; ++i) {
            SparseOperator.axpy(v[i], x[i], XTv);
        }
    }

    protected abstract double C_times_loss(int var1, double var2);

    @Override
    public double fun(double[] w) {
        int i;
        double f = 0.0;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.wTw = 0.0;
        this.Xv(w, this.wx);
        for (i = 0; i < w_size; ++i) {
            this.wTw += w[i] * w[i];
        }
        if (!this.regularize_bias) {
            this.wTw -= w[w_size - 1] * w[w_size - 1];
        }
        for (i = 0; i < l; ++i) {
            f += this.C_times_loss(i, this.wx[i]);
        }
        return f += 0.5 * this.wTw;
    }

    @Override
    public int get_nr_variable() {
        return this.prob.n;
    }

    @Override
    public double linesearch_and_update(double[] w, double[] s, MutableDouble f, double[] g, double alpha) {
        int i;
        int l = this.prob.l;
        double sTs = 0.0;
        double wTs = 0.0;
        double gTs = 0.0;
        double eta = 0.01;
        int w_size = this.get_nr_variable();
        int max_num_linesearch = 20;
        double fold = f.get();
        this.Xv(s, this.tmp);
        for (i = 0; i < w_size; ++i) {
            sTs += s[i] * s[i];
            wTs += s[i] * w[i];
            gTs += s[i] * g[i];
        }
        if (!this.regularize_bias) {
            sTs -= s[w_size - 1] * s[w_size - 1];
            wTs -= s[w_size - 1] * w[w_size - 1];
        }
        int num_linesearch = 0;
        for (num_linesearch = 0; num_linesearch < max_num_linesearch; ++num_linesearch) {
            double loss = 0.0;
            for (i = 0; i < l; ++i) {
                double inner_product = this.tmp[i] * alpha + this.wx[i];
                loss += this.C_times_loss(i, inner_product);
            }
            f.set(loss + (alpha * alpha * sTs + this.wTw) / 2.0 + alpha * wTs);
            if (f.get() - fold <= eta * alpha * gTs) {
                for (i = 0; i < l; ++i) {
                    int n = i;
                    this.wx[n] = this.wx[n] + alpha * this.tmp[i];
                }
                break;
            }
            alpha *= 0.5;
        }
        if (num_linesearch >= max_num_linesearch) {
            f.set(fold);
            return 0.0;
        }
        for (i = 0; i < w_size; ++i) {
            int n = i;
            w[n] = w[n] + alpha * s[i];
        }
        this.wTw += alpha * alpha * sTs + 2.0 * alpha * wTs;
        return alpha;
    }
}

