/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.L2R_L2_SvcFunction;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;

public class L2R_L2_SvrFunction
extends L2R_L2_SvcFunction {
    private final double p;

    public L2R_L2_SvrFunction(Problem prob, Parameter param, double[] C) {
        super(prob, param, C);
        this.p = param.p;
    }

    @Override
    protected double C_times_loss(int i, double wx_i) {
        double d = wx_i - this.prob.y[i];
        if (d < -this.p) {
            return this.C[i] * (d + this.p) * (d + this.p);
        }
        if (d > this.p) {
            return this.C[i] * (d - this.p) * (d - this.p);
        }
        return 0.0;
    }

    @Override
    public void grad(double[] w, double[] g) {
        int i;
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.sizeI = 0;
        for (i = 0; i < l; ++i) {
            double d = this.wx[i] - y[i];
            if (d < -this.p) {
                this.tmp[this.sizeI] = this.C[i] * (d + this.p);
                this.I[this.sizeI] = i;
                ++this.sizeI;
                continue;
            }
            if (!(d > this.p)) continue;
            this.tmp[this.sizeI] = this.C[i] * (d - this.p);
            this.I[this.sizeI] = i;
            ++this.sizeI;
        }
        this.subXTv(this.tmp, g);
        for (i = 0; i < w_size; ++i) {
            g[i] = w[i] + 2.0 * g[i];
        }
        if (!this.regularize_bias) {
            int n = w_size - 1;
            g[n] = g[n] - w[w_size - 1];
        }
    }
}

