/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.Blas;
import de.bwaldvogel.liblinear.Function;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.MutableDouble;
import de.bwaldvogel.liblinear.MutableInt;

class Newton {
    private final Function fun_obj;
    private final double eps;
    private final int max_iter;
    private final double eps_cg;

    Newton(Function fun_obj, double eps, int max_iter) {
        this(fun_obj, eps, max_iter, 0.5);
    }

    Newton(Function fun_obj, double eps, int max_iter, double eps_cg) {
        this.fun_obj = fun_obj;
        this.eps = eps;
        this.max_iter = max_iter;
        this.eps_cg = eps_cg;
    }

    void newton(double[] w) {
        int i;
        int n = this.fun_obj.get_nr_variable();
        double init_step_size = 1.0;
        boolean search = true;
        int iter = 1;
        MutableInt inc = new MutableInt(1);
        double[] s = new double[n];
        double[] r = new double[n];
        double[] g = new double[n];
        double alpha_pcg = 0.01;
        double[] M = new double[n];
        double[] w0 = new double[n];
        for (i = 0; i < n; ++i) {
            w0[i] = 0.0;
        }
        this.fun_obj.fun(w0);
        this.fun_obj.grad(w0, g);
        double gnorm0 = Blas.dnrm2_(n, g, inc);
        double f = this.fun_obj.fun(w);
        this.fun_obj.grad(w, g);
        double gnorm = Blas.dnrm2_(n, g, inc);
        Linear.info("init f %5.3e |g| %5.3e%n", f, gnorm);
        if (gnorm <= this.eps * gnorm0) {
            search = false;
        }
        while (iter <= this.max_iter && search) {
            this.fun_obj.get_diag_preconditioner(M);
            for (i = 0; i < n; ++i) {
                M[i] = 0.99 + 0.01 * M[i];
            }
            int cg_iter = this.pcg(g, M, s, r);
            double fold = f;
            MutableDouble fReference = new MutableDouble(f);
            double step_size = this.fun_obj.linesearch_and_update(w, s, fReference, g, init_step_size);
            f = fReference.get();
            if (step_size == 0.0) {
                Linear.info("WARNING: line search fails%n");
                break;
            }
            this.fun_obj.grad(w, g);
            gnorm = Blas.dnrm2_(n, g, inc);
            Linear.info("iter %2d f %5.3e |g| %5.3e CG %3d step_size %4.2e%n", iter, f, gnorm, cg_iter, step_size);
            if (gnorm <= this.eps * gnorm0) break;
            if (f < -1.0E32) {
                Linear.info("WARNING: f < -1.0e+32%n");
                break;
            }
            double actred = fold - f;
            if (Math.abs(actred) <= 1.0E-12 * Math.abs(f)) {
                Linear.info("WARNING: actred too small%n");
                break;
            }
            ++iter;
        }
        if (iter >= this.max_iter) {
            Linear.info("%nWARNING: reaching max number of Newton iterations%n");
        }
    }

    private int pcg(double[] g, double[] M, double[] s, double[] r) {
        int i;
        int inc = 1;
        int n = this.fun_obj.get_nr_variable();
        double one = 1.0;
        double[] d = new double[n];
        double[] Hd = new double[n];
        double[] z = new double[n];
        double Q = 0.0;
        for (i = 0; i < n; ++i) {
            s[i] = 0.0;
            r[i] = -g[i];
            z[i] = r[i] / M[i];
            d[i] = z[i];
        }
        double zTr = Blas.ddot_(n, z, inc, r, inc);
        double gMinv_norm = Math.sqrt(zTr);
        double cgtol = Math.min(this.eps_cg, Math.sqrt(gMinv_norm));
        int cg_iter = 0;
        int max_cg_iter = Math.max(n, 5);
        while (cg_iter < max_cg_iter) {
            ++cg_iter;
            this.fun_obj.Hv(d, Hd);
            double dHd = Blas.ddot_(n, d, inc, Hd, inc);
            if (dHd <= 1.0E-16) break;
            double alpha = zTr / dHd;
            Blas.daxpy_(n, alpha, d, inc, s, inc);
            alpha = -alpha;
            Blas.daxpy_(n, alpha, Hd, inc, r, inc);
            double newQ = -0.5 * (Blas.ddot_(n, s, inc, r, inc) - Blas.ddot_(n, s, inc, g, inc));
            double Qdiff = newQ - Q;
            if (newQ <= 0.0 && Qdiff <= 0.0) {
                if ((double)cg_iter * Qdiff >= cgtol * newQ) {
                    break;
                }
            } else {
                Linear.info("WARNING: quadratic approximation > 0 or increasing in CG%n");
                break;
            }
            Q = newQ;
            for (i = 0; i < n; ++i) {
                z[i] = r[i] / M[i];
            }
            double znewTrnew = Blas.ddot_(n, z, inc, r, inc);
            double beta = znewTrnew / zTr;
            Blas.dscal_(n, beta, d, inc);
            Blas.daxpy_(n, one, z, inc, d, inc);
            zTr = znewTrnew;
        }
        if (cg_iter == max_cg_iter) {
            Linear.info("WARNING: reaching maximal number of CG steps%n");
        }
        return cg_iter;
    }
}

