/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LookupStage
implements AggregationStage {
    private static final String FROM = "from";
    private static final String LOCAL_FIELD = "localField";
    private static final String FOREIGN_FIELD = "foreignField";
    private static final String AS = "as";
    private static final Set<String> CONFIGURATION_KEYS = new HashSet<String>();
    private final String localField;
    private final String foreignField;
    private final String as;
    private final MongoCollection<?> collection;

    public LookupStage(Document configuration, MongoDatabase mongoDatabase) {
        String from = this.readConfigurationProperty(configuration, FROM);
        this.collection = mongoDatabase.resolveCollection(from, false);
        this.localField = this.readConfigurationProperty(configuration, LOCAL_FIELD);
        this.foreignField = this.readConfigurationProperty(configuration, FOREIGN_FIELD);
        this.as = this.readConfigurationProperty(configuration, AS);
        this.ensureAllConfigurationPropertiesExist(configuration);
    }

    private String readConfigurationProperty(Document configuration, String name) {
        Object value = configuration.get(name);
        if (value == null) {
            throw this.buildConfigurationError("missing '" + name + "' option to $lookup stage specification: " + configuration);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw this.buildConfigurationError("'" + name + "' option to $lookup must be a string, but was type " + value.getClass().getName());
    }

    private void ensureAllConfigurationPropertiesExist(Document configuration) {
        for (String name : configuration.keySet()) {
            if (CONFIGURATION_KEYS.contains(name)) continue;
            String message = "unknown argument to $lookup: " + name;
            throw this.buildConfigurationError(message);
        }
    }

    private MongoServerError buildConfigurationError(String message) {
        return new MongoServerError(9, "FailedToParse", message);
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        return stream.map(this::resolveRemoteField);
    }

    private Document resolveRemoteField(Document document) {
        Object value = document.get(this.localField);
        List<Document> documents = this.lookupValue(value);
        Document result = document.clone();
        result.put(this.as, (Object)documents);
        return result;
    }

    private List<Document> lookupValue(Object value) {
        if (value instanceof List) {
            return ((List)value).stream().flatMap(item -> this.lookupValue(item).stream()).collect(Collectors.toList());
        }
        Document query = new Document(this.foreignField, value);
        Iterable<Document> queryResult = this.collection.handleQuery(query);
        return StreamSupport.stream(queryResult.spliterator(), false).collect(Collectors.toList());
    }

    static {
        CONFIGURATION_KEYS.add(FROM);
        CONFIGURATION_KEYS.add(LOCAL_FIELD);
        CONFIGURATION_KEYS.add(FOREIGN_FIELD);
        CONFIGURATION_KEYS.add(AS);
    }
}

