/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.IndexKey;
import de.bwaldvogel.mongo.backend.QueryOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.bson.BsonRegularExpression;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.DuplicateKeyError;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public abstract class AbstractUniqueIndex<P>
extends Index<P> {
    protected AbstractUniqueIndex(List<IndexKey> keys, boolean sparse) {
        super(keys, sparse);
    }

    protected abstract P removeDocument(List<Object> var1);

    protected abstract boolean containsKey(List<Object> var1);

    protected abstract boolean putKeyPosition(List<Object> var1, P var2);

    protected abstract Iterable<Map.Entry<List<Object>, P>> getIterable();

    protected abstract P getPosition(List<Object> var1);

    private boolean hasNoValueForKeys(Document document) {
        return this.keys().stream().noneMatch(key -> Utils.hasSubdocumentValue(document, key));
    }

    @Override
    public synchronized P remove(Document document) {
        if (this.isSparse() && this.hasNoValueForKeys(document)) {
            return null;
        }
        List<Object> key = this.getKeyValue(document);
        return this.removeDocument(key);
    }

    @Override
    public synchronized void checkAdd(Document document, MongoCollection<P> collection) {
        if (this.isSparse() && this.hasNoValueForKeys(document)) {
            return;
        }
        List<Object> key = this.getKeyValue(document);
        if (this.containsKey(key)) {
            throw new DuplicateKeyError(this, collection, this.getKeyValue(document, false));
        }
    }

    @Override
    public synchronized void add(Document document, P position, MongoCollection<P> collection) {
        this.checkAdd(document, collection);
        if (this.isSparse() && this.hasNoValueForKeys(document)) {
            return;
        }
        List<Object> key = this.getKeyValue(document);
        boolean added = this.putKeyPosition(key, position);
        Assert.isTrue(added, () -> "Key " + key + " already exists. Concurrency issue?");
    }

    @Override
    public void checkUpdate(Document oldDocument, Document newDocument, MongoCollection<P> collection) {
        if (this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            return;
        }
        this.checkAdd(newDocument, collection);
    }

    @Override
    public void updateInPlace(Document oldDocument, Document newDocument, MongoCollection<P> collection) throws KeyConstraintError {
        if (!this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            P position = this.remove(oldDocument);
            this.add(newDocument, position, collection);
        }
    }

    @Override
    public synchronized boolean canHandle(Document query) {
        if (!query.keySet().equals(this.keySet())) {
            return false;
        }
        if (this.isSparse() && query.values().stream().allMatch(Objects::isNull)) {
            return false;
        }
        for (String key : this.keys()) {
            Object queryValue = query.get(key);
            if (!(queryValue instanceof Document)) continue;
            if (this.isCompoundIndex()) {
                return false;
            }
            if (BsonRegularExpression.isRegularExpression(queryValue)) {
                return true;
            }
            for (String queriedKeys : ((Document)queryValue).keySet()) {
                if (AbstractUniqueIndex.isInQuery(queriedKeys) || !queriedKeys.startsWith("$")) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInQuery(String key) {
        return key.equals(QueryOperator.IN.getValue());
    }

    @Override
    public synchronized Iterable<P> getPositions(Document query) {
        List<Object> queriedKeys = this.getQueriedKeys(query);
        for (Object queriedKey : queriedKeys) {
            if (BsonRegularExpression.isRegularExpression(queriedKey)) {
                if (this.isCompoundIndex()) {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
                ArrayList<P> positions = new ArrayList<P>();
                for (Map.Entry<List<Object>, P> entry : this.getIterable()) {
                    BsonRegularExpression regularExpression;
                    Matcher matcher;
                    Object o;
                    List<Object> obj = entry.getKey();
                    if (obj.size() != 1 || !((o = obj.get(0)) instanceof String) || !(matcher = (regularExpression = BsonRegularExpression.convertToRegularExpression(queriedKey)).matcher(o.toString())).find()) continue;
                    positions.add(entry.getValue());
                }
                return positions;
            }
            if (!(queriedKey instanceof Document)) continue;
            if (this.isCompoundIndex()) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            Document keyObj = (Document)queriedKey;
            if (!Utils.containsQueryExpression(keyObj)) continue;
            if (keyObj.keySet().size() != 1) {
                throw new UnsupportedOperationException("illegal query key: " + queriedKeys);
            }
            String expression = keyObj.keySet().iterator().next();
            if (!expression.startsWith("$")) continue;
            return this.getPositionsForExpression(keyObj, expression);
        }
        P position = this.getPosition(queriedKeys);
        if (position == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(position);
    }

    private List<Object> getQueriedKeys(Document query) {
        return this.keys().stream().map(query::get).map(Utils::normalizeValue).collect(Collectors.toList());
    }

    private Iterable<P> getPositionsForExpression(Document keyObj, String operator) {
        if (AbstractUniqueIndex.isInQuery(operator)) {
            Collection objects = (Collection)keyObj.get(operator);
            TreeSet<Object> queriedObjects = new TreeSet<Object>(ValueComparator.asc());
            queriedObjects.addAll(objects);
            ArrayList<P> allKeys = new ArrayList<P>();
            for (Object e : queriedObjects) {
                Object keyValue = Utils.normalizeValue(e);
                P key = this.getPosition(new ArrayList<Object>(Collections.singletonList(keyValue)));
                if (key == null) continue;
                allKeys.add(key);
            }
            return allKeys;
        }
        throw new UnsupportedOperationException("unsupported query expression: " + operator);
    }
}

