/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.LinkedTreeSet;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.backend.aggregation.ExpressionTraits;
import de.bwaldvogel.mongo.backend.aggregation.TwoNumericParameters;
import de.bwaldvogel.mongo.backend.aggregation.TwoParameters;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.Json;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;

public enum Expression implements ExpressionTraits
{
    $abs{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return Utils.normalizeNumber(this.evaluateNumericValue(expressionValue, Math::abs));
        }
    }
    ,
    $add{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            boolean returnDate = false;
            Number sum = 0;
            for (Object value : expressionValue) {
                Object number = value;
                if (Missing.isNullOrMissing(number)) {
                    return null;
                }
                if (!(number instanceof Number) && !(number instanceof Instant)) {
                    throw new MongoServerError(16554, this.name() + " only supports numeric or date types, not " + Utils.describeType(number));
                }
                if (number instanceof Instant) {
                    Instant instant = (Instant)number;
                    number = instant.toEpochMilli();
                    returnDate = true;
                }
                sum = Utils.addNumbers(sum, (Number)number);
            }
            if (returnDate) {
                return Instant.ofEpochMilli(((Number)sum).longValue());
            }
            return sum;
        }
    }
    ,
    $and{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            for (Object value : expressionValue) {
                if (Utils.isTrue(value)) continue;
                return false;
            }
            return true;
        }
    }
    ,
    $anyElementTrue{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            Object valueInCollection = this.requireSingleValue(expressionValue);
            if (!(valueInCollection instanceof Collection)) {
                throw new MongoServerError(17041, this.name() + "'s argument must be an array, but is " + Utils.describeType(valueInCollection));
            }
            Collection collectionInCollection = (Collection)valueInCollection;
            for (Object value : collectionInCollection) {
                if (!Utils.isTrue(value)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    $allElementsTrue{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            Object parameter = this.requireSingleValue(expressionValue);
            if (!(parameter instanceof Collection)) {
                throw new MongoServerError(17040, this.name() + "'s argument must be an array, but is " + Utils.describeType(parameter));
            }
            Collection collectionInCollection = (Collection)parameter;
            for (Object value : collectionInCollection) {
                if (Utils.isTrue(value)) continue;
                return false;
            }
            return true;
        }
    }
    ,
    $arrayElemAt{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoParameters parameters = this.requireTwoParameters(expressionValue);
            if (parameters.isAnyNull()) {
                return null;
            }
            Object firstValue = parameters.getFirst();
            Object secondValue = parameters.getSecond();
            if (!(firstValue instanceof List)) {
                throw new MongoServerError(28689, this.name() + "'s first argument must be an array, but is " + Utils.describeType(firstValue));
            }
            if (!(secondValue instanceof Number)) {
                throw new MongoServerError(28690, this.name() + "'s second argument must be a numeric value, but is " + Utils.describeType(secondValue));
            }
            List collection = (List)firstValue;
            int index = ((Number)secondValue).intValue();
            if (index < 0) {
                index = collection.size() + index;
            }
            if (index < 0 || index >= collection.size()) {
                return null;
            }
            return collection.get(index);
        }
    }
    ,
    $arrayToObject{

        @Override
        Object apply(List<?> expressionValues, Document document) {
            Object values = this.requireSingleValue(expressionValues);
            if (!(values instanceof Collection)) {
                throw new MongoServerError(40386, this.name() + " requires an array input, found: " + Utils.describeType(values));
            }
            Document result = new Document();
            for (Object keyValueObject : (Collection)values) {
                Object value;
                String key;
                Object keyObject;
                Object keyValue;
                if (keyValueObject instanceof List) {
                    keyValue = (List)keyValueObject;
                    if (keyValue.size() != 2) {
                        throw new MongoServerError(40397, this.name() + " requires an array of size 2 arrays,found array of size: " + keyValue.size());
                    }
                    keyObject = keyValue.get(0);
                    if (!(keyObject instanceof String)) {
                        throw new MongoServerError(40395, this.name() + " requires an array of key-value pairs, where the key must be of type string. Found key type: " + Utils.describeType(keyObject));
                    }
                    key = (String)keyObject;
                    value = keyValue.get(1);
                    result.put(key, value);
                    continue;
                }
                if (keyValueObject instanceof Document) {
                    keyValue = (Document)keyValueObject;
                    if (((Document)keyValue).size() != 2) {
                        throw new MongoServerError(40392, this.name() + " requires an object keys of 'k' and 'v'. Found incorrect number of keys:" + ((Document)keyValue).size());
                    }
                    if (!((Document)keyValue).containsKey("k") || !((Document)keyValue).containsKey("v")) {
                        throw new MongoServerError(40393, this.name() + " requires an object with keys 'k' and 'v'. Missing either or both keys from: " + ((Document)keyValue).toString(true));
                    }
                    keyObject = ((Document)keyValue).get("k");
                    if (!(keyObject instanceof String)) {
                        throw new MongoServerError(40394, this.name() + " requires an object with keys 'k' and 'v', where the value of 'k' must be of type string. Found type: " + Utils.describeType(keyObject));
                    }
                    key = (String)keyObject;
                    value = ((Document)keyValue).get("v");
                    result.put(key, value);
                    continue;
                }
                throw new MongoServerError(40398, "Unrecognised input type format for " + this.name() + ": " + Utils.describeType(keyValueObject));
            }
            return result;
        }
    }
    ,
    $ceil{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateNumericValue(expressionValue, Math::ceil);
        }
    }
    ,
    $cmp{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateComparison(expressionValue);
        }
    }
    ,
    $concat{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            StringBuilder result = new StringBuilder();
            for (Object value : expressionValue) {
                if (Missing.isNullOrMissing(value)) {
                    return null;
                }
                if (!(value instanceof String)) {
                    throw new MongoServerError(16702, this.name() + " only supports strings, not " + Utils.describeType(value));
                }
                result.append(value);
            }
            return result.toString();
        }
    }
    ,
    $concatArrays{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            ArrayList result = new ArrayList();
            for (Object value : expressionValue) {
                if (Missing.isNullOrMissing(value)) {
                    return null;
                }
                if (!(value instanceof Collection)) {
                    throw new MongoServerError(28664, this.name() + " only supports arrays, not " + Utils.describeType(value));
                }
                result.addAll((Collection)value);
            }
            return result;
        }
    }
    ,
    $cond{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            Object elseExpression;
            Object thenExpression;
            Object ifExpression;
            if (expressionValue.size() == 1 && CollectionUtils.getSingleElement(expressionValue) instanceof Document) {
                Document condDocument = (Document)CollectionUtils.getSingleElement(expressionValue);
                List<String> requiredKeys = Arrays.asList("if", "then", "else");
                for (String requiredKey : requiredKeys) {
                    if (condDocument.containsKey(requiredKey)) continue;
                    throw new MongoServerError(17080, "Missing '" + requiredKey + "' parameter to " + this.name());
                }
                for (String key : condDocument.keySet()) {
                    if (requiredKeys.contains(key)) continue;
                    throw new MongoServerError(17083, "Unrecognized parameter to " + this.name() + ": " + key);
                }
                ifExpression = condDocument.get("if");
                thenExpression = condDocument.get("then");
                elseExpression = condDocument.get("else");
            } else {
                this.requireCollectionInSize(expressionValue, 3);
                ifExpression = expressionValue.get(0);
                thenExpression = expressionValue.get(1);
                elseExpression = expressionValue.get(2);
            }
            if (Utils.isTrue(12.evaluate(ifExpression, document))) {
                return 12.evaluate(thenExpression, document);
            }
            return 12.evaluate(elseExpression, document);
        }
    }
    ,
    $dayOfMonth{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateDate(expressionValue, LocalDate::getDayOfMonth, document);
        }
    }
    ,
    $dayOfWeek{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateDate(expressionValue, date -> date.getDayOfWeek().getValue(), document);
        }
    }
    ,
    $dayOfYear{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateDate(expressionValue, LocalDate::getDayOfYear, document);
        }
    }
    ,
    $divide{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoNumericParameters parameters = this.requireTwoNumericParameters(expressionValue, 16609);
            if (parameters == null) {
                return null;
            }
            double a = parameters.getFirst();
            double b = parameters.getSecond();
            if (Double.compare(b, 0.0) == 0) {
                throw new MongoServerError(16608, "can't " + this.name() + " by zero");
            }
            return a / b;
        }
    }
    ,
    $eq{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateComparison(expressionValue, v -> v == 0);
        }
    }
    ,
    $exp{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateNumericValue(expressionValue, Math::exp);
        }
    }
    ,
    $filter{

        @Override
        Object apply(Object expressionValue, Document document) {
            Document filterExpression = this.requireDocument(expressionValue, 28646);
            List<String> requiredKeys = Arrays.asList("input", "cond");
            for (String requiredKey : requiredKeys) {
                if (filterExpression.containsKey(requiredKey)) continue;
                throw new MongoServerError(28648, "Missing '" + requiredKey + "' parameter to " + this.name());
            }
            for (String key : filterExpression.keySet()) {
                if (Arrays.asList("input", "cond", "as").contains(key)) continue;
                throw new MongoServerError(28647, "Unrecognized parameter to " + this.name() + ": " + key);
            }
            Object input = 19.evaluate(filterExpression.get("input"), document);
            Object as = 19.evaluate(filterExpression.getOrDefault("as", "this"), document);
            if (!(as instanceof String) || Objects.equals(as, "")) {
                throw new MongoServerError(16866, "empty variable names are not allowed");
            }
            if (Missing.isNullOrMissing(input)) {
                return null;
            }
            if (!(input instanceof Collection)) {
                throw new MongoServerError(28651, "input to " + this.name() + " must be an array not " + Utils.describeType(input));
            }
            Collection inputCollection = (Collection)input;
            String key = "$" + as;
            Document documentForCondition = document.clone();
            Assert.isFalse(documentForCondition.containsKey(key), () -> "Document already contains '" + key + "'");
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object inputValue : inputCollection) {
                Object evaluatedInputValue = 19.evaluate(inputValue, document);
                documentForCondition.put(key, evaluatedInputValue);
                if (!Utils.isTrue(19.evaluate(filterExpression.get("cond"), documentForCondition))) continue;
                result.add(evaluatedInputValue);
            }
            return result;
        }

        @Override
        Object apply(List<?> expressionValue, Document document) {
            throw new UnsupportedOperationException("must not be invoked");
        }
    }
    ,
    $floor{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateNumericValue(expressionValue, a -> Expression.toIntOrLong(Math.floor(a)));
        }
    }
    ,
    $gt{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateComparison(expressionValue, v -> v > 0);
        }
    }
    ,
    $gte{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateComparison(expressionValue, v -> v >= 0);
        }
    }
    ,
    $hour{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateTime(expressionValue, LocalTime::getHour, document);
        }
    }
    ,
    $ifNull{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoParameters parameters = this.requireTwoParameters(expressionValue);
            Object expression = parameters.getFirst();
            if (!Missing.isNullOrMissing(expression)) {
                return expression;
            }
            return parameters.getSecond();
        }
    }
    ,
    $in{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoParameters parameters = this.requireTwoParameters(expressionValue);
            Object needle = parameters.getFirst();
            Object haystack = parameters.getSecond();
            if (!(haystack instanceof Collection)) {
                throw new MongoServerError(40081, this.name() + " requires an array as a second argument, found: " + Utils.describeType(haystack));
            }
            return ((Collection)haystack).contains(needle);
        }
    }
    ,
    $indexOfArray{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            int index;
            if (expressionValue.size() < 2 || expressionValue.size() > 4) {
                throw new MongoServerError(28667, "Expression " + this.name() + " takes at least 2 arguments, and at most 4, but " + expressionValue.size() + " were passed in.");
            }
            Object first = expressionValue.get(0);
            if (Missing.isNullOrMissing(first)) {
                return null;
            }
            if (!(first instanceof List)) {
                throw new MongoServerError(40090, this.name() + " requires an array as a first argument, found: " + Utils.describeType(first));
            }
            List elementsToSearchIn = (List)first;
            int start = 0;
            if (expressionValue.size() >= 3) {
                Object startValue = expressionValue.get(2);
                start = this.requireIntegral(startValue, "starting index");
                start = Math.min(start, elementsToSearchIn.size());
            }
            int end = elementsToSearchIn.size();
            if (expressionValue.size() >= 4) {
                Object endValue = expressionValue.get(3);
                end = this.requireIntegral(endValue, "ending index");
                end = Math.min(Math.max(start, end), elementsToSearchIn.size());
            }
            if ((index = (elementsToSearchIn = elementsToSearchIn.subList(start, end)).indexOf(expressionValue.get(1))) >= 0) {
                return index + start;
            }
            return index;
        }
    }
    ,
    $indexOfBytes{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateIndexOf(expressionValue, this::toList, 40091, 40092);
        }

        private List<Byte> toList(String input) {
            ArrayList<Byte> bytes = new ArrayList<Byte>();
            for (byte value : input.getBytes(StandardCharsets.UTF_8)) {
                bytes.add(value);
            }
            return bytes;
        }
    }
    ,
    $indexOfCP{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateIndexOf(expressionValue, this::toList, 40093, 40094);
        }

        private List<Character> toList(String input) {
            ArrayList<Character> characters = new ArrayList<Character>();
            for (char value : input.toCharArray()) {
                characters.add(Character.valueOf(value));
            }
            return characters;
        }
    }
    ,
    $isArray{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            Object value = this.requireSingleValue(expressionValue);
            return value instanceof List;
        }
    }
    ,
    $literal{

        @Override
        Object apply(Object expressionValue, Document document) {
            return expressionValue;
        }

        @Override
        Object apply(List<?> expressionValue, Document document) {
            throw new UnsupportedOperationException("must not be invoked");
        }
    }
    ,
    $ln{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateNumericValue(expressionValue, Math::log);
        }
    }
    ,
    $log{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateNumericValue(expressionValue, Math::log);
        }
    }
    ,
    $log10{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateNumericValue(expressionValue, Math::log10);
        }
    }
    ,
    $lt{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateComparison(expressionValue, v -> v < 0);
        }
    }
    ,
    $lte{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateComparison(expressionValue, v -> v <= 0);
        }
    }
    ,
    $map{

        @Override
        Object apply(Object expressionValue, Document document) {
            Document filterExpression = this.requireDocument(expressionValue, 16878);
            List<String> requiredKeys = Arrays.asList("input", "in");
            for (String requiredKey : requiredKeys) {
                if (filterExpression.containsKey(requiredKey)) continue;
                throw new MongoServerError(16882, "Missing '" + requiredKey + "' parameter to " + this.name());
            }
            for (String key : filterExpression.keySet()) {
                if (Arrays.asList("input", "in", "as").contains(key)) continue;
                throw new MongoServerError(16879, "Unrecognized parameter to " + this.name() + ": " + key);
            }
            Object input = 36.evaluate(filterExpression.get("input"), document);
            Object as = 36.evaluate(filterExpression.getOrDefault("as", "this"), document);
            if (!(as instanceof String) || Objects.equals(as, "")) {
                throw new MongoServerError(16866, "empty variable names are not allowed");
            }
            if (Missing.isNullOrMissing(input)) {
                return null;
            }
            if (!(input instanceof Collection)) {
                throw new MongoServerError(16883, "input to " + this.name() + " must be an array not " + Utils.describeType(input));
            }
            Collection inputCollection = (Collection)input;
            String key = "$" + as;
            Document documentForCondition = document.clone();
            Assert.isFalse(documentForCondition.containsKey(key), () -> "Document already contains '" + key + "'");
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object inputValue : inputCollection) {
                Object evaluatedInputValue = 36.evaluate(inputValue, document);
                documentForCondition.put(key, evaluatedInputValue);
                result.add(36.evaluate(filterExpression.get("in"), documentForCondition));
            }
            return result;
        }

        @Override
        Object apply(List<?> expressionValue, Document document) {
            throw new UnsupportedOperationException("must not be invoked");
        }
    }
    ,
    $mergeObjects{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            Document result = new Document();
            for (Object value : expressionValue) {
                if (Missing.isNullOrMissing(value)) continue;
                if (!(value instanceof Document)) {
                    throw new MongoServerError(40400, "$mergeObjects requires object inputs, but input " + Json.toJsonValue(value) + " is of type " + Utils.describeType(value));
                }
                result.putAll((Document)value);
            }
            return result;
        }
    }
    ,
    $minute{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateTime(expressionValue, LocalTime::getMinute, document);
        }
    }
    ,
    $mod{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoNumericParameters parameters = this.requireTwoNumericParameters(expressionValue, 16611);
            if (parameters == null) {
                return null;
            }
            double a = parameters.getFirst();
            double b = parameters.getSecond();
            return a % b;
        }
    }
    ,
    $month{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateDate(expressionValue, date -> date.getMonth().getValue(), document);
        }
    }
    ,
    $multiply{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoNumericParameters parameters = this.requireTwoNumericParameters(expressionValue, 16555);
            if (parameters == null) {
                return null;
            }
            double a = parameters.getFirst();
            double b = parameters.getSecond();
            return a * b;
        }
    }
    ,
    $ne{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateComparison(expressionValue, v -> v != 0);
        }
    }
    ,
    $not{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            Object value = this.requireSingleValue(expressionValue);
            return !Utils.isTrue(value);
        }
    }
    ,
    $objectToArray{

        @Override
        List<Document> apply(List<?> expressionValue, Document document) {
            Object value = this.requireSingleValue(expressionValue);
            if (!(value instanceof Document)) {
                throw new MongoServerError(40390, this.name() + " requires a document input, found: " + Utils.describeType(value));
            }
            ArrayList<Document> result = new ArrayList<Document>();
            for (Map.Entry<String, Object> entry : ((Document)value).entrySet()) {
                Document keyValue = new Document();
                keyValue.append("k", entry.getKey());
                keyValue.append("v", entry.getValue());
                result.add(keyValue);
            }
            return result;
        }
    }
    ,
    $or{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            for (Object value : expressionValue) {
                if (!Utils.isTrue(value)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    $pow{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoParameters parameters = this.requireTwoParameters(expressionValue);
            if (parameters.isAnyNull()) {
                return null;
            }
            Object base = parameters.getFirst();
            Object exponent = parameters.getSecond();
            if (!(base instanceof Number)) {
                throw new MongoServerError(28762, this.name() + "'s base must be numeric, not " + Utils.describeType(base));
            }
            if (!(exponent instanceof Number)) {
                throw new MongoServerError(28763, this.name() + "'s exponent must be numeric, not " + Utils.describeType(exponent));
            }
            double a = ((Number)base).doubleValue();
            double b = ((Number)exponent).doubleValue();
            return Math.pow(a, b);
        }
    }
    ,
    $range{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            int step;
            if (expressionValue.size() < 2 || expressionValue.size() > 3) {
                throw new MongoServerError(28667, "Expression " + this.name() + " takes at least 2 arguments, and at most 3, but " + expressionValue.size() + " were passed in.");
            }
            Object first = expressionValue.get(0);
            Object second = expressionValue.get(1);
            int start = this.toInt(first, 34443, 34444, "starting value");
            int end = this.toInt(second, 34445, 34446, "ending value");
            if (expressionValue.size() > 2) {
                Object third = expressionValue.get(2);
                step = this.toInt(third, 34447, 34448, "step value");
                if (step == 0) {
                    throw new MongoServerError(34449, this.name() + " requires a non-zero step value");
                }
            } else {
                step = 1;
            }
            ArrayList<Integer> values = new ArrayList<Integer>();
            if (step > 0) {
                for (int i = start; i < end; i += step) {
                    values.add(i);
                }
            } else {
                for (int i = start; i > end; i += step) {
                    values.add(i);
                }
            }
            return values;
        }

        private int toInt(Object object, int errorCodeIfNotANumber, int errorCodeIfNonInt, String errorMessage) {
            if (!(object instanceof Number)) {
                throw new MongoServerError(errorCodeIfNotANumber, this.name() + " requires a numeric " + errorMessage + ", found value of type: " + Utils.describeType(object));
            }
            Number number = (Number)object;
            int value = number.intValue();
            if (number.doubleValue() != (double)value) {
                throw new MongoServerError(errorCodeIfNonInt, this.name() + " requires a " + errorMessage + " that can be represented as a 32-bit integer, found value: " + number);
            }
            return value;
        }
    }
    ,
    $reverseArray{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            Object value = this.requireSingleValue(expressionValue);
            if (Missing.isNullOrMissing(value)) {
                return null;
            }
            if (!(value instanceof Collection)) {
                throw new MongoServerError(34435, "The argument to " + this.name() + " must be an array, but was of type: " + Utils.describeType(value));
            }
            ArrayList list = new ArrayList((Collection)value);
            Collections.reverse(list);
            return list;
        }
    }
    ,
    $second{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateTime(expressionValue, LocalTime::getSecond, document);
        }
    }
    ,
    $setDifference{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoParameters parameters = this.requireTwoParameters(expressionValue);
            if (parameters.isAnyNull()) {
                return null;
            }
            Object first = parameters.getFirst();
            Object second = parameters.getSecond();
            if (!(first instanceof Collection)) {
                throw new MongoServerError(17048, "both operands of " + this.name() + " must be arrays. First argument is of type: " + Utils.describeType(first));
            }
            if (!(second instanceof Collection)) {
                throw new MongoServerError(17049, "both operands of " + this.name() + " must be arrays. First argument is of type: " + Utils.describeType(second));
            }
            LinkedTreeSet result = new LinkedTreeSet((Collection)first);
            result.removeAll((Collection)second);
            return result;
        }
    }
    ,
    $setEquals{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            if (expressionValue.size() < 2) {
                throw new MongoServerError(17045, this.name() + " needs at least two arguments had: " + expressionValue.size());
            }
            LinkedTreeSet objects = null;
            for (Object value : expressionValue) {
                if (!(value instanceof Collection)) {
                    throw new MongoServerError(17044, "All operands of " + this.name() + " must be arrays. One argument is of type: " + Utils.describeType(value));
                }
                LinkedTreeSet setValue = new LinkedTreeSet((Collection)value);
                if (objects == null) {
                    objects = setValue;
                    continue;
                }
                if (objects.containsAll(setValue) && setValue.containsAll(objects)) continue;
                return false;
            }
            return true;
        }
    }
    ,
    $setIntersection{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            LinkedTreeSet result = null;
            for (Object value : expressionValue) {
                if (Missing.isNullOrMissing(value)) {
                    return null;
                }
                if (!(value instanceof Collection)) {
                    throw new MongoServerError(17047, "All operands of " + this.name() + " must be arrays. One argument is of type: " + Utils.describeType(value));
                }
                Collection values = (Collection)value;
                if (result == null) {
                    result = new LinkedTreeSet(values);
                    continue;
                }
                result.retainAll(values);
            }
            if (result == null) {
                return Collections.emptySet();
            }
            return result;
        }
    }
    ,
    $setIsSubset{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoParameters parameters = this.requireTwoParameters(expressionValue);
            Object first = parameters.getFirst();
            Object second = parameters.getSecond();
            if (!(first instanceof Collection)) {
                throw new MongoServerError(17046, "both operands of " + this.name() + " must be arrays. First argument is of type: " + Utils.describeType(first));
            }
            if (!(second instanceof Collection)) {
                throw new MongoServerError(17042, "both operands of " + this.name() + " must be arrays. Second argument is of type: " + Utils.describeType(second));
            }
            LinkedTreeSet one = new LinkedTreeSet((Collection)first);
            LinkedTreeSet other = new LinkedTreeSet((Collection)second);
            return other.containsAll(one);
        }
    }
    ,
    $setUnion{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TreeSet<Object> result = new TreeSet<Object>(ValueComparator.asc());
            for (Object value : expressionValue) {
                if (Missing.isNullOrMissing(value)) {
                    return null;
                }
                if (!(value instanceof Collection)) {
                    throw new MongoServerError(17043, "All operands of " + this.name() + " must be arrays. One argument is of type: " + Utils.describeType(value));
                }
                result.addAll((Collection)value);
            }
            return result;
        }
    }
    ,
    $size{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            Object value = this.requireSingleValue(expressionValue);
            Collection<?> collection = this.requireArray(17124, value);
            return collection.size();
        }
    }
    ,
    $slice{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            List result;
            if (expressionValue.size() < 2 || expressionValue.size() > 3) {
                throw new MongoServerError(28667, "Expression " + this.name() + " takes at least 2 arguments, and at most 3, but " + expressionValue.size() + " were passed in.");
            }
            Object first = expressionValue.get(0);
            if (Missing.isNullOrMissing(first)) {
                return null;
            }
            if (!(first instanceof List)) {
                throw new MongoServerError(28724, "First argument to " + this.name() + " must be an array, but is of type: " + Utils.describeType(first));
            }
            List list = (List)first;
            Object second = expressionValue.get(1);
            if (!(second instanceof Number)) {
                throw new MongoServerError(28725, "Second argument to " + this.name() + " must be a numeric value, but is of type: " + Utils.describeType(second));
            }
            if (expressionValue.size() > 2) {
                Object third = expressionValue.get(2);
                if (!(third instanceof Number)) {
                    throw new MongoServerError(28725, "Third argument to " + this.name() + " must be numeric, but is of type: " + Utils.describeType(third));
                }
                Number number = (Number)third;
                if (number.intValue() < 0) {
                    throw new MongoServerError(28729, "Third argument to " + this.name() + " must be positive: " + third);
                }
                int position = ((Number)second).intValue();
                int offset = position >= 0 ? Math.min(position, list.size()) : Math.max(0, list.size() + position);
                result = list.subList(offset, Math.min(offset + number.intValue(), list.size()));
            } else {
                int n = ((Number)second).intValue();
                result = n >= 0 ? list.subList(0, Math.min(n, list.size())) : list.subList(Math.max(0, list.size() + n), list.size());
            }
            return result;
        }
    }
    ,
    $split{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoParameters parameters = this.requireTwoParameters(expressionValue);
            Object string = parameters.getFirst();
            Object delimiter = parameters.getSecond();
            if (Missing.isNullOrMissing(string)) {
                return null;
            }
            if (!(string instanceof String)) {
                throw new MongoServerError(40085, this.name() + " requires an expression that evaluates to a string as a first argument, found: " + Utils.describeType(string));
            }
            if (!(delimiter instanceof String)) {
                throw new MongoServerError(40086, this.name() + " requires an expression that evaluates to a string as a second argument, found: " + Utils.describeType(delimiter));
            }
            return ((String)string).split(Pattern.quote((String)delimiter));
        }
    }
    ,
    $subtract{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            TwoParameters parameters = this.requireTwoParameters(expressionValue);
            Object one = parameters.getFirst();
            Object other = parameters.getSecond();
            if (Missing.isNullOrMissing(one) || Missing.isNullOrMissing(other)) {
                return null;
            }
            if (!(one instanceof Number) || !(other instanceof Number)) {
                throw new MongoServerError(16556, "cant " + this.name() + " a " + Utils.describeType(one) + " from a " + Utils.describeType(other));
            }
            return Utils.subtractNumbers((Number)one, (Number)other);
        }
    }
    ,
    $sum{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            Object singleValue;
            if (expressionValue.size() == 1 && (singleValue = CollectionUtils.getSingleElement(expressionValue)) instanceof Collection) {
                return this.apply(singleValue, document);
            }
            Number sum = 0;
            for (Object value : expressionValue) {
                if (!(value instanceof Number)) continue;
                sum = Utils.addNumbers(sum, (Number)value);
            }
            return sum;
        }
    }
    ,
    $sqrt{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateNumericValue(expressionValue, Math::sqrt);
        }
    }
    ,
    $strLenBytes{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            String string = this.requireSingleStringValue(expressionValue);
            return string.getBytes(StandardCharsets.UTF_8).length;
        }
    }
    ,
    $strLenCP{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            String string = this.requireSingleStringValue(expressionValue);
            return string.length();
        }
    }
    ,
    $substr{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return $substrBytes.apply(expressionValue, document);
        }
    }
    ,
    $substrBytes{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            this.requireCollectionInSize(expressionValue, 3);
            String value = this.convertToString(expressionValue.get(0));
            if (value == null || value.isEmpty()) {
                return "";
            }
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            Object startValue = expressionValue.get(1);
            if (!(startValue instanceof Number)) {
                throw new MongoServerError(16034, this.name() + ":  starting index must be a numeric type (is BSON type " + Utils.describeType(startValue) + ")");
            }
            int startIndex = Math.max(0, ((Number)startValue).intValue());
            startIndex = Math.min(bytes.length, startIndex);
            Object lengthValue = expressionValue.get(2);
            if (!(lengthValue instanceof Number)) {
                throw new MongoServerError(16035, this.name() + ":  length must be a numeric type (is BSON type " + Utils.describeType(lengthValue) + ")");
            }
            int length = ((Number)lengthValue).intValue();
            if (length < 0) {
                length = bytes.length - startIndex;
            }
            length = Math.min(bytes.length, length);
            return new String(bytes, startIndex, length, StandardCharsets.UTF_8);
        }
    }
    ,
    $substrCP{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            this.requireCollectionInSize(expressionValue, 3);
            String value = this.convertToString(expressionValue.get(0));
            if (value == null || value.isEmpty()) {
                return "";
            }
            Object startValue = expressionValue.get(1);
            if (!(startValue instanceof Number)) {
                throw new MongoServerError(34450, this.name() + ": starting index must be a numeric type (is BSON type " + Utils.describeType(startValue) + ")");
            }
            int startIndex = Math.max(0, ((Number)startValue).intValue());
            startIndex = Math.min(value.length(), startIndex);
            Object lengthValue = expressionValue.get(2);
            if (!(lengthValue instanceof Number)) {
                throw new MongoServerError(34452, this.name() + ": length must be a numeric type (is BSON type " + Utils.describeType(lengthValue) + ")");
            }
            int length = ((Number)lengthValue).intValue();
            if (length < 0) {
                length = value.length() - startIndex;
            }
            int endIndex = Math.min(value.length(), startIndex + length);
            return value.substring(startIndex, endIndex);
        }
    }
    ,
    $toLower{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateString(expressionValue, String::toLowerCase);
        }
    }
    ,
    $toUpper{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateString(expressionValue, String::toUpperCase);
        }
    }
    ,
    $toString{

        @Override
        String apply(List<?> expressionValue, Document document) {
            return this.evaluateString(expressionValue, Function.identity());
        }
    }
    ,
    $trunc{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateNumericValue(expressionValue, a -> Expression.toIntOrLong(a.longValue()));
        }
    }
    ,
    $year{

        @Override
        Object apply(List<?> expressionValue, Document document) {
            return this.evaluateDate(expressionValue, LocalDate::getYear, document);
        }
    };


    Object apply(Object expressionValue, Document document) {
        ArrayList<Object> evaluatedValues = new ArrayList<Object>();
        if (!(expressionValue instanceof Collection)) {
            evaluatedValues.add(Expression.evaluate(expressionValue, document));
        } else {
            for (Object value : (Collection)expressionValue) {
                evaluatedValues.add(Expression.evaluate(value, document));
            }
        }
        return this.apply(evaluatedValues, document);
    }

    abstract Object apply(List<?> var1, Document var2);

    public static Object evaluateDocument(Object documentWithExpression, Document document) {
        Object evaluatedValue = Expression.evaluate(documentWithExpression, document);
        if (evaluatedValue instanceof Document) {
            Document projectedDocument = (Document)evaluatedValue;
            Document result = new Document();
            for (Map.Entry<String, Object> entry : projectedDocument.entrySet()) {
                String field = entry.getKey();
                Object expression = entry.getValue();
                result.put(field, Expression.evaluate(expression, document));
            }
            return result;
        }
        return evaluatedValue;
    }

    static Object evaluate(Object expression, Document document) {
        if (expression instanceof String && ((String)expression).startsWith("$")) {
            String value = ((String)expression).substring(1);
            if (value.startsWith("$")) {
                if (value.equals("$ROOT")) {
                    return document;
                }
                if (value.startsWith("$ROOT.")) {
                    String subKey = value.substring("$ROOT.".length());
                    return Utils.getSubdocumentValue(document, subKey);
                }
                Object subdocumentValue = Utils.getSubdocumentValue(document, value);
                if (!(subdocumentValue instanceof Missing)) {
                    return subdocumentValue;
                }
                String variable = value.substring(1);
                throw new MongoServerError(17276, "Use of undefined variable: " + variable);
            }
            return Utils.getSubdocumentValue(document, value);
        }
        if (expression instanceof Document) {
            return Expression.evaluateDocumentExpression((Document)expression, document);
        }
        return expression;
    }

    private static Object evaluateDocumentExpression(Document expression, Document document) {
        Document result = new Document();
        for (Map.Entry<String, Object> entry : expression.entrySet()) {
            String expressionKey = entry.getKey();
            Object expressionValue = entry.getValue();
            if (expressionKey.startsWith("$")) {
                Expression exp;
                if (expression.keySet().size() > 1) {
                    throw new MongoServerError(15983, "An object representing an expression must have exactly one field: " + expression);
                }
                try {
                    exp = Expression.valueOf(expressionKey);
                }
                catch (IllegalArgumentException ex) {
                    throw new MongoServerError(168, "InvalidPipelineOperator", "Unrecognized expression '" + expressionKey + "'");
                }
                return exp.apply(expressionValue, document);
            }
            result.put(expressionKey, expressionValue);
        }
        return result;
    }

    private static Number toIntOrLong(double value) {
        long number = (long)value;
        if (number < Integer.MIN_VALUE || number > Integer.MAX_VALUE) {
            return number;
        }
        return Math.toIntExact(number);
    }
}

