/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.PathNotViableException;
import de.bwaldvogel.mongo.wire.BsonEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Utils {
    public static final String PATH_DELIMITER = ".";
    private static final Pattern PATH_DELIMITER_PATTERN = Pattern.compile(Pattern.quote("."));

    private static void validateKey(String key) {
        if (key.endsWith(PATH_DELIMITER)) {
            throw new MongoServerError(40353, "FieldPath must not end with a '.'.");
        }
        if (key.startsWith(PATH_DELIMITER) || key.contains("..")) {
            throw new MongoServerError(15998, "FieldPath field names may not be empty strings.");
        }
    }

    public static Object getSubdocumentValue(Document document, String key) {
        return Utils.getSubdocumentValue(document, key, false);
    }

    public static Object getSubdocumentValueCollectionAware(Document document, String key) {
        return Utils.getSubdocumentValue(document, key, true);
    }

    private static Object getSubdocumentValue(Document document, String key, boolean handleCollections) {
        Utils.validateKey(key);
        List<String> pathFragments = Utils.splitPath(key);
        if (pathFragments.size() == 1) {
            return Utils.getFieldValueListSafe(document, CollectionUtils.getSingleElement(pathFragments));
        }
        String mainKey = pathFragments.get(0);
        String subKey = Utils.joinTail(pathFragments);
        Assert.doesNotStartWith(subKey, "$.");
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document) {
            return Utils.getSubdocumentValue((Document)subObject, subKey, handleCollections);
        }
        if (handleCollections && subObject instanceof Collection) {
            Collection values = (Collection)subObject;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : values) {
                if (o instanceof Document) {
                    Object subdocumentValue = Utils.getSubdocumentValue((Document)o, subKey, handleCollections);
                    if (subdocumentValue instanceof Collection) {
                        result.addAll((Collection)subdocumentValue);
                        continue;
                    }
                    result.add(subdocumentValue);
                    continue;
                }
                result.add(Missing.getInstance());
            }
            return result;
        }
        return Missing.getInstance();
    }

    public static String getDatabaseNameFromFullName(String fullName) {
        return Utils.firstFragment(fullName);
    }

    public static String getCollectionNameFromFullName(String fullName) {
        List<String> pathFragments = Utils.splitPath(fullName);
        return Utils.joinTail(pathFragments);
    }

    public static boolean isTrue(Object value) {
        if (Missing.isNullOrMissing(value)) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        return true;
    }

    static Object normalizeValue(Object value) {
        if (Missing.isNullOrMissing(value)) {
            return null;
        }
        if (value instanceof Number) {
            double doubleValue = ((Number)value).doubleValue();
            if (doubleValue == -0.0) {
                doubleValue = 0.0;
            }
            return doubleValue;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            Document result = new Document();
            for (Map.Entry entry : map.entrySet()) {
                result.put((String)entry.getKey(), Utils.normalizeValue(entry.getValue()));
            }
            return result;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.stream().map(Utils::normalizeValue).collect(Collectors.toList());
        }
        return value;
    }

    public static Number normalizeNumber(Number value) {
        if (value == null) {
            return null;
        }
        double doubleValue = value.doubleValue();
        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
            return doubleValue;
        }
        if ((double)value.intValue() == doubleValue) {
            return value.intValue();
        }
        if ((double)value.longValue() == doubleValue) {
            return value.longValue();
        }
        return doubleValue;
    }

    static boolean nullAwareEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (Missing.isNullOrMissing(a) && Missing.isNullOrMissing(b)) {
            return true;
        }
        if (Missing.isNullOrMissing(a) || Missing.isNullOrMissing(b)) {
            return false;
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            byte[] bytesA = (byte[])a;
            byte[] bytesB = (byte[])b;
            return Arrays.equals(bytesA, bytesB);
        }
        Object normalizedA = Utils.normalizeValue(a);
        Object normalizedB = Utils.normalizeValue(b);
        return Objects.equals(normalizedA, normalizedB);
    }

    static int calculateSize(Document document) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            new BsonEncoder().encodeDocument(document, buffer);
            int n = buffer.writerIndex();
            return n;
        }
        catch (IOException e) {
            throw new MongoServerException("Failed to calculate document size", e);
        }
        finally {
            buffer.release();
        }
    }

    static boolean containsQueryExpression(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof Document)) {
            return false;
        }
        Document doc = (Document)value;
        for (String key : doc.keySet()) {
            if (key.startsWith("$")) {
                return true;
            }
            if (!Utils.containsQueryExpression(doc.get(key))) continue;
            return true;
        }
        return false;
    }

    static Object getFieldValueListSafe(Object value, String field) throws IllegalArgumentException {
        if (Missing.isNullOrMissing(value)) {
            return Missing.getInstance();
        }
        if (field.equals("$") || field.contains(PATH_DELIMITER)) {
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (value instanceof List) {
            if (Utils.isNumeric(field)) {
                int pos = Integer.parseInt(field);
                List list = (List)value;
                if (pos >= 0 && pos < list.size()) {
                    return list.get(pos);
                }
                return Missing.getInstance();
            }
            return Missing.getInstance();
        }
        if (value instanceof Document) {
            Document document = (Document)value;
            return document.getOrMissing(field);
        }
        return Missing.getInstance();
    }

    private static boolean isNumeric(String value) {
        return value.chars().allMatch(Character::isDigit);
    }

    static boolean hasSubdocumentValue(Object document, String key) {
        List<String> pathFragments = Utils.splitPath(key);
        String mainKey = pathFragments.get(0);
        if (pathFragments.size() == 1) {
            return Utils.hasFieldValueListSafe(document, key);
        }
        String subKey = Utils.getSubkey(pathFragments, new AtomicReference<Integer>());
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document || subObject instanceof List) {
            return Utils.hasSubdocumentValue(subObject, subKey);
        }
        return false;
    }

    static boolean canFullyTraverseSubkeyForRename(Object document, String key) {
        List<String> pathFragments = Utils.splitPath(key);
        String mainKey = pathFragments.get(0);
        if (pathFragments.size() == 1) {
            return true;
        }
        String subKey = Utils.getSubkey(pathFragments, new AtomicReference<Integer>());
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document) {
            return Utils.canFullyTraverseSubkeyForRename(subObject, subKey);
        }
        return subObject instanceof Missing;
    }

    static String getSubkey(List<String> pathFragments, AtomicReference<Integer> matchPos) {
        String key = Utils.joinPath(pathFragments);
        if (key.matches(".*\\$(\\.).+\\$(\\.).*")) {
            throw new BadValueException("Too many positional (i.e. '$') elements found in path '" + key + "'");
        }
        String subKey = Utils.joinTail(pathFragments);
        if (subKey.matches("\\$(\\..+)?")) {
            if (matchPos == null || matchPos.get() == null) {
                throw new BadValueException("The positional operator did not find the match needed from the query.");
            }
            Integer pos = matchPos.getAndSet(null);
            return subKey.replaceFirst("\\$", String.valueOf(pos));
        }
        return subKey;
    }

    static boolean hasFieldValueListSafe(Object document, String field) throws IllegalArgumentException {
        if (document == null) {
            return false;
        }
        if (field.equals("$") || field.contains(PATH_DELIMITER)) {
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof List) {
            if (Utils.isNumeric(field)) {
                int pos = Integer.parseInt(field);
                List list = (List)document;
                return pos >= 0 && pos < list.size();
            }
            return false;
        }
        if (document instanceof Document) {
            return ((Document)document).containsKey(field);
        }
        throw new IllegalArgumentException("illegal document: " + document);
    }

    public static void markOkay(Document result) {
        result.put("ok", (Object)1.0);
    }

    private static void setListSafe(Object document, String key, String previousKey, Object obj) {
        if (document instanceof List) {
            int pos;
            List list = (List)document;
            try {
                pos = Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                String element = new Document(previousKey, document).toString(true);
                throw new PathNotViableException("Cannot create field '" + key + "' in element " + element);
            }
            while (list.size() <= pos) {
                list.add(null);
            }
            list.set(pos, obj);
        } else {
            Map documentAsMap = (Map)document;
            documentAsMap.put(key, obj);
        }
    }

    private static Object removeListSafe(Object document, String key) {
        if (document instanceof Document) {
            if (((Document)document).containsKey(key)) {
                return ((Document)document).remove(key);
            }
            return Missing.getInstance();
        }
        if (document instanceof List) {
            int pos;
            try {
                pos = Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                return Missing.getInstance();
            }
            List list = (List)document;
            if (list.size() > pos) {
                return list.set(pos, null);
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    public static String join(List<?> values, String delimiter) {
        return values.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    static void changeSubdocumentValue(Object document, String key, Object newValue, Integer matchPos) {
        Utils.changeSubdocumentValue(document, key, newValue, new AtomicReference<Integer>(matchPos));
    }

    public static void changeSubdocumentValue(Object document, String key, Object newValue) {
        Utils.changeSubdocumentValue(document, key, newValue, new AtomicReference<Integer>());
    }

    static void changeSubdocumentValue(Object document, String key, Object newValue, AtomicReference<Integer> matchPos) {
        Utils.changeSubdocumentValue(document, key, newValue, null, matchPos);
    }

    private static void changeSubdocumentValue(Object document, String key, Object newValue, String previousKey, AtomicReference<Integer> matchPos) {
        List<String> pathFragments = Utils.splitPath(key);
        String mainKey = pathFragments.get(0);
        if (pathFragments.size() == 1) {
            Utils.setListSafe(document, key, previousKey, newValue);
            return;
        }
        String subKey = Utils.getSubkey(pathFragments, matchPos);
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document || subObject instanceof List) {
            Utils.changeSubdocumentValue(subObject, subKey, newValue, mainKey, matchPos);
        } else {
            if (!Missing.isNullOrMissing(subObject)) {
                String element = new Document(mainKey, subObject).toString(true);
                String subKeyFirst = Utils.splitPath(subKey).get(0);
                throw new PathNotViableException("Cannot create field '" + subKeyFirst + "' in element " + element);
            }
            Document obj = new Document();
            Utils.changeSubdocumentValue(obj, subKey, newValue, mainKey, matchPos);
            Utils.setListSafe(document, mainKey, previousKey, obj);
        }
    }

    static Object removeSubdocumentValue(Object document, String key, Integer matchPos) {
        return Utils.removeSubdocumentValue(document, key, new AtomicReference<Integer>(matchPos));
    }

    public static Object removeSubdocumentValue(Object document, String key) {
        return Utils.removeSubdocumentValue(document, key, new AtomicReference<Integer>());
    }

    private static Object removeSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) {
        List<String> pathFragments = Utils.splitPath(key);
        String mainKey = pathFragments.get(0);
        if (pathFragments.size() == 1) {
            return Utils.removeListSafe(document, key);
        }
        String subKey = Utils.getSubkey(pathFragments, matchPos);
        Assert.notNullOrEmpty(subKey);
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document || subObject instanceof List) {
            return Utils.removeSubdocumentValue(subObject, subKey, matchPos);
        }
        return Missing.getInstance();
    }

    public static String describeType(Object value) {
        if (value == null) {
            return "null";
        }
        return Utils.describeType(value.getClass());
    }

    private static String describeType(Class<?> type) {
        if (Missing.class.isAssignableFrom(type)) {
            return "missing";
        }
        if (Document.class.isAssignableFrom(type)) {
            return "object";
        }
        if (String.class.isAssignableFrom(type)) {
            return "string";
        }
        if (Collection.class.isAssignableFrom(type)) {
            return "array";
        }
        if (Integer.class.isAssignableFrom(type)) {
            return "int";
        }
        if (Long.class.isAssignableFrom(type)) {
            return "long";
        }
        if (Double.class.isAssignableFrom(type)) {
            return "double";
        }
        return type.getName();
    }

    static Document cursorResponse(String ns, Document ... documents) {
        return Utils.cursorResponse(ns, Arrays.asList(documents));
    }

    static Document cursorResponse(String ns, Iterable<Document> documents) {
        ArrayList<Document> firstBatch = new ArrayList<Document>();
        for (Document document : documents) {
            firstBatch.add(document);
        }
        return Utils.cursorResponse(ns, firstBatch);
    }

    static Document cursorResponse(String ns, List<Document> firstBatch) {
        Document cursor = new Document();
        cursor.put("id", (Object)0L);
        cursor.put("ns", (Object)ns);
        cursor.put("firstBatch", (Object)firstBatch);
        Document response = new Document();
        response.put("cursor", (Object)cursor);
        Utils.markOkay(response);
        return response;
    }

    static String joinPath(String ... fragments) {
        return Stream.of(fragments).filter(fragment -> !fragment.isEmpty()).collect(Collectors.joining(PATH_DELIMITER));
    }

    public static String joinTail(List<String> pathFragments) {
        return pathFragments.stream().skip(1L).collect(Collectors.joining(PATH_DELIMITER));
    }

    static String joinPath(List<String> fragments) {
        return String.join((CharSequence)PATH_DELIMITER, fragments);
    }

    public static String firstFragment(String input) {
        List<String> fragments = Utils.splitPath(input);
        return fragments.get(0);
    }

    public static List<String> splitPath(String input) {
        return PATH_DELIMITER_PATTERN.splitAsStream(input).collect(Collectors.toList());
    }

    static List<String> getTail(List<String> pathFragments) {
        return pathFragments.subList(1, pathFragments.size());
    }

    public static String getShorterPathIfPrefix(String path1, String path2) {
        if (!path1.startsWith(path2) && !path2.startsWith(path1)) {
            return null;
        }
        List<String> fragments1 = Utils.splitPath(path1);
        List<String> fragments2 = Utils.splitPath(path2);
        ArrayList<String> commonFragments = new ArrayList<String>();
        for (int i = 0; i < Math.min(fragments1.size(), fragments2.size()); ++i) {
            String fragment2;
            String fragment1 = fragments1.get(i);
            if (!fragment1.equals(fragment2 = fragments2.get(i))) {
                return null;
            }
            commonFragments.add(fragment1);
        }
        Assert.notEmpty(commonFragments);
        return Utils.joinPath(commonFragments);
    }

    static String getLastFragment(String path) {
        List<String> fragments = Utils.splitPath(path);
        return fragments.get(fragments.size() - 1);
    }
}

