/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.BsonType;
import de.bwaldvogel.mongo.backend.Constants;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.QueryFilter;
import de.bwaldvogel.mongo.backend.QueryMatcher;
import de.bwaldvogel.mongo.backend.QueryOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.bson.BsonRegularExpression;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.FailedToParseException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQueryMatcher
implements QueryMatcher {
    private static final Logger log = LoggerFactory.getLogger(DefaultQueryMatcher.class);
    private Integer lastPosition;

    @Override
    public boolean matches(Document document, Document query) {
        for (String key : query.keySet()) {
            Object queryValue = query.get(key);
            this.validateQueryValue(queryValue, key);
            if (this.checkMatch(queryValue, key, (Object)document)) continue;
            return false;
        }
        return true;
    }

    private void validateQueryValue(Object queryValue, String key) {
        if (!(queryValue instanceof Document)) {
            return;
        }
        if (BsonRegularExpression.isRegularExpression(queryValue)) {
            return;
        }
        Document queryObject = (Document)queryValue;
        if (!queryObject.keySet().isEmpty() && queryObject.keySet().iterator().next().startsWith("$")) {
            for (String operator : queryObject.keySet()) {
                Collection values;
                Object value;
                QueryOperator queryOperator;
                if (Constants.REFERENCE_KEYS.contains(operator) || (queryOperator = QueryOperator.fromValue(operator)) != QueryOperator.TYPE || !((value = queryObject.get(operator)) instanceof Collection) || !(values = (Collection)value).isEmpty()) continue;
                throw new FailedToParseException(key + " must match at least one type");
            }
        }
    }

    @Override
    public synchronized Integer matchPosition(Document document, Document query) {
        this.lastPosition = null;
        for (String key : query.keySet()) {
            if (this.checkMatch(query.get(key), key, (Object)document)) continue;
            return null;
        }
        return this.lastPosition;
    }

    private List<String> splitKey(String key) {
        List<String> keys = Arrays.asList(key.split("\\.", -1));
        for (int i = 0; i < keys.size(); ++i) {
            if (!keys.get(i).isEmpty() || i == keys.size() - 1) continue;
            log.warn("Illegal key: '{}'", (Object)key);
            return Collections.singletonList(key);
        }
        return keys;
    }

    private boolean checkMatch(Object queryValue, String key, Object document) {
        return this.checkMatch(queryValue, this.splitKey(key), document);
    }

    private boolean checkMatch(Object queryValue, List<String> keys, Object value) {
        Object documentValue;
        Document document;
        if (keys.isEmpty()) {
            throw new MongoServerException("illegal keys: " + keys);
        }
        String firstKey = keys.get(0);
        if (firstKey.equals("$comment")) {
            log.debug("query comment: '{}'", queryValue);
            return true;
        }
        List<Object> subKeys = Collections.emptyList();
        if (keys.size() > 1) {
            subKeys = keys.subList(1, keys.size());
        }
        if (QueryFilter.isQueryFilter(firstKey)) {
            QueryFilter filter = QueryFilter.fromValue(firstKey);
            return this.checkMatch(queryValue, filter, value);
        }
        if (firstKey.startsWith("$") && !Constants.REFERENCE_KEYS.contains(firstKey)) {
            throw new BadValueException("unknown top level operator: " + firstKey);
        }
        if (value instanceof List) {
            Object allQuery;
            if (firstKey.matches("\\d+")) {
                Object listValue = Utils.getFieldValueListSafe(value, firstKey);
                if (subKeys.isEmpty()) {
                    return this.checkMatchesValue(queryValue, listValue);
                }
                return this.checkMatch(queryValue, subKeys, listValue);
            }
            if (firstKey.isEmpty()) {
                Assert.isEmpty(subKeys);
                return this.checkMatchesValue(queryValue, value);
            }
            if (queryValue instanceof Document && ((Document)queryValue).keySet().contains(QueryOperator.ALL.getValue()) && !this.checkMatchesAllDocuments(allQuery = ((Document)(queryValue = ((Document)queryValue).clone())).remove(QueryOperator.ALL.getValue()), keys, value)) {
                return false;
            }
            return this.checkMatchesAnyDocument(queryValue, keys, value);
        }
        if (!subKeys.isEmpty()) {
            Object subObject = Utils.getFieldValueListSafe(value, firstKey);
            return this.checkMatch(queryValue, subKeys, subObject);
        }
        if (Missing.isNullOrMissing(value)) {
            document = null;
            documentValue = Missing.getInstance();
        } else if (value instanceof Document) {
            document = (Document)value;
            documentValue = document.getOrMissing(firstKey);
        } else {
            return this.checkMatchesValue(queryValue, Missing.getInstance());
        }
        if (documentValue instanceof Collection) {
            Collection documentValues = (Collection)documentValue;
            if (queryValue instanceof Document) {
                Document queryDocument = (Document)queryValue;
                boolean matches = this.checkMatchesAnyValue(queryDocument, keys, document, documentValues);
                if (matches) {
                    return true;
                }
                if (DefaultQueryMatcher.isInQuery(queryDocument)) {
                    return this.checkMatchesValue(queryValue, documentValue);
                }
                return false;
            }
            if (queryValue instanceof Collection) {
                return this.checkMatchesValue(queryValue, documentValues);
            }
            if (this.checkMatchesAnyValue(queryValue, documentValues)) {
                return true;
            }
        }
        return this.checkMatchesValue(queryValue, documentValue);
    }

    private static boolean isInQuery(Document queryDocument) {
        return queryDocument.keySet().equals(Collections.singleton(QueryOperator.IN.getValue()));
    }

    private boolean checkMatchesAnyValue(Document queryValue, List<String> keys, Document document, Collection<?> value) {
        Set<String> keySet = queryValue.keySet();
        Document queryValueClone = queryValue.clone();
        for (String queryOperator : keySet) {
            Document sizeQuery;
            Document inQuery;
            Object subQuery = queryValueClone.remove(queryOperator);
            if (queryOperator.equals(QueryOperator.ALL.getValue())) {
                if (this.checkMatchesAllValues(subQuery, value)) continue;
                return false;
            }
            if (queryOperator.equals(QueryOperator.IN.getValue())) {
                inQuery = new Document(queryOperator, subQuery);
                if (this.checkMatchesAnyValue(inQuery, value)) continue;
                return false;
            }
            if (queryOperator.equals(QueryOperator.NOT_IN.getValue())) {
                inQuery = new Document(QueryOperator.IN.getValue(), subQuery);
                if (!this.checkMatchesAnyValue(inQuery, value)) continue;
                return false;
            }
            if (queryOperator.equals(QueryOperator.NOT.getValue())) {
                if (!this.checkMatch(subQuery, keys, (Object)document)) continue;
                return false;
            }
            if (queryOperator.equals(QueryOperator.NOT_EQUALS.getValue())) {
                Document equalQuery = new Document(QueryOperator.EQUAL.getValue(), subQuery);
                if (!(subQuery instanceof Collection ? this.checkMatchesValue(subQuery, value) : this.checkMatchesAnyValue(equalQuery, value))) continue;
                return false;
            }
            if (!(queryOperator.equals(QueryOperator.SIZE.getValue()) ? !this.checkMatchesValue(sizeQuery = new Document(QueryOperator.SIZE.getValue(), subQuery), value) : !this.checkMatchesAnyValue(queryValue, value) && !this.checkMatchesValue(queryValue, value))) continue;
            return false;
        }
        return true;
    }

    private boolean checkMatch(Object queryValue, QueryFilter filter, Object document) {
        if (filter == QueryFilter.EXPR) {
            Object result = Expression.evaluateDocument(queryValue, (Document)document);
            return Utils.isTrue(result);
        }
        if (!(queryValue instanceof List)) {
            throw new BadValueException("$and/$or/$nor must be a nonempty array");
        }
        List list = (List)queryValue;
        if (list.isEmpty()) {
            throw new BadValueException("$and/$or/$nor must be a nonempty array");
        }
        for (Object subqueryValue : list) {
            if (subqueryValue instanceof Document) continue;
            throw new MongoServerError(14817, (Object)((Object)filter) + " elements must be objects");
        }
        switch (filter) {
            case AND: {
                for (Object subqueryValue : list) {
                    if (this.matches((Document)document, (Document)subqueryValue)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Object subqueryValue : list) {
                    if (!this.matches((Document)document, (Document)subqueryValue)) continue;
                    return true;
                }
                return false;
            }
            case NOR: {
                return !this.checkMatch(queryValue, QueryFilter.OR, document);
            }
        }
        throw new MongoServerException("illegal query filter: " + (Object)((Object)filter) + ". must not happen");
    }

    private boolean checkMatchesAllDocuments(Object queryValue, List<String> keys, Object document) {
        for (Object query : (Collection)queryValue) {
            if (this.checkMatchesAnyDocument(query, keys, document)) continue;
            return false;
        }
        return true;
    }

    private boolean checkMatchesAnyDocument(Object queryValue, List<String> keys, Object document) {
        int i = 0;
        for (Object object : (Collection)document) {
            if (this.checkMatch(queryValue, keys, object)) {
                if (this.lastPosition == null) {
                    this.lastPosition = i;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean matchesValue(Object queryValue, Object value) {
        return this.checkMatchesValue(queryValue, value, false);
    }

    private boolean checkMatchesValue(Object queryValue, Object value) {
        return this.checkMatchesValue(queryValue, value, true);
    }

    private boolean checkMatchesValue(Object queryValue, Object value, boolean requireExactMatch) {
        if (BsonRegularExpression.isRegularExpression(queryValue)) {
            if (Missing.isNullOrMissing(value)) {
                return false;
            }
            BsonRegularExpression pattern = BsonRegularExpression.convertToRegularExpression(queryValue);
            Matcher matcher = pattern.matcher(value.toString());
            return matcher.find();
        }
        if (queryValue instanceof Document) {
            Document queryObject = (Document)queryValue;
            if (queryObject.keySet().equals(Constants.REFERENCE_KEYS)) {
                if (value instanceof Document) {
                    return this.matches((Document)value, queryObject);
                }
                return false;
            }
            if (requireExactMatch && value instanceof Document && queryObject.keySet().stream().noneMatch(key -> key.startsWith("$"))) {
                return Utils.nullAwareEquals(value, queryValue);
            }
            for (String key2 : queryObject.keySet()) {
                Object querySubvalue = queryObject.get(key2);
                if (key2.startsWith("$")) {
                    if (this.checkExpressionMatch(value, querySubvalue, key2)) continue;
                    return false;
                }
                if (Missing.isNullOrMissing(value) && querySubvalue == null) {
                    return false;
                }
                if (this.checkMatch(querySubvalue, key2, value)) continue;
                return false;
            }
            return true;
        }
        return Utils.nullAwareEquals(value, queryValue);
    }

    private boolean checkMatchesAllValues(Object queryValue, Object values) {
        if (!(queryValue instanceof Collection)) {
            return false;
        }
        Collection list = (Collection)values;
        Collection queryValues = (Collection)queryValue;
        if (queryValues.isEmpty()) {
            return false;
        }
        for (Object query : queryValues) {
            if (this.checkMatchesAnyValue(query, list)) continue;
            return false;
        }
        return true;
    }

    private boolean checkMatchesElemValues(Object queryValue, Object values) {
        if (!(queryValue instanceof Document)) {
            throw new BadValueException(QueryOperator.ELEM_MATCH.getValue() + " needs an Object");
        }
        if (!(values instanceof Collection)) {
            return false;
        }
        Collection list = (Collection)values;
        for (Object value : list) {
            if (!this.checkMatchesValue(queryValue, value, false)) continue;
            return true;
        }
        return false;
    }

    private boolean checkMatchesAnyValue(Object queryValue, Collection<?> values) {
        Document queryDocument;
        if (queryValue instanceof Document && (queryDocument = (Document)queryValue).keySet().equals(Collections.singleton(QueryOperator.ELEM_MATCH.getValue()))) {
            queryValue = queryDocument.get(QueryOperator.ELEM_MATCH.getValue());
        }
        int i = 0;
        for (Object value : values) {
            if (this.checkMatchesValue(queryValue, value)) {
                if (this.lastPosition == null) {
                    this.lastPosition = i;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkExpressionMatch(Object value, Object expressionValue, String operator) {
        if (QueryFilter.isQueryFilter(operator)) {
            QueryFilter filter = QueryFilter.fromValue(operator);
            return this.checkMatch(expressionValue, filter, value);
        }
        QueryOperator queryOperator = QueryOperator.fromValue(operator);
        switch (queryOperator) {
            case IN: {
                Collection queriedObjects = (Collection)expressionValue;
                for (Object o : queriedObjects) {
                    if (o instanceof BsonRegularExpression && value instanceof String) {
                        BsonRegularExpression pattern = (BsonRegularExpression)o;
                        if (!pattern.matcher((String)value).find()) continue;
                        return true;
                    }
                    if (value instanceof Collection && !(o instanceof Collection)) {
                        Collection values = (Collection)value;
                        return values.stream().anyMatch(v -> Utils.nullAwareEquals(o, v));
                    }
                    if (!Utils.nullAwareEquals(o, value)) continue;
                    return true;
                }
                return false;
            }
            case NOT: {
                return !this.checkMatchesValue(expressionValue, value);
            }
            case EQUAL: {
                return Utils.nullAwareEquals(value, expressionValue);
            }
            case NOT_EQUALS: {
                return !Utils.nullAwareEquals(value, expressionValue);
            }
            case NOT_IN: {
                return !this.checkExpressionMatch(value, expressionValue, "$in");
            }
            case EXISTS: {
                return value instanceof Missing != Utils.isTrue(expressionValue);
            }
            case GREATER_THAN: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return ValueComparator.desc().compare(value, expressionValue) < 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return ValueComparator.desc().compare(value, expressionValue) <= 0;
            }
            case LESS_THAN: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return ValueComparator.asc().compare(value, expressionValue) < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return ValueComparator.asc().compare(value, expressionValue) <= 0;
            }
            case MOD: {
                if (!(value instanceof Number)) {
                    return false;
                }
                List modValue = (List)expressionValue;
                return ((Number)value).intValue() % ((Number)modValue.get(0)).intValue() == ((Number)modValue.get(1)).intValue();
            }
            case SIZE: {
                double matchingSize;
                if (!(expressionValue instanceof Number)) {
                    throw new BadValueException("$size needs a number");
                }
                if (!(value instanceof Collection)) {
                    return false;
                }
                int listSize = ((Collection)value).size();
                return (double)listSize == (matchingSize = ((Number)expressionValue).doubleValue());
            }
            case ALL: {
                return false;
            }
            case TYPE: {
                return DefaultQueryMatcher.matchTypes(value, expressionValue);
            }
            case ELEM_MATCH: {
                return this.checkMatchesElemValues(expressionValue, value);
            }
        }
        throw new IllegalArgumentException("unhandled query operator: " + (Object)((Object)queryOperator));
    }

    static boolean matchTypes(Object value, Object expressionValue) {
        if (Objects.equals(expressionValue, "number")) {
            List types = Stream.of(BsonType.INT, BsonType.LONG, BsonType.DOUBLE, BsonType.DECIMAL128).map(BsonType::getAlias).collect(Collectors.toList());
            return DefaultQueryMatcher.matchTypes(value, types);
        }
        if (expressionValue instanceof String) {
            return DefaultQueryMatcher.matchTypes(value, BsonType.forString((String)expressionValue));
        }
        if (expressionValue instanceof Number) {
            return DefaultQueryMatcher.matchTypes(value, BsonType.forNumber((Number)expressionValue));
        }
        if (expressionValue instanceof Collection) {
            Collection values = (Collection)expressionValue;
            for (Object type : values) {
                if (!DefaultQueryMatcher.matchTypes(value, type)) continue;
                return true;
            }
            return false;
        }
        throw new MongoServerError(14, "type must be represented as a number or a string");
    }

    private static boolean matchTypes(Object value, BsonType type) {
        return type.matches(value);
    }

    private boolean comparableTypes(Object value1, Object value2) {
        value1 = Utils.normalizeValue(value1);
        value2 = Utils.normalizeValue(value2);
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.getClass().equals(value2.getClass());
    }
}

