/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.CollectionOptions;
import de.bwaldvogel.mongo.backend.QueryResult;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.MongoSilentServerException;
import de.bwaldvogel.mongo.exception.NamespaceExistsException;
import de.bwaldvogel.mongo.exception.NoReplicationEnabledException;
import de.bwaldvogel.mongo.exception.NoSuchCommandException;
import de.bwaldvogel.mongo.oplog.CollectionBackedOplog;
import de.bwaldvogel.mongo.oplog.NoopOplog;
import de.bwaldvogel.mongo.oplog.Oplog;
import de.bwaldvogel.mongo.wire.message.Message;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoGetMore;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoKillCursors;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoBackend
implements MongoBackend {
    private static final Logger log = LoggerFactory.getLogger(AbstractMongoBackend.class);
    protected static final String OPLOG_COLLECTION_NAME = "oplog.rs";
    private final Map<String, MongoDatabase> databases = new TreeMap<String, MongoDatabase>();
    private final List<Integer> version = Arrays.asList(3, 0, 0);
    private Clock clock = Clock.systemDefaultZone();
    protected Oplog oplog = NoopOplog.get();
    private int maxWireVersion = 2;
    private int minWireVersion = 0;

    private MongoDatabase resolveDatabase(Message message) {
        return this.resolveDatabase(message.getDatabaseName());
    }

    protected synchronized MongoDatabase resolveDatabase(String database) {
        MongoDatabase db = this.databases.get(database);
        if (db == null) {
            db = this.openOrCreateDatabase(database);
            log.info("created database {}", (Object)db.getDatabaseName());
            this.databases.put(database, db);
        }
        return db;
    }

    private Document getLog(String argument) {
        log.debug("getLog: {}", (Object)argument);
        Document response = new Document();
        switch (argument) {
            case "*": {
                response.put("names", (Object)Collections.singletonList("startupWarnings"));
                Utils.markOkay(response);
                break;
            }
            case "startupWarnings": {
                response.put("totalLinesWritten", (Object)0);
                response.put("log", (Object)new ArrayList());
                Utils.markOkay(response);
                break;
            }
            default: {
                throw new MongoSilentServerException("no RamLog named: " + argument);
            }
        }
        return response;
    }

    private Document handleAdminCommand(String command, Document query) {
        if (command.equalsIgnoreCase("listdatabases")) {
            Document response = new Document();
            ArrayList<Document> dbs = new ArrayList<Document>();
            for (String databaseName : this.listDatabaseNames()) {
                MongoDatabase db = this.openOrCreateDatabase(databaseName);
                Document dbObj = new Document("name", db.getDatabaseName());
                dbObj.put("empty", (Object)db.isEmpty());
                dbs.add(dbObj);
            }
            response.put("databases", (Object)dbs);
            Utils.markOkay(response);
            return response;
        }
        if (command.equalsIgnoreCase("find")) {
            String collectionName = (String)query.get(command);
            if (collectionName.equals("$cmd.sys.inprog")) {
                return Utils.cursorResponse(collectionName, new Document("inprog", Collections.emptyList()));
            }
            throw new NoSuchCommandException(new Document(command, collectionName).toString());
        }
        if (command.equalsIgnoreCase("replSetGetStatus")) {
            throw new NoReplicationEnabledException();
        }
        if (command.equalsIgnoreCase("getLog")) {
            Object argument = query.get(command);
            return this.getLog(argument == null ? null : argument.toString());
        }
        if (command.equalsIgnoreCase("renameCollection")) {
            return this.handleRenameCollection(command, query);
        }
        if (command.equalsIgnoreCase("getLastError")) {
            Document response = new Document();
            log.debug("getLastError on admin database");
            Utils.markOkay(response);
            return response;
        }
        if (command.equalsIgnoreCase("connectionStatus")) {
            Document response = new Document();
            response.append("authInfo", new Document().append("authenticatedUsers", Collections.emptyList()).append("authenticatedUserRoles", Collections.emptyList()));
            Utils.markOkay(response);
            return response;
        }
        if (command.equalsIgnoreCase("hostInfo")) {
            return this.handleHostInfo();
        }
        if (command.equalsIgnoreCase("getCmdLineOpts")) {
            return this.handleGetCmdLineOpts();
        }
        if (command.equalsIgnoreCase("getFreeMonitoringStatus")) {
            return this.handleGetFreeMonitoringStatus();
        }
        throw new NoSuchCommandException(command);
    }

    private Document handleHostInfo() {
        Document response = new Document();
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        response.append("os", new Document().append("type", osName).append("version", osVersion));
        response.append("system", new Document().append("currentTime", Instant.now()).append("hostname", Utils.getHostName()));
        response.append("extra", new Document().append("versionString", osName + " " + osVersion).append("kernelVersion", osVersion));
        Utils.markOkay(response);
        return response;
    }

    private Document handleGetCmdLineOpts() {
        Document response = new Document();
        response.append("argv", Collections.emptyList());
        response.append("parsed", new Document());
        Utils.markOkay(response);
        return response;
    }

    private Document handleGetFreeMonitoringStatus() {
        Document response = new Document();
        response.append("state", "undecided");
        Utils.markOkay(response);
        return response;
    }

    protected Set<String> listDatabaseNames() {
        return this.databases.keySet();
    }

    private Document handleRenameCollection(String command, Document query) {
        String oldNamespace = query.get(command).toString();
        String newNamespace = query.get("to").toString();
        boolean dropTarget = Utils.isTrue(query.get("dropTarget"));
        Document response = new Document();
        if (!oldNamespace.equals(newNamespace)) {
            MongoCollection<?> oldCollection = this.resolveCollection(oldNamespace);
            if (oldCollection == null) {
                throw new MongoServerException("source namespace does not exist");
            }
            String newDatabaseName = Utils.getDatabaseNameFromFullName(newNamespace);
            String newCollectionName = Utils.getCollectionNameFromFullName(newNamespace);
            MongoDatabase oldDatabase = this.resolveDatabase(oldCollection.getDatabaseName());
            MongoDatabase newDatabase = this.resolveDatabase(newDatabaseName);
            MongoCollection<?> newCollection = newDatabase.resolveCollection(newCollectionName, false);
            if (newCollection != null) {
                if (dropTarget) {
                    newDatabase.dropCollection(newCollectionName);
                } else {
                    throw new NamespaceExistsException("target namespace exists");
                }
            }
            newDatabase.moveCollection(oldDatabase, oldCollection, newCollectionName);
        }
        Utils.markOkay(response);
        return response;
    }

    private MongoCollection<?> resolveCollection(String namespace) {
        String databaseName = Utils.getDatabaseNameFromFullName(namespace);
        String collectionName = Utils.getCollectionNameFromFullName(namespace);
        MongoDatabase database = this.databases.get(databaseName);
        if (database == null) {
            return null;
        }
        return database.resolveCollection(collectionName, false);
    }

    protected abstract MongoDatabase openOrCreateDatabase(String var1);

    @Override
    public Document handleCommand(Channel channel, String databaseName, String command, Document query) {
        if (command.equalsIgnoreCase("whatsmyuri")) {
            Document response = new Document();
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
            response.put("you", (Object)(remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort()));
            Utils.markOkay(response);
            return response;
        }
        if (command.equalsIgnoreCase("ismaster")) {
            Document response = new Document("ismaster", Boolean.TRUE);
            response.put("maxBsonObjectSize", (Object)0x1000000);
            response.put("maxWriteBatchSize", (Object)1000);
            response.put("maxMessageSizeBytes", (Object)48000000);
            response.put("maxWireVersion", (Object)this.maxWireVersion);
            response.put("minWireVersion", (Object)this.minWireVersion);
            response.put("localTime", (Object)Instant.now(this.clock));
            Utils.markOkay(response);
            return response;
        }
        if (command.equalsIgnoreCase("buildinfo")) {
            Document response = new Document("version", Utils.join(this.version, "."));
            response.put("versionArray", (Object)this.version);
            response.put("maxBsonObjectSize", (Object)0x1000000);
            Utils.markOkay(response);
            return response;
        }
        if (command.equalsIgnoreCase("dropDatabase")) {
            return this.handleDropDatabase(databaseName);
        }
        if (databaseName.equals("admin")) {
            return this.handleAdminCommand(command, query);
        }
        MongoDatabase db = this.resolveDatabase(databaseName);
        return db.handleCommand(channel, command, query, this.oplog);
    }

    @Override
    public Collection<Document> getCurrentOperations(MongoQuery query) {
        return Collections.emptyList();
    }

    @Override
    public QueryResult handleQuery(MongoQuery query) {
        MongoDatabase db = this.resolveDatabase(query);
        return db.handleQuery(query);
    }

    @Override
    public QueryResult handleGetMore(MongoGetMore getMore) {
        MongoDatabase db = this.resolveDatabase(getMore);
        return db.handleGetMore(getMore);
    }

    @Override
    public void handleInsert(MongoInsert insert) {
        MongoDatabase db = this.resolveDatabase(insert);
        db.handleInsert(insert, this.oplog);
    }

    @Override
    public void handleDelete(MongoDelete delete) {
        MongoDatabase db = this.resolveDatabase(delete);
        db.handleDelete(delete, this.oplog);
    }

    @Override
    public void handleUpdate(MongoUpdate update) {
        MongoDatabase db = this.resolveDatabase(update);
        db.handleUpdate(update, this.oplog);
    }

    @Override
    public void handleKillCursors(MongoKillCursors killCursors) {
        this.databases.values().forEach(database -> database.handleKillCursors(killCursors));
    }

    protected Document handleDropDatabase(String databaseName) {
        this.dropDatabase(databaseName);
        Document response = new Document("dropped", databaseName);
        Utils.markOkay(response);
        return response;
    }

    @Override
    public void dropDatabase(String databaseName) {
        MongoDatabase removedDatabase = this.databases.remove(databaseName);
        removedDatabase.drop();
    }

    @Override
    public void handleClose(Channel channel) {
        for (MongoDatabase db : this.databases.values()) {
            db.handleClose(channel);
        }
    }

    @Override
    public void close() {
        log.info("closing {}", (Object)this);
        this.databases.clear();
    }

    @Override
    public List<Integer> getVersion() {
        return this.version;
    }

    public void setVersion(int major, int minor, int patch) {
        this.version.set(0, major);
        this.version.set(1, minor);
        this.version.set(2, patch);
    }

    public void setWireVersion(int maxWireVersion, int minWireVersion) {
        this.maxWireVersion = maxWireVersion;
        this.minWireVersion = minWireVersion;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Override
    public void disableOplog() {
        this.oplog = NoopOplog.get();
    }

    @Override
    public void enableOplog() {
        this.oplog = this.createOplog();
    }

    protected Oplog createOplog() {
        MongoDatabase localDatabase = this.resolveDatabase("local");
        MongoCollection<Document> collection = localDatabase.resolveCollection(OPLOG_COLLECTION_NAME, false);
        if (collection == null) {
            collection = localDatabase.createCollectionOrThrowIfExists(OPLOG_COLLECTION_NAME, CollectionOptions.withDefaults());
        }
        return new CollectionBackedOplog(this.getClock(), collection);
    }
}

