/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.bson;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.bson.Bson;
import java.security.SecureRandom;
import java.util.Arrays;

public class ObjectId
implements Bson,
Comparable<ObjectId> {
    private static final long serialVersionUID = 1L;
    private final byte[] data = new byte[12];
    private static final SecureRandom random = new SecureRandom();

    public ObjectId() {
        random.nextBytes(this.data);
    }

    public ObjectId(String hexString) {
        int len = hexString.length();
        Assert.equals(hexString.length(), (long)this.data.length * 2L);
        for (int i = 0; i < len; i += 2) {
            int first = Character.digit(hexString.charAt(i), 16) << 4;
            int second = Character.digit(hexString.charAt(i + 1), 16);
            this.data[i / 2] = (byte)(first + second);
        }
    }

    public ObjectId(byte[] data) {
        Assert.equals(data.length, 12L, () -> "Length must be 12 but was " + data.length);
        System.arraycopy(data, 0, this.data, 0, this.data.length);
    }

    public byte[] toByteArray() {
        return this.data;
    }

    @Override
    public int compareTo(ObjectId other) {
        byte[] byteArray = this.toByteArray();
        byte[] otherByteArray = other.toByteArray();
        for (int i = 0; i < 12; ++i) {
            if (byteArray[i] == otherByteArray[i]) continue;
            int thisByte = byteArray[i] & 0xFF;
            int otherByte = otherByteArray[i] & 0xFF;
            return thisByte < otherByte ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectId objectId = (ObjectId)o;
        return Arrays.equals(this.data, objectId.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getHexData() + "]";
    }

    public String getHexData() {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.data) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

