/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.oplog;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.bson.BsonTimestamp;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.oplog.OperationType;
import de.bwaldvogel.mongo.oplog.Oplog;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.UUID;

public class CollectionBackedOplog
implements Oplog {
    private static final long ELECTION_TERM = 1L;
    private final Clock clock;
    private final MongoCollection<Document> collection;
    private final UUID ui = UUID.randomUUID();

    public CollectionBackedOplog(Clock clock, MongoCollection<Document> collection) {
        this.clock = clock;
        this.collection = collection;
    }

    @Override
    public void handleInsert(String namespace, List<Document> documents) {
        if (this.isOplogCollection(namespace)) {
            return;
        }
        documents.stream().map(document -> this.toOplogDocument(OperationType.INSERT, namespace, (Document)document)).forEach(this.collection::addDocument);
    }

    @Override
    public void handleUpdate(String namespace, Document selector, Document query) {
        if (this.isOplogCollection(namespace)) {
            return;
        }
        this.collection.addDocument(this.toOplogDocument(OperationType.UPDATE, namespace, selector).append("o2", query));
    }

    @Override
    public void handleDelete(String namespace, Document query) {
        if (this.isOplogCollection(namespace)) {
            return;
        }
        this.collection.addDocument(this.toOplogDocument(OperationType.DELETE, namespace, query));
    }

    private Document toOplogDocument(OperationType operationType, String namespace, Document document) {
        Instant now = this.clock.instant();
        return new Document().append("ts", new BsonTimestamp(now)).append("t", 1L).append("h", 0L).append("v", 2L).append("op", operationType.getCode()).append("ns", namespace).append("ui", this.ui).append("wall", now).append("o", document.cloneDeeply());
    }

    private boolean isOplogCollection(String namespace) {
        return this.collection.getFullName().equals(namespace);
    }
}

