/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.oplog;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.bson.BsonTimestamp;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.oplog.OperationType;
import de.bwaldvogel.mongo.oplog.Oplog;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.UUID;

public class CollectionBackedOplog
implements Oplog {
    private static final long ELECTION_TERM = 1L;
    private final Clock clock;
    private final MongoCollection<Document> collection;
    private final UUID ui = UUID.randomUUID();

    public CollectionBackedOplog(Clock clock, MongoCollection<Document> collection) {
        this.clock = clock;
        this.collection = collection;
    }

    @Override
    public void handleInsert(String namespace, List<Document> documents) {
        if (this.isOplogCollection(namespace)) {
            return;
        }
        documents.stream().map(document -> this.toOplogInsertDocument(namespace, (Document)document)).forEach(this.collection::addDocument);
    }

    @Override
    public void handleUpdate(String namespace, Document selector, Document query, List<Object> modifiedIds) {
        if (this.isOplogCollection(namespace)) {
            return;
        }
        modifiedIds.forEach(id -> this.collection.addDocument(this.toOplogUpdateDocument(namespace, query, id)));
    }

    @Override
    public void handleDelete(String namespace, Document query, List<Object> deletedIds) {
        if (this.isOplogCollection(namespace)) {
            return;
        }
        deletedIds.forEach(id -> this.collection.addDocument(this.toOplogDeleteDocument(namespace, id)));
    }

    private Document toOplogDocument(OperationType operationType, String namespace) {
        Instant now = this.clock.instant();
        return new Document().append("ts", new BsonTimestamp(now)).append("t", 1L).append("h", 0L).append("v", 2L).append("op", operationType.getCode()).append("ns", namespace).append("ui", this.ui).append("wall", now);
    }

    private Document toOplogInsertDocument(String namespace, Document document) {
        return this.toOplogDocument(OperationType.INSERT, namespace).append("o", document.cloneDeeply());
    }

    private Document toOplogUpdateDocument(String namespace, Document query, Object id) {
        return this.toOplogDocument(OperationType.UPDATE, namespace).append("o", query).append("o2", new Document("_id", id));
    }

    private Document toOplogDeleteDocument(String namespace, Object deletedDocumentId) {
        return this.toOplogDocument(OperationType.DELETE, namespace).append("o", new Document("_id", deletedDocumentId));
    }

    private boolean isOplogCollection(String namespace) {
        return this.collection.getFullName().equals(namespace);
    }
}

