/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoThreadFactory;
import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.wire.MongoDatabaseHandler;
import de.bwaldvogel.mongo.wire.MongoExceptionHandler;
import de.bwaldvogel.mongo.wire.MongoWireMessageEncoder;
import de.bwaldvogel.mongo.wire.MongoWireProtocolHandler;
import de.bwaldvogel.mongo.wire.MongoWireReplyEncoder;
import de.bwaldvogel.mongo.wire.message.MongoKillCursors;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoServer {
    private static final Logger log = LoggerFactory.getLogger(MongoServer.class);
    private static final int DEFAULT_NETTY_EVENT_LOOP_THREADS = 0;
    private final MongoBackend backend;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ChannelGroup channelGroup;
    private Channel channel;
    private SslContext sslContext;

    public MongoServer(MongoBackend backend) {
        this.backend = backend;
    }

    public MongoServer withOplogEnabled() {
        this.backend.enableOplog();
        return this;
    }

    public void enableSsl(PrivateKey key, String keyPassword, X509Certificate ... keyCertChain) {
        Assert.isNull(this.channel, () -> "Server already started");
        try {
            this.sslContext = SslContextBuilder.forServer((PrivateKey)key, (String)keyPassword, (X509Certificate[])keyCertChain).build();
        }
        catch (SSLException e) {
            throw new RuntimeException("Failed to enable SSL", e);
        }
    }

    public void bind(String hostname, int port) {
        this.bind(new InetSocketAddress(hostname, port));
    }

    public void bind(SocketAddress socketAddress) {
        this.bind(socketAddress, 0, 0);
    }

    public void bind(SocketAddress socketAddress, int numberOfBossThreads, int numberOfWorkerThreads) {
        this.bossGroup = new NioEventLoopGroup(numberOfBossThreads, (ThreadFactory)new MongoThreadFactory("mongo-server-boss"));
        this.workerGroup = new NioEventLoopGroup(numberOfWorkerThreads, (ThreadFactory)new MongoThreadFactory("mongo-server-worker"));
        this.channelGroup = new DefaultChannelGroup("mongodb-channels", (EventExecutor)this.workerGroup.next());
        try {
            ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).localAddress(socketAddress)).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    if (MongoServer.this.sslContext != null) {
                        ch.pipeline().addLast(new ChannelHandler[]{MongoServer.this.sslContext.newHandler(ch.alloc())});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new MongoWireReplyEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new MongoWireMessageEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new MongoWireProtocolHandler()});
                    ch.pipeline().addLast(new ChannelHandler[]{new MongoDatabaseHandler(MongoServer.this.backend, MongoServer.this.channelGroup)});
                    ch.pipeline().addLast(new ChannelHandler[]{new MongoExceptionHandler()});
                }
            });
            this.channel = bootstrap.bind().syncUninterruptibly().channel();
            log.info("started {}", (Object)this);
        }
        catch (RuntimeException e) {
            this.shutdownNow();
            throw e;
        }
    }

    public InetSocketAddress bind() {
        this.bind(new InetSocketAddress("localhost", 0));
        return this.getLocalAddress();
    }

    public InetSocketAddress getLocalAddress() {
        if (this.channel == null) {
            return null;
        }
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void shutdown() {
        this.stopListening();
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        }
        if (this.bossGroup != null) {
            this.bossGroup.terminationFuture().syncUninterruptibly();
        }
        if (this.workerGroup != null) {
            this.workerGroup.terminationFuture().syncUninterruptibly();
        }
        this.backend.close();
        log.info("completed shutdown of {}", (Object)this);
    }

    public void stopListening() {
        if (this.channel != null) {
            log.info("closing server channel");
            this.channel.close().syncUninterruptibly();
            this.channel = null;
        }
    }

    public void shutdownNow() {
        this.stopListening();
        this.closeClients();
        this.shutdown();
    }

    private void closeClients() {
        if (this.channelGroup != null) {
            int numClients = this.channelGroup.size();
            if (numClients > 0) {
                log.warn("Closing {} clients", (Object)numClients);
            }
            this.channelGroup.close().syncUninterruptibly();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(");
        InetSocketAddress socketAddress = this.getLocalAddress();
        if (socketAddress != null) {
            sb.append("port: ").append(socketAddress.getPort());
            sb.append(", ssl: ").append(this.sslContext != null);
        }
        sb.append(")");
        return sb.toString();
    }

    public void closeCursors(MongoKillCursors killCursors) {
        this.backend.handleKillCursors(killCursors);
    }
}

