/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.accumulator;

import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.AddToSetAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.AvgAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.FirstAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.LastAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.MaxAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.MinAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.PushAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.SumAccumulator;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public abstract class Accumulator {
    private final String field;
    private final Object expression;

    Accumulator(String field, Object expression) {
        this.field = field;
        this.expression = expression;
    }

    public static Map<String, Supplier<Accumulator>> parse(Document configuration) {
        LinkedHashMap<String, Supplier<Accumulator>> accumulators = new LinkedHashMap<String, Supplier<Accumulator>>();
        for (Map.Entry<String, Object> accumulatorEntry : configuration.entrySet()) {
            if (accumulatorEntry.getKey().equals("_id")) continue;
            String field = accumulatorEntry.getKey();
            Document entryValue = (Document)accumulatorEntry.getValue();
            Map.Entry<String, Object> aggregation = CollectionUtils.getSingleElement(entryValue.entrySet(), () -> {
                throw new MongoServerError(40238, "The field '" + field + "' must specify one accumulator");
            });
            String groupOperator = aggregation.getKey();
            Object expression = aggregation.getValue();
            if (groupOperator.equals("$sum")) {
                accumulators.put(field, () -> new SumAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$min")) {
                accumulators.put(field, () -> new MinAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$max")) {
                accumulators.put(field, () -> new MaxAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$avg")) {
                accumulators.put(field, () -> new AvgAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$addToSet")) {
                accumulators.put(field, () -> new AddToSetAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$push")) {
                accumulators.put(field, () -> new PushAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$first")) {
                accumulators.put(field, () -> new FirstAccumulator(field, expression));
                continue;
            }
            if (groupOperator.equals("$last")) {
                accumulators.put(field, () -> new LastAccumulator(field, expression));
                continue;
            }
            throw new MongoServerError(15952, "unknown group operator '" + groupOperator + "'");
        }
        return accumulators;
    }

    public String getField() {
        return this.field;
    }

    public Object getExpression() {
        return this.expression;
    }

    public abstract void aggregate(Object var1);

    public abstract Object getResult();
}

