/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.backend.QueryResult;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.CursorNotFoundException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.NoSuchCommandException;
import de.bwaldvogel.mongo.wire.MongoWireProtocolHandler;
import de.bwaldvogel.mongo.wire.ReplyFlag;
import de.bwaldvogel.mongo.wire.message.ClientRequest;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoGetMore;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoKillCursors;
import de.bwaldvogel.mongo.wire.message.MongoMessage;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoReply;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDatabaseHandler
extends SimpleChannelInboundHandler<ClientRequest> {
    private static final Logger log = LoggerFactory.getLogger(MongoWireProtocolHandler.class);
    private final AtomicInteger idSequence = new AtomicInteger();
    private final MongoBackend mongoBackend;
    private final ChannelGroup channelGroup;

    public MongoDatabaseHandler(MongoBackend mongoBackend, ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        this.mongoBackend = mongoBackend;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channelGroup.add((Object)ctx.channel());
        log.info("client {} connected", (Object)ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        log.info("channel {} closed", (Object)ctx.channel());
        this.channelGroup.remove((Object)ctx.channel());
        this.mongoBackend.handleClose(ctx.channel());
        super.channelInactive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ClientRequest object) {
        if (object instanceof MongoQuery) {
            MongoQuery mongoQuery = (MongoQuery)object;
            ctx.channel().writeAndFlush((Object)this.handleQuery(mongoQuery));
        } else if (object instanceof MongoInsert) {
            MongoInsert insert = (MongoInsert)object;
            this.mongoBackend.handleInsert(insert);
        } else if (object instanceof MongoDelete) {
            MongoDelete delete = (MongoDelete)object;
            this.mongoBackend.handleDelete(delete);
        } else if (object instanceof MongoUpdate) {
            MongoUpdate update = (MongoUpdate)object;
            this.mongoBackend.handleUpdate(update);
        } else if (object instanceof MongoGetMore) {
            MongoGetMore getMore = (MongoGetMore)object;
            ctx.channel().writeAndFlush((Object)this.handleGetMore(getMore));
        } else if (object instanceof MongoKillCursors) {
            this.handleKillCursors((MongoKillCursors)object);
        } else if (object instanceof MongoMessage) {
            MongoMessage message = (MongoMessage)object;
            ctx.channel().writeAndFlush((Object)this.handleMessage(message));
        } else {
            throw new MongoServerException("unknown message: " + object);
        }
    }

    private MongoMessage handleMessage(MongoMessage message) {
        Document document;
        try {
            document = this.mongoBackend.handleMessage(message);
        }
        catch (MongoServerException e) {
            if (e.isLogError()) {
                log.error("failed to handle {}", (Object)message.getDocument(), (Object)e);
            }
            document = this.errorResponse(e, Collections.emptyMap());
        }
        MessageHeader header = this.createResponseHeader(message);
        return new MongoMessage(message.getChannel(), header, document);
    }

    private MongoReply handleQuery(MongoQuery query) {
        MessageHeader header = this.createResponseHeader(query);
        try {
            QueryResult queryResult = null;
            ArrayList<Document> documents = new ArrayList<Document>();
            if (query.getCollectionName().startsWith("$cmd")) {
                documents.add(this.handleCommand(query));
            } else {
                queryResult = this.mongoBackend.handleQuery(query);
                documents.addAll(queryResult.collectDocuments());
            }
            return new MongoReply(header, documents, queryResult == null ? 0L : queryResult.getCursorId(), new ReplyFlag[0]);
        }
        catch (NoSuchCommandException e) {
            log.error("unknown command: {}", (Object)query, (Object)e);
            Map<String, Document> additionalInfo = Collections.singletonMap("bad cmd", query.getQuery());
            return this.queryFailure(header, e, additionalInfo);
        }
        catch (MongoServerException e) {
            if (e.isLogError()) {
                log.error("failed to handle query {}", (Object)query, (Object)e);
            }
            return this.queryFailure(header, e);
        }
    }

    public MongoReply handleGetMore(MongoGetMore getMore) {
        QueryResult queryResult;
        MessageHeader header = new MessageHeader(this.idSequence.incrementAndGet(), getMore.getHeader().getRequestID());
        ArrayList<Document> documents = new ArrayList<Document>();
        try {
            queryResult = this.mongoBackend.handleGetMore(getMore);
        }
        catch (CursorNotFoundException cursorNotFoundException) {
            return new MongoReply(header, documents, getMore.getCursorId(), ReplyFlag.CURSOR_NOT_FOUND);
        }
        for (Document obj : queryResult) {
            documents.add(obj);
        }
        return new MongoReply(header, documents, queryResult.getCursorId(), new ReplyFlag[0]);
    }

    public void handleKillCursors(MongoKillCursors mongoKillCursors) {
        this.mongoBackend.handleKillCursors(mongoKillCursors);
    }

    private MessageHeader createResponseHeader(ClientRequest request) {
        return new MessageHeader(this.idSequence.incrementAndGet(), request.getHeader().getRequestID());
    }

    private MongoReply queryFailure(MessageHeader header, MongoServerException exception) {
        Map additionalInfo = Collections.emptyMap();
        return this.queryFailure(header, exception, additionalInfo);
    }

    private MongoReply queryFailure(MessageHeader header, MongoServerException exception, Map<String, ?> additionalInfo) {
        Document obj = this.errorResponse(exception, additionalInfo);
        return new MongoReply(header, obj, ReplyFlag.QUERY_FAILURE);
    }

    private Document errorResponse(MongoServerException exception, Map<String, ?> additionalInfo) {
        Document obj = new Document();
        obj.put("$err", (Object)exception.getMessageWithoutErrorCode());
        obj.put("errmsg", (Object)exception.getMessageWithoutErrorCode());
        if (exception instanceof MongoServerError) {
            MongoServerError error = (MongoServerError)exception;
            obj.put("code", (Object)error.getCode());
            obj.putIfNotNull("codeName", error.getCodeName());
        }
        obj.putAll((Map<? extends String, ?>)additionalInfo);
        obj.put("ok", (Object)0);
        return obj;
    }

    Document handleCommand(MongoQuery query) {
        String collectionName = query.getCollectionName();
        if (collectionName.equals("$cmd.sys.inprog")) {
            Collection<Document> currentOperations = this.mongoBackend.getCurrentOperations(query);
            return new Document("inprog", currentOperations);
        }
        if (collectionName.equals("$cmd")) {
            String command;
            switch (command = query.getQuery().keySet().iterator().next()) {
                case "serverStatus": {
                    return this.mongoBackend.getServerStatus();
                }
                case "ping": {
                    Document response = new Document();
                    Utils.markOkay(response);
                    return response;
                }
            }
            Document actualQuery = query.getQuery();
            if (command.equals("$query")) {
                command = ((Document)query.getQuery().get("$query")).keySet().iterator().next();
                actualQuery = (Document)actualQuery.get("$query");
            }
            return this.mongoBackend.handleCommand(query.getChannel(), query.getDatabaseName(), command, actualQuery);
        }
        throw new MongoServerException("unknown collection: " + collectionName);
    }
}

