/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import de.bwaldvogel.mongo.AsyncMongoDatabase;
import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.CollectionOptions;
import de.bwaldvogel.mongo.backend.QueryResult;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.oplog.Oplog;
import de.bwaldvogel.mongo.util.FutureUtils;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import io.netty.channel.Channel;
import java.util.concurrent.CompletionStage;

public interface MongoDatabase
extends AsyncMongoDatabase {
    public String getDatabaseName();

    public void handleClose(Channel var1);

    public Document handleCommand(Channel var1, String var2, Document var3, Oplog var4);

    @Override
    default public CompletionStage<Document> handleCommandAsync(Channel channel, String command, Document query, Oplog oplog) {
        return FutureUtils.wrap(() -> this.handleCommand(channel, command, query, oplog));
    }

    public QueryResult handleQuery(MongoQuery var1);

    @Override
    default public CompletionStage<QueryResult> handleQueryAsync(MongoQuery query) {
        return FutureUtils.wrap(() -> this.handleQuery(query));
    }

    public void handleInsert(MongoInsert var1, Oplog var2);

    @Override
    default public CompletionStage<Void> handleInsertAsync(MongoInsert insert, Oplog oplog) {
        return FutureUtils.wrap(() -> {
            this.handleInsert(insert, oplog);
            return null;
        });
    }

    public void handleDelete(MongoDelete var1, Oplog var2);

    @Override
    default public CompletionStage<Void> handleDeleteAsync(MongoDelete delete, Oplog oplog) {
        return FutureUtils.wrap(() -> {
            this.handleDelete(delete, oplog);
            return null;
        });
    }

    public void handleUpdate(MongoUpdate var1, Oplog var2);

    @Override
    default public CompletionStage<Void> handleUpdateAsync(MongoUpdate update, Oplog oplog) {
        return FutureUtils.wrap(() -> {
            this.handleUpdate(update, oplog);
            return null;
        });
    }

    public boolean isEmpty();

    public MongoCollection<?> createCollectionOrThrowIfExists(String var1, CollectionOptions var2);

    public MongoCollection<?> resolveCollection(String var1, boolean var2);

    public void drop(Oplog var1);

    public void dropCollection(String var1, Oplog var2);

    public void moveCollection(MongoDatabase var1, MongoCollection<?> var2, String var3);

    public void unregisterCollection(String var1);
}

