/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.ArrayFilters;
import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.DefaultQueryMatcher;
import de.bwaldvogel.mongo.backend.DocumentComparator;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.NumericUtils;
import de.bwaldvogel.mongo.backend.QueryMatcher;
import de.bwaldvogel.mongo.backend.UpdateOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.bson.BsonTimestamp;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.Json;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.ConflictingUpdateOperatorsException;
import de.bwaldvogel.mongo.exception.FailedToParseException;
import de.bwaldvogel.mongo.exception.ImmutableFieldException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.PathNotViableException;
import de.bwaldvogel.mongo.exception.TypeMismatchException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

class FieldUpdates {
    private final QueryMatcher matcher = new DefaultQueryMatcher();
    private final Map<String, String> renames = new LinkedHashMap<String, String>();
    private final Document document;
    private final String idField;
    private final UpdateOperator updateOperator;
    private final boolean upsert;
    private final Integer matchPos;
    private final ArrayFilters arrayFilters;

    FieldUpdates(Document document, UpdateOperator updateOperator, String idField, boolean upsert, Integer matchPos, ArrayFilters arrayFilters) {
        this.document = document;
        this.idField = idField;
        this.updateOperator = updateOperator;
        this.upsert = upsert;
        this.matchPos = matchPos;
        this.arrayFilters = arrayFilters;
    }

    void apply(Document change, String modifier) {
        for (String key : change.keySet()) {
            Object value = change.get(key);
            if (this.arrayFilters.canHandle(key)) {
                List<String> arrayKeys = this.arrayFilters.calculateKeys(this.document, key);
                for (String arrayKey : arrayKeys) {
                    this.apply(change, modifier, arrayKey, value);
                }
                continue;
            }
            this.apply(change, modifier, key, value);
        }
        this.applyRenames();
    }

    private void apply(Document change, String modifier, String key, Object value) {
        switch (this.updateOperator) {
            case SET_ON_INSERT: {
                if (!this.isUpsert()) {
                    return;
                }
            }
            case SET: {
                this.handleSet(key, value);
                break;
            }
            case UNSET: {
                this.handleUnset(key);
                break;
            }
            case PUSH: {
                this.handlePush(key, value);
                break;
            }
            case ADD_TO_SET: {
                this.handleAddToSet(key, value);
                break;
            }
            case PULL: 
            case PULL_ALL: {
                this.handlePull(modifier, key, value);
                break;
            }
            case POP: {
                this.handlePop(modifier, key, value);
                break;
            }
            case INC: 
            case MUL: {
                this.handleIncMul(change, key, value);
                break;
            }
            case MIN: 
            case MAX: {
                this.handleMinMax(key, value);
                break;
            }
            case CURRENT_DATE: {
                this.handleCurrentDate(key, value);
                break;
            }
            case RENAME: {
                this.handleRename(key, value);
                break;
            }
            default: {
                throw new MongoServerError(10147, "Unsupported modifier: " + modifier);
            }
        }
    }

    private List<Object> getListOrThrow(String key, Function<Object, MongoServerError> errorSupplier) {
        Object value = this.getSubdocumentValue(this.document, key);
        if (Missing.isNullOrMissing(value)) {
            return new ArrayList<Object>();
        }
        if (value instanceof List) {
            return FieldUpdates.asList(value);
        }
        throw errorSupplier.apply(value);
    }

    private void handlePush(String key, Object changeValue) {
        List<Object> existingValue = this.getListOrThrow(key, value -> new BadValueException("The field '" + key + "' must be an array but is of type " + Utils.describeType(value) + " in document {" + "_id" + ": " + this.document.get("_id") + "}"));
        ArrayList<Object> newValues = new ArrayList<Object>();
        Integer slice = null;
        Comparator<Object> comparator = null;
        int position = existingValue.size();
        if (changeValue instanceof Document && ((Document)changeValue).containsKey("$each")) {
            Document pushDocument = (Document)changeValue;
            block12: for (Map.Entry<String, Object> entry : pushDocument.entrySet()) {
                String modifier;
                switch (modifier = entry.getKey()) {
                    case "$each": {
                        Collection values = (Collection)entry.getValue();
                        newValues.addAll(values);
                        continue block12;
                    }
                    case "$slice": {
                        Object sliceValue = entry.getValue();
                        if (!(sliceValue instanceof Number)) {
                            throw new BadValueException("The value for $slice must be an integer value but was given type: " + Utils.describeType(sliceValue));
                        }
                        slice = ((Number)sliceValue).intValue();
                        continue block12;
                    }
                    case "$sort": {
                        Object sortValue = Utils.normalizeValue(entry.getValue());
                        if (sortValue instanceof Number) {
                            Number sortOrder = Utils.normalizeNumber((Number)sortValue);
                            if (sortOrder.equals(1)) {
                                comparator = ValueComparator.asc();
                            } else if (sortOrder.equals(-1)) {
                                comparator = ValueComparator.desc();
                            }
                        } else if (sortValue instanceof Document) {
                            ValueComparator valueComparator = ValueComparator.asc();
                            DocumentComparator documentComparator = new DocumentComparator((Document)sortValue);
                            comparator = (o1, o2) -> {
                                if (o1 instanceof Document && o2 instanceof Document) {
                                    return documentComparator.compare((Document)o1, (Document)o2);
                                }
                                if (o1 instanceof Document || o2 instanceof Document) {
                                    return valueComparator.compare(o1, o2);
                                }
                                return 0;
                            };
                        }
                        if (comparator != null) continue block12;
                        throw new BadValueException("The $sort is invalid: use 1/-1 to sort the whole element, or {field:1/-1} to sort embedded fields");
                    }
                    case "$position": {
                        if (!(entry.getValue() instanceof Number)) {
                            throw new BadValueException("The value for $position must be an integer value, not of type: " + Utils.describeType(entry.getValue()));
                        }
                        position = Utils.normalizeNumber((Number)entry.getValue()).intValue();
                        continue block12;
                    }
                }
                throw new BadValueException("Unrecognized clause in $push: " + modifier);
            }
        } else {
            newValues.add(changeValue);
        }
        List<Object> newValue = new ArrayList<Object>(existingValue);
        if (position < 0) {
            position = newValue.size() + position;
        } else if (position >= newValue.size()) {
            position = newValue.size();
        }
        newValue.addAll(position, newValues);
        if (comparator != null) {
            newValue.sort(comparator);
        }
        if (slice != null) {
            int sliceValue = slice;
            if (sliceValue < 0) {
                int fromIndex = Math.max(0, newValue.size() + sliceValue);
                newValue = newValue.subList(fromIndex, newValue.size());
            } else {
                int toIndex = Math.min(sliceValue, newValue.size());
                newValue = newValue.subList(0, toIndex);
            }
            newValue = new ArrayList<Object>(newValue);
        }
        this.changeSubdocumentValue(this.document, key, newValue);
    }

    private void handleAddToSet(String key, Object changeValue) {
        List<Object> newValue = this.getListOrThrow(key, value -> new MongoServerError(10141, "Cannot apply $addToSet to non-array field. Field named '" + key + "' has non-array type " + Utils.describeType(value)));
        ArrayList<Object> pushValues = new ArrayList<Object>();
        if (changeValue instanceof Document && ((Document)changeValue).keySet().iterator().next().equals("$each")) {
            Document addToSetDocument = (Document)changeValue;
            for (String modifier : addToSetDocument.keySet()) {
                if (modifier.equals("$each")) continue;
                throw new BadValueException("Found unexpected fields after $each in $addToSet: " + addToSetDocument.toString(true, "{ ", " }"));
            }
            Collection collection = (Collection)addToSetDocument.get("$each");
            pushValues.addAll(collection);
        } else {
            pushValues.add(changeValue);
        }
        for (Object e : pushValues) {
            if (newValue.contains(e)) continue;
            newValue.add(e);
        }
        this.changeSubdocumentValue(this.document, key, newValue);
    }

    private void assertNotKeyField(String key) {
        if (key.equals(this.idField)) {
            throw new ImmutableFieldException("Performing an update on the path '" + this.idField + "' would modify the immutable field '" + this.idField + "'");
        }
    }

    private void handleUnset(String key) {
        this.assertNotKeyField(key);
        Utils.removeSubdocumentValue((Object)this.document, key, this.matchPos);
    }

    private void handleSet(String key, Object newValue) {
        boolean newValueIsNotMissing;
        Object oldValue = this.getSubdocumentValue(this.document, key);
        boolean oldValueIsMissing = oldValue instanceof Missing;
        boolean bl = newValueIsNotMissing = !(newValue instanceof Missing);
        if (!(!Utils.nullAwareEquals(newValue, oldValue) || oldValueIsMissing && newValueIsNotMissing)) {
            return;
        }
        if (!this.isUpsert()) {
            this.assertNotKeyField(key);
        }
        this.changeSubdocumentValue(this.document, key, newValue);
    }

    private void handlePull(String modifier, String key, Object pullValue) {
        Object value = this.getSubdocumentValue(this.document, key);
        if (Missing.isNullOrMissing(value)) {
            return;
        }
        if (!(value instanceof List)) {
            if (this.updateOperator == UpdateOperator.PULL) {
                throw new BadValueException("Cannot apply " + modifier + " to a non-array value");
            }
            throw new BadValueException(modifier + " requires an array argument but was given a " + Utils.describeType(value));
        }
        List<Object> list = FieldUpdates.asList(value);
        if (modifier.equals("$pullAll")) {
            if (!(pullValue instanceof Collection)) {
                throw new BadValueException(modifier + " requires an array argument but was given a " + Utils.describeType(pullValue));
            }
            Collection valueList = (Collection)pullValue;
            list.removeIf(obj -> valueList.stream().anyMatch(v -> this.matcher.matchesValue(obj, v)));
        } else {
            list.removeIf(obj -> this.matcher.matchesValue(pullValue, obj));
        }
    }

    private void handlePop(String modifier, String key, Object popValue) {
        Object value = this.getSubdocumentValue(this.document, key);
        if (Missing.isNullOrMissing(value)) {
            return;
        }
        if (!(value instanceof List)) {
            throw new MongoServerError(10143, modifier + " requires an array argument but was given a " + Utils.describeType(value));
        }
        List<Object> list = FieldUpdates.asList(value);
        if (!(popValue instanceof Number)) {
            throw new FailedToParseException("Expected a number in: " + key + ": " + Json.toJsonValue(popValue));
        }
        Object normalizedValue = Utils.normalizeValue(popValue);
        Assert.notNull(normalizedValue);
        if (!Utils.nullAwareEquals(normalizedValue, 1) && !Utils.nullAwareEquals(normalizedValue, -1)) {
            throw new FailedToParseException("$pop expects 1 or -1, found: " + Json.toJsonValue(popValue));
        }
        if (!list.isEmpty()) {
            if (Utils.nullAwareEquals(normalizedValue, -1)) {
                list.remove(0);
            } else {
                list.remove(list.size() - 1);
            }
        }
    }

    private void handleIncMul(Document change, String key, Object changeObject) {
        Number newValue;
        Number number;
        this.assertNotKeyField(key);
        Object value = this.getSubdocumentValue(this.document, key);
        if (Missing.isNullOrMissing(value)) {
            number = 0;
        } else if (value instanceof Number) {
            number = (Number)value;
        } else {
            String lastKey = Utils.getLastFragment(key);
            throw new TypeMismatchException("Cannot apply " + this.updateOperator.getValue() + " to a value of non-numeric type. {" + "_id" + ": " + Json.toJsonValue(this.document.get("_id")) + "} has the field '" + lastKey + "' of non-numeric type " + Utils.describeType(value));
        }
        if (!(changeObject instanceof Number)) {
            String operation = this.updateOperator == UpdateOperator.INC ? "increment" : "multiply";
            throw new TypeMismatchException("Cannot " + operation + " with non-numeric argument: " + change.toString(true));
        }
        Number changeValue = (Number)changeObject;
        if (this.updateOperator == UpdateOperator.INC) {
            newValue = NumericUtils.addNumbers(number, changeValue);
        } else if (this.updateOperator == UpdateOperator.MUL) {
            newValue = NumericUtils.multiplyNumbers(number, changeValue);
        } else {
            throw new RuntimeException();
        }
        this.changeSubdocumentValue(this.document, key, newValue);
    }

    private void handleMinMax(String key, Object newValue) {
        this.assertNotKeyField(key);
        Object oldValue = this.getSubdocumentValue(this.document, key);
        if (this.shouldChangeValue(oldValue, newValue)) {
            this.changeSubdocumentValue(this.document, key, newValue);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleCurrentDate(String key, Object typeSpecification) {
        void var5_7;
        boolean useDate;
        this.assertNotKeyField(key);
        if (typeSpecification instanceof Boolean && Utils.isTrue(typeSpecification)) {
            useDate = true;
        } else {
            if (!(typeSpecification instanceof Document)) throw new BadValueException(Utils.describeType(typeSpecification) + " is not valid type for $currentDate. Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'}).");
            Object type = ((Document)typeSpecification).get("$type");
            if (type.equals("timestamp")) {
                useDate = false;
            } else {
                if (!type.equals("date")) throw new BadValueException("The '$type' string field is required to be 'date' or 'timestamp': {$currentDate: {field : {$type: 'date'}}}");
                useDate = true;
            }
        }
        Instant now = Instant.now();
        if (useDate) {
            Instant instant = now;
        } else {
            BsonTimestamp bsonTimestamp = new BsonTimestamp(now, 0);
        }
        this.changeSubdocumentValue(this.document, key, var5_7);
    }

    private void handleRename(String key, Object toField) {
        this.assertNotKeyField(key);
        if (!(toField instanceof String)) {
            throw new BadValueException("The 'to' field for $rename must be a string: " + key + ": " + toField);
        }
        String newKey = (String)toField;
        this.assertNotKeyField(newKey);
        if (this.renames.containsKey(key) || this.renames.containsValue(key)) {
            throw new ConflictingUpdateOperatorsException(key, key);
        }
        if (this.renames.containsKey(newKey) || this.renames.containsValue(newKey)) {
            throw new ConflictingUpdateOperatorsException(newKey, newKey);
        }
        this.renames.put(key, newKey);
    }

    private void applyRenames() {
        for (Map.Entry<String, String> entry : this.renames.entrySet()) {
            if (!Utils.canFullyTraverseSubkeyForRename(this.document, entry.getKey())) {
                throw new PathNotViableException("cannot traverse element");
            }
            Object value = Utils.removeSubdocumentValue((Object)this.document, entry.getKey(), this.matchPos);
            if (value instanceof Missing) continue;
            this.changeSubdocumentValue(this.document, entry.getValue(), value);
        }
    }

    private static List<Object> asList(Object value) {
        return (List)value;
    }

    private void changeSubdocumentValue(Document document, String key, Object newValue) {
        Utils.changeSubdocumentValue((Object)document, key, newValue, this.matchPos);
    }

    private Object getSubdocumentValue(Object document, String key) {
        return FieldUpdates.getSubdocumentValue(document, key, new AtomicReference<Integer>(this.matchPos));
    }

    private static Object getSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) {
        List<String> pathFragments = Utils.splitPath(key);
        String mainKey = pathFragments.get(0);
        if (pathFragments.size() == 1) {
            return Utils.getFieldValueListSafe(document, mainKey);
        }
        String subKey = Utils.getSubkey(pathFragments, matchPos);
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document || subObject instanceof List) {
            return FieldUpdates.getSubdocumentValue(subObject, subKey, matchPos);
        }
        return Missing.getInstance();
    }

    private boolean shouldChangeValue(Object oldValue, Object newValue) {
        if (oldValue instanceof Missing) {
            return true;
        }
        int typeComparison = ValueComparator.compareTypes(newValue, oldValue);
        if (typeComparison != 0) {
            if (this.updateOperator == UpdateOperator.MAX) {
                return typeComparison > 0;
            }
            return typeComparison < 0;
        }
        ValueComparator valueComparator = this.updateOperator == UpdateOperator.MIN ? ValueComparator.asc() : ValueComparator.desc();
        int valueComparison = valueComparator.compare(newValue, oldValue);
        return valueComparison < 0;
    }

    private boolean isUpsert() {
        return this.upsert;
    }
}

