/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.IndexKey;
import de.bwaldvogel.mongo.backend.KeyValue;
import de.bwaldvogel.mongo.backend.StreamUtils;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.CannotIndexParallelArraysError;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Index<P> {
    private final String name;
    private final List<IndexKey> keys;
    private final boolean sparse;

    protected Index(String name, List<IndexKey> keys, boolean sparse) {
        this.name = name;
        this.keys = keys;
        this.sparse = sparse;
    }

    protected boolean isSparse() {
        return this.sparse;
    }

    public List<IndexKey> getKeys() {
        return this.keys;
    }

    public boolean hasSameOptions(Index<?> other) {
        return this.sparse == other.sparse;
    }

    public String getName() {
        return this.name;
    }

    protected List<String> keys() {
        return this.keys.stream().map(IndexKey::getKey).collect(Collectors.toList());
    }

    protected Set<String> keySet() {
        return this.keys.stream().map(IndexKey::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<KeyValue> getKeyValues(Document document) {
        return this.getKeyValues(document, true);
    }

    Set<KeyValue> getKeyValues(Document document, boolean normalize) {
        List collectionValues;
        Map<String, Object> valuesPerKey = this.collectValuesPerKey(document);
        if (normalize) {
            valuesPerKey.replaceAll((key, value) -> Utils.normalizeValue(value));
        }
        if ((collectionValues = valuesPerKey.values().stream().filter(value -> value instanceof Collection).map(value -> (Collection)value).collect(Collectors.toList())).size() > 0) {
            this.validateHasNoParallelArrays(document);
            return CollectionUtils.multiplyWithOtherElements(valuesPerKey.values(), collectionValues).stream().map(KeyValue::new).collect(StreamUtils.toLinkedHashSet());
        }
        return Collections.singleton(new KeyValue(valuesPerKey.values()));
    }

    private void validateHasNoParallelArrays(Document document) {
        LinkedHashSet<List<String>> arrayPaths = new LinkedHashSet<List<String>>();
        for (String key : this.keys()) {
            List<String> pathToFirstCollection = Index.getPathToFirstCollection(document, key);
            if (pathToFirstCollection == null) continue;
            arrayPaths.add(pathToFirstCollection);
        }
        if (arrayPaths.size() > 1) {
            List<String> parallelArraysPaths = arrayPaths.stream().map(path -> (String)path.get(path.size() - 1)).collect(Collectors.toList());
            throw new CannotIndexParallelArraysError(parallelArraysPaths);
        }
    }

    private static List<String> getPathToFirstCollection(Document document, String key) {
        List<String> fragments = Utils.splitPath(key);
        List<String> remainingFragments = Utils.getTail(fragments);
        return Index.getPathToFirstCollection(document, remainingFragments, Collections.singletonList(fragments.get(0)));
    }

    private static List<String> getPathToFirstCollection(Document document, List<String> remainingFragments, List<String> path) {
        Object value = Utils.getSubdocumentValue(document, Utils.joinPath(path));
        if (value instanceof Collection) {
            return path;
        }
        if (remainingFragments.isEmpty()) {
            return null;
        }
        ArrayList<String> newPath = new ArrayList<String>(path);
        newPath.add(remainingFragments.get(0));
        return Index.getPathToFirstCollection(document, Utils.getTail(remainingFragments), newPath);
    }

    private Map<String, Object> collectValuesPerKey(Document document) {
        LinkedHashMap<String, Object> valuesPerKey = new LinkedHashMap<String, Object>();
        for (String key : this.keys()) {
            Object value = Utils.getSubdocumentValueCollectionAware(document, key);
            valuesPerKey.put(key, value);
        }
        return valuesPerKey;
    }

    public abstract P getPosition(Document var1);

    public abstract void checkAdd(Document var1, MongoCollection<P> var2);

    public abstract void add(Document var1, P var2, MongoCollection<P> var3);

    public abstract P remove(Document var1);

    public abstract boolean canHandle(Document var1);

    public abstract Iterable<P> getPositions(Document var1);

    public abstract long getCount();

    public boolean isEmpty() {
        return this.getCount() == 0L;
    }

    public abstract long getDataSize();

    public abstract void checkUpdate(Document var1, Document var2, MongoCollection<P> var3);

    public abstract void updateInPlace(Document var1, Document var2, P var3, MongoCollection<P> var4) throws KeyConstraintError;

    protected boolean isCompoundIndex() {
        return this.keys().size() > 1;
    }

    protected boolean nullAwareEqualsKeys(Document oldDocument, Document newDocument) {
        Set<KeyValue> oldKeyValues = this.getKeyValues(oldDocument);
        Set<KeyValue> newKeyValues = this.getKeyValues(newDocument);
        return Utils.nullAwareEquals(oldKeyValues, newKeyValues);
    }

    public abstract void drop();

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + "]";
    }

    public boolean isUnique() {
        return false;
    }

    public Document toIndexDescription() {
        Document indexDescription = new Document("v", 2).append("unique", this.isUnique());
        Document key = new Document();
        for (IndexKey indexKey : this.getKeys()) {
            key.put(indexKey.getKey(), (Object)(indexKey.isAscending() ? 1 : -1));
        }
        indexDescription.put("key", (Object)key);
        indexDescription.put("name", (Object)this.getName());
        if (this.isSparse()) {
            indexDescription.put("sparse", (Object)true);
        }
        return indexDescription;
    }
}

