/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.Accumulator;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GroupStage
implements AggregationStage {
    private final Map<String, Supplier<Accumulator>> accumulatorSuppliers;
    private final Object idExpression;

    public GroupStage(Document groupQuery) {
        if (!groupQuery.containsKey("_id")) {
            throw new MongoServerError(15955, "a group specification must include an _id");
        }
        this.idExpression = groupQuery.get("_id");
        this.accumulatorSuppliers = Accumulator.parse(groupQuery);
    }

    @Override
    public String name() {
        return "$group";
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        TreeMap accumulatorsPerKey = new TreeMap(ValueComparator.asc());
        stream.forEach(document -> {
            Object key = Expression.evaluateDocument(this.idExpression, document);
            if (key instanceof Missing) {
                key = null;
            }
            Collection accumulators = accumulatorsPerKey.computeIfAbsent(key, k -> this.accumulatorSuppliers.values().stream().map(Supplier::get).collect(Collectors.toList()));
            for (Accumulator accumulator : accumulators) {
                Object expression = accumulator.getExpression();
                accumulator.aggregate(Expression.evaluateDocument(expression, document));
            }
        });
        ArrayList<Document> result = new ArrayList<Document>();
        for (Map.Entry entry : accumulatorsPerKey.entrySet()) {
            Document groupResult = new Document();
            groupResult.put("_id", entry.getKey());
            for (Accumulator accumulator : (Collection)entry.getValue()) {
                groupResult.put(accumulator.getField(), accumulator.getResult());
            }
            result.add(groupResult);
        }
        return result.stream();
    }
}

