/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.bson;

import de.bwaldvogel.mongo.bson.Bson;
import java.util.Arrays;
import java.util.Objects;

public final class BinData
implements Comparable<BinData>,
Bson {
    private static final long serialVersionUID = 1L;
    private final byte[] data;

    public BinData(byte[] data) {
        this.data = Objects.requireNonNull(data);
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinData binData = (BinData)o;
        return Arrays.equals(this.data, binData.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public int compareTo(BinData other) {
        byte[] bytes2;
        byte[] bytes1 = this.getData();
        if (bytes1.length != (bytes2 = other.getData()).length) {
            return Integer.compare(bytes1.length, bytes2.length);
        }
        for (int i = 0; i < bytes1.length; ++i) {
            int compare = BinData.compareUnsigned(bytes1[i], bytes2[i]);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private static int compareUnsigned(byte b1, byte b2) {
        int v1 = b1 & 0xFF;
        int v2 = b2 & 0xFF;
        return Integer.compare(v1, v2);
    }
}

