/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.MongoSilentServerException;
import de.bwaldvogel.mongo.exception.NoSuchCommandException;
import de.bwaldvogel.mongo.wire.message.Message;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.TreeMap;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoBackend
implements MongoBackend {
    private static final Logger log = LoggerFactory.getLogger(AbstractMongoBackend.class);
    private final TreeMap<String, MongoDatabase> databases = new TreeMap();
    private static int[] VERSION = new int[]{3, 0, 0};

    private MongoDatabase resolveDatabase(Message message) throws MongoServerException {
        return this.resolveDatabase(message.getDatabaseName());
    }

    protected synchronized MongoDatabase resolveDatabase(String database) throws MongoServerException {
        MongoDatabase db = this.databases.get(database);
        if (db == null) {
            db = this.openOrCreateDatabase(database);
            log.info("created database {}", (Object)db.getDatabaseName());
            this.databases.put(database, db);
        }
        return db;
    }

    private BSONObject getLog(String argument) throws MongoServerException {
        log.debug("getLog: {}", (Object)argument);
        BasicBSONObject response = new BasicBSONObject();
        if (argument.equals("*")) {
            response.put("names", Collections.singletonList("startupWarnings"));
            Utils.markOkay((BSONObject)response);
        } else if (argument.equals("startupWarnings")) {
            response.put("totalLinesWritten", (Object)0);
            response.put("log", new ArrayList());
            Utils.markOkay((BSONObject)response);
        } else {
            throw new MongoSilentServerException("no RamLog named: " + argument);
        }
        return response;
    }

    private BSONObject handleAdminCommand(Channel channel, String command, BSONObject query) throws MongoServerException {
        if (command.equalsIgnoreCase("listdatabases")) {
            BasicBSONObject response = new BasicBSONObject();
            ArrayList<BasicBSONObject> dbs = new ArrayList<BasicBSONObject>();
            for (MongoDatabase db : this.databases.values()) {
                BasicBSONObject dbObj = new BasicBSONObject("name", (Object)db.getDatabaseName());
                dbObj.put((Object)"empty", (Object)db.isEmpty());
                dbs.add(dbObj);
            }
            response.put("databases", dbs);
            Utils.markOkay((BSONObject)response);
            return response;
        }
        if (command.equalsIgnoreCase("replSetGetStatus")) {
            throw new MongoSilentServerException("not running with --replSet");
        }
        if (command.equalsIgnoreCase("getLog")) {
            Object argument = query.get(command);
            BSONObject response = this.getLog(argument == null ? null : argument.toString());
            return response;
        }
        if (command.equalsIgnoreCase("renameCollection")) {
            return this.handleRenameCollection(command, query);
        }
        if (command.equalsIgnoreCase("getLastError")) {
            BasicBSONObject response = new BasicBSONObject();
            log.debug("getLastError on admin database");
            Utils.markOkay((BSONObject)response);
            return response;
        }
        throw new NoSuchCommandException(command);
    }

    private BSONObject handleRenameCollection(String command, BSONObject query) throws MongoServerException {
        String oldNamespace = query.get(command).toString();
        String newNamespace = query.get("to").toString();
        boolean dropTarget = Utils.isTrue(query.get("dropTarget"));
        BasicBSONObject response = new BasicBSONObject();
        if (!oldNamespace.equals(newNamespace)) {
            MongoCollection<?> oldCollection = this.resolveCollection(oldNamespace);
            if (oldCollection == null) {
                throw new MongoServerException("source namespace does not exist");
            }
            String newDatabaseName = Utils.getDatabaseNameFromFullName(newNamespace);
            String newCollectionName = Utils.getCollectionNameFromFullName(newNamespace);
            MongoDatabase oldDatabase = this.resolveDatabase(oldCollection.getDatabaseName());
            MongoDatabase newDatabase = this.resolveDatabase(newDatabaseName);
            MongoCollection<?> newCollection = newDatabase.resolveCollection(newCollectionName, false);
            if (newCollection != null) {
                if (dropTarget) {
                    newDatabase.dropCollection(newCollectionName);
                } else {
                    throw new MongoServerException("target namespace already exists");
                }
            }
            newDatabase.moveCollection(oldDatabase, oldCollection, newCollectionName);
        }
        Utils.markOkay((BSONObject)response);
        return response;
    }

    private MongoCollection<?> resolveCollection(String namespace) throws MongoServerException {
        String databaseName = Utils.getDatabaseNameFromFullName(namespace);
        String collectionName = Utils.getCollectionNameFromFullName(namespace);
        MongoDatabase database = this.databases.get(databaseName);
        if (database == null) {
            return null;
        }
        MongoCollection<?> collection = database.resolveCollection(collectionName, false);
        if (collection == null) {
            return null;
        }
        return collection;
    }

    protected abstract MongoDatabase openOrCreateDatabase(String var1) throws MongoServerException;

    @Override
    public BSONObject handleCommand(Channel channel, String databaseName, String command, BSONObject query) throws MongoServerException {
        if (command.equalsIgnoreCase("whatsmyuri")) {
            BasicBSONObject response = new BasicBSONObject();
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
            response.put("you", (Object)(remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort()));
            Utils.markOkay((BSONObject)response);
            return response;
        }
        if (command.equalsIgnoreCase("ismaster")) {
            BasicBSONObject response = new BasicBSONObject("ismaster", (Object)Boolean.TRUE);
            response.put("maxBsonObjectSize", (Object)0x1000000);
            response.put("maxWriteBatchSize", (Object)1000);
            response.put("maxMessageSizeBytes", (Object)48000000);
            response.put("maxWireVersion", (Object)2);
            response.put("minWireVersion", (Object)2);
            response.put("localTime", (Object)new Date());
            Utils.markOkay((BSONObject)response);
            return response;
        }
        if (command.equalsIgnoreCase("buildinfo")) {
            BasicBSONObject response = new BasicBSONObject("version", (Object)Utils.join(VERSION, '.'));
            response.put("versionArray", (Object)VERSION);
            response.put("maxBsonObjectSize", (Object)0x1000000);
            Utils.markOkay((BSONObject)response);
            return response;
        }
        if (databaseName.equals("admin")) {
            return this.handleAdminCommand(channel, command, query);
        }
        MongoDatabase db = this.resolveDatabase(databaseName);
        return db.handleCommand(channel, command, query);
    }

    @Override
    public Collection<BSONObject> getCurrentOperations(MongoQuery query) {
        return Collections.emptyList();
    }

    @Override
    public Iterable<BSONObject> handleQuery(MongoQuery query) throws MongoServerException {
        MongoDatabase db = this.resolveDatabase(query);
        return db.handleQuery(query);
    }

    @Override
    public void handleInsert(MongoInsert insert) throws MongoServerException {
        MongoDatabase db = this.resolveDatabase(insert);
        db.handleInsert(insert);
    }

    @Override
    public void handleDelete(MongoDelete delete) throws MongoServerException {
        MongoDatabase db = this.resolveDatabase(delete);
        db.handleDelete(delete);
    }

    @Override
    public void handleUpdate(MongoUpdate update) throws MongoServerException {
        MongoDatabase db = this.resolveDatabase(update);
        db.handleUpdate(update);
    }

    @Override
    public void dropDatabase(String databaseName) throws MongoServerException {
        MongoDatabase removedDatabase = this.databases.remove(databaseName);
        removedDatabase.drop();
    }

    @Override
    public void handleClose(Channel channel) {
        for (MongoDatabase db : this.databases.values()) {
            db.handleClose(channel);
        }
    }

    @Override
    public int[] getVersion() {
        return VERSION;
    }
}

