/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.QueryMatcher;
import de.bwaldvogel.mongo.backend.QueryOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class DefaultQueryMatcher
implements QueryMatcher {
    private ValueComparator comparator = new ValueComparator();
    private Integer lastPosition;

    @Override
    public boolean matches(BSONObject document, BSONObject query) throws MongoServerException {
        for (String key : query.keySet()) {
            if (this.checkMatch(query.get(key), key, (Object)document)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized Integer matchPosition(BSONObject document, BSONObject query) throws MongoServerException {
        this.lastPosition = null;
        for (String key : query.keySet()) {
            if (this.checkMatch(query.get(key), key, (Object)document)) continue;
            return null;
        }
        return this.lastPosition;
    }

    private List<String> splitKey(String key) throws MongoServerException {
        List<String> keys = Arrays.asList(key.split("\\."));
        for (String subKey : keys) {
            if (!subKey.isEmpty()) continue;
            throw new MongoServerException("illegal key: " + key);
        }
        return keys;
    }

    private boolean checkMatch(Object queryValue, String key, Object document) throws MongoServerException {
        return this.checkMatch(queryValue, this.splitKey(key), document);
    }

    private boolean checkMatch(Object queryValue, List<String> keys, Object document) throws MongoServerException {
        if (keys.isEmpty()) {
            throw new MongoServerException("illegal keys: " + keys);
        }
        if (document == null) {
            return false;
        }
        String firstKey = keys.get(0);
        List<Object> subKeys = Collections.emptyList();
        if (keys.size() > 1) {
            subKeys = keys.subList(1, keys.size());
        }
        if (firstKey.startsWith("$") && (firstKey.equals("$and") || firstKey.equals("$or") || firstKey.equals("$nor"))) {
            return this.checkMatchAndOrNor(queryValue, firstKey, document);
        }
        if (document instanceof List) {
            Object allQuery;
            if (firstKey.matches("\\d+")) {
                Object listValue = Utils.getFieldValueListSafe(document, firstKey);
                if (subKeys.isEmpty()) {
                    return this.checkMatchesValue(queryValue, listValue, listValue != null);
                }
                return this.checkMatch(queryValue, subKeys, listValue);
            }
            if (queryValue instanceof BSONObject && ((BSONObject)queryValue).keySet().contains("$all") && !this.checkMatchesAllDocuments(allQuery = ((BSONObject)(queryValue = new BasicBSONObject(((BSONObject)queryValue).toMap()))).removeField("$all"), keys, document)) {
                return false;
            }
            return this.checkMatchesAnyDocument(queryValue, keys, document);
        }
        if (!subKeys.isEmpty()) {
            Object subObject = Utils.getFieldValueListSafe(document, firstKey);
            return this.checkMatch(queryValue, subKeys, subObject);
        }
        if (!(document instanceof BSONObject)) {
            return false;
        }
        Object value = ((BSONObject)document).get(firstKey);
        boolean valueExists = ((BSONObject)document).containsField(firstKey);
        if (value instanceof Collection) {
            if (queryValue instanceof BSONObject) {
                Set keySet = ((BSONObject)queryValue).keySet();
                BasicBSONObject queryValueClone = new BasicBSONObject(((BSONObject)queryValue).toMap());
                for (String queryOperator : keySet) {
                    BasicBSONObject inQuery;
                    Object subQuery = queryValueClone.removeField(queryOperator);
                    if (!(queryOperator.equals(QueryOperator.ALL.getValue()) ? !this.checkMatchesAllValues(subQuery, value) : (queryOperator.equals(QueryOperator.IN.getValue()) ? !this.checkMatchesAnyValue(inQuery = new BasicBSONObject(queryOperator, subQuery), value) : (queryOperator.equals(QueryOperator.NOT_IN.getValue()) ? this.checkMatchesAllValues(subQuery, value) : (queryOperator.equals(QueryOperator.NOT.getValue()) ? this.checkMatchesAnyValue(subQuery, value) : !this.checkMatchesAnyValue(queryValue, value) && !this.checkMatchesValue(queryValue, value, valueExists)))))) continue;
                    return false;
                }
                return true;
            }
            if (this.checkMatchesAnyValue(queryValue, value)) {
                return true;
            }
        }
        return this.checkMatchesValue(queryValue, value, valueExists);
    }

    public boolean checkMatchAndOrNor(Object queryValue, String key, Object document) throws MongoServerException {
        if (!(queryValue instanceof List)) {
            throw new MongoServerError(14816, key + " expression must be a nonempty array");
        }
        List list = (List)queryValue;
        if (list.isEmpty()) {
            throw new MongoServerError(14816, key + " expression must be a nonempty array");
        }
        for (Object subqueryValue : list) {
            if (subqueryValue instanceof BSONObject) continue;
            throw new MongoServerError(14817, key + " elements must be objects");
        }
        if (key.equals("$and")) {
            for (Object subqueryValue : list) {
                if (this.matches((BSONObject)document, (BSONObject)subqueryValue)) continue;
                return false;
            }
            return true;
        }
        if (key.equals("$or")) {
            for (Object subqueryValue : list) {
                if (!this.matches((BSONObject)document, (BSONObject)subqueryValue)) continue;
                return true;
            }
            return false;
        }
        if (key.equals("$nor")) {
            return !this.checkMatchAndOrNor(queryValue, "$or", document);
        }
        throw new MongoServerException("illegal operation: " + key + ". must not happen");
    }

    private boolean checkMatchesAllDocuments(Object queryValue, List<String> keys, Object document) throws MongoServerException {
        for (Object query : (Collection)queryValue) {
            if (this.checkMatchesAnyDocument(query, keys, document)) continue;
            return false;
        }
        return true;
    }

    private boolean checkMatchesAnyDocument(Object queryValue, List<String> keys, Object document) throws MongoServerException {
        int i = 0;
        for (Object object : (Collection)document) {
            if (this.checkMatch(queryValue, keys, object)) {
                if (this.lastPosition == null) {
                    this.lastPosition = i;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean matchesValue(Object queryValue, Object value) throws MongoServerException {
        return this.checkMatchesValue(queryValue, value, true);
    }

    private boolean checkMatchesValue(Object queryValue, Object value, boolean valueExists) throws MongoServerException {
        if (queryValue instanceof BSONObject) {
            BSONObject queryObject = (BSONObject)queryValue;
            if (queryObject.containsField("$regex")) {
                String options = "";
                if (queryObject.containsField("$options")) {
                    options = queryObject.get("$options").toString();
                }
                Pattern pattern = Utils.createPattern(queryObject.get("$regex").toString(), options);
                return pattern.matcher(value.toString()).find();
            }
            for (String key : queryObject.keySet()) {
                Object querySubvalue = queryObject.get(key);
                if (!(key.startsWith("$") ? !this.checkExpressionMatch(value, valueExists, querySubvalue, key) : !this.checkMatch(querySubvalue, key, value))) continue;
                return false;
            }
            return true;
        }
        if (value != null && queryValue instanceof Pattern) {
            Matcher matcher = ((Pattern)queryValue).matcher(value.toString());
            return matcher.find();
        }
        return Utils.nullAwareEquals(value, queryValue);
    }

    private boolean checkMatchesAllValues(Object queryValue, Object values) throws MongoServerException {
        if (!(queryValue instanceof Collection)) {
            return false;
        }
        Collection list = (Collection)values;
        for (Object query : (Collection)queryValue) {
            if (this.checkMatchesAnyValue(query, list)) continue;
            return false;
        }
        return true;
    }

    private boolean checkMatchesAnyValue(Object queryValue, Object values) throws MongoServerException {
        int i = 0;
        for (Object value : (Collection)values) {
            if (this.checkMatchesValue(queryValue, value, true)) {
                if (this.lastPosition == null) {
                    this.lastPosition = i;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkExpressionMatch(Object value, boolean valueExists, Object expressionValue, String operator) throws MongoServerException {
        QueryOperator queryOperator;
        try {
            queryOperator = QueryOperator.fromValue(operator);
        }
        catch (IllegalArgumentException e) {
            throw new MongoServerError(10068, "invalid operator: " + operator);
        }
        switch (queryOperator) {
            case IN: {
                Collection queriedObjects = (Collection)expressionValue;
                for (Object o : queriedObjects) {
                    if (!Utils.nullAwareEquals(o, value)) continue;
                    return true;
                }
                return false;
            }
            case NOT: {
                return !this.checkMatchesValue(expressionValue, value, valueExists);
            }
            case EQUAL: {
                return Utils.nullAwareEquals(value, expressionValue);
            }
            case NOT_EQUALS: {
                return !Utils.nullAwareEquals(value, expressionValue);
            }
            case NOT_IN: {
                return !this.checkExpressionMatch(value, valueExists, expressionValue, "$in");
            }
            case EXISTS: {
                return valueExists == Utils.isTrue(expressionValue);
            }
            case GREATER_THAN: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return this.comparator.compare(value, expressionValue) > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return this.comparator.compare(value, expressionValue) >= 0;
            }
            case LESS_THAN: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return this.comparator.compare(value, expressionValue) < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                if (!this.comparableTypes(value, expressionValue)) {
                    return false;
                }
                return this.comparator.compare(value, expressionValue) <= 0;
            }
            case MOD: {
                if (!(value instanceof Number)) {
                    return false;
                }
                List modValue = (List)expressionValue;
                return ((Number)value).intValue() % ((Number)modValue.get(0)).intValue() == ((Number)modValue.get(1)).intValue();
            }
            case SIZE: {
                double matchingSize;
                if (!(value instanceof Collection) || !(expressionValue instanceof Number)) {
                    return false;
                }
                int listSize = ((Collection)value).size();
                return (double)listSize == (matchingSize = ((Number)expressionValue).doubleValue());
            }
            case ALL: {
                return false;
            }
        }
        throw new IllegalArgumentException("unhandled query operator: " + (Object)((Object)queryOperator));
    }

    private boolean comparableTypes(Object value1, Object value2) {
        value1 = Utils.normalizeValue(value1);
        value2 = Utils.normalizeValue(value2);
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.getClass().equals(value2.getClass());
    }
}

