/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire.message;

import de.bwaldvogel.mongo.wire.message.MessageHeader;
import java.util.Collections;
import java.util.List;
import org.bson.BSONObject;

public class MongoReply {
    private final MessageHeader header;
    private final List<? extends BSONObject> documents;
    private long cursorId;
    private int startingFrom;
    private int flags;

    public MongoReply(MessageHeader header, BSONObject document) {
        this(header, Collections.singletonList(document));
    }

    public MongoReply(MessageHeader header, List<? extends BSONObject> documents) {
        this.header = header;
        this.documents = documents;
    }

    public MessageHeader getHeader() {
        return this.header;
    }

    public List<BSONObject> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public long getCursorId() {
        return this.cursorId;
    }

    public int getStartingFrom() {
        return this.startingFrom;
    }

    public int getFlags() {
        return this.flags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append("documents: ").append(this.getDocuments());
        sb.append(")");
        return sb.toString();
    }
}

