/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import de.bwaldvogel.mongo.exception.MongoServerException;

public abstract class Index<P> {
    protected final String key;
    protected final boolean ascending;

    protected Index(String key, boolean ascending) {
        this.key = key;
        this.ascending = ascending;
    }

    public String getName() {
        if (this.key.equals("_id")) {
            return "_id_";
        }
        return this.key + "_" + (this.ascending ? "1" : "-1");
    }

    protected Object getKey(Document document) {
        Object value = Utils.getSubdocumentValue(document, this.key);
        return Utils.normalizeValue(value);
    }

    public abstract void checkAdd(Document var1) throws MongoServerException;

    public abstract void add(Document var1, P var2) throws MongoServerException;

    public abstract P remove(Document var1);

    public abstract boolean canHandle(Document var1);

    public abstract Iterable<P> getPositions(Document var1);

    public abstract long getCount();

    public abstract long getDataSize();

    public abstract void checkUpdate(Document var1, Document var2) throws MongoServerException;

    public abstract void updateInPlace(Document var1, Document var2) throws KeyConstraintError;
}

