/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.bson.BsonRegularExpression;
import de.bwaldvogel.mongo.bson.BsonTimestamp;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.MaxKey;
import de.bwaldvogel.mongo.bson.MinKey;
import de.bwaldvogel.mongo.bson.ObjectId;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class BsonEncoder {
    public void encodeDocument(Document document, ByteBuf out) throws IOException {
        int indexBefore = out.writerIndex();
        out.writeInt(0);
        for (String key : document.keySet()) {
            this.encodeValue(key, document.get(key), out);
        }
        out.writeByte(0);
        int indexAfter = out.writerIndex();
        out.writerIndex(indexBefore);
        out.writeInt(indexAfter - indexBefore);
        out.writerIndex(indexAfter);
    }

    private void encodeCString(String data, ByteBuf buffer) throws IOException {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        buffer.writeBytes(bytes);
        buffer.writeByte(0);
    }

    private void encodeString(String data, ByteBuf buffer) throws IOException {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(bytes.length + 1);
        buffer.writeBytes(bytes);
        buffer.writeByte(0);
    }

    private void encodeValue(String key, Object value, ByteBuf buffer) throws IOException {
        byte type = this.determineType(value);
        buffer.writeByte((int)type);
        this.encodeCString(key, buffer);
        this.encodeValue(type, value, buffer);
    }

    private void encodeValue(byte type, Object value, ByteBuf buffer) throws IOException {
        switch (type) {
            case 1: {
                buffer.writeDouble(((Double)value).doubleValue());
                break;
            }
            case 2: {
                this.encodeString(value.toString(), buffer);
                break;
            }
            case 3: {
                this.encodeDocument((Document)value, buffer);
                break;
            }
            case 4: {
                Document document = new Document();
                List array = (List)value;
                for (int i = 0; i < array.size(); ++i) {
                    document.put(String.valueOf(i), array.get(i));
                }
                this.encodeDocument(document, buffer);
                break;
            }
            case 5: {
                if (value instanceof byte[]) {
                    byte[] data = (byte[])value;
                    buffer.writeInt(data.length);
                    buffer.writeByte(0);
                    buffer.writeBytes(data);
                    break;
                }
                if (value instanceof UUID) {
                    buffer.writeInt(16);
                    buffer.writeByte(3);
                    UUID uuid = (UUID)value;
                    buffer.writeLong(uuid.getMostSignificantBits());
                    buffer.writeLong(uuid.getLeastSignificantBits());
                    break;
                }
                throw new IllegalArgumentException("Unknown data: " + value.getClass());
            }
            case 7: {
                byte[] bytes = ((ObjectId)value).toByteArray();
                if (bytes.length != 12) {
                    throw new IllegalArgumentException("Illegal ObjectId: " + value);
                }
                buffer.writeBytes(bytes);
                break;
            }
            case 8: {
                if (((Boolean)value).booleanValue()) {
                    buffer.writeByte(1);
                    break;
                }
                buffer.writeByte(0);
                break;
            }
            case 9: {
                buffer.writeLong(((Date)value).getTime());
                break;
            }
            case 11: {
                BsonRegularExpression pattern = (BsonRegularExpression)value;
                this.encodeCString(pattern.getPattern(), buffer);
                this.encodeCString(pattern.getOptions(), buffer);
                break;
            }
            case 16: {
                buffer.writeInt(((Integer)value).intValue());
                break;
            }
            case 17: {
                BsonTimestamp timestamp = (BsonTimestamp)value;
                buffer.writeLong(timestamp.getTimestamp());
                break;
            }
            case 18: {
                buffer.writeLong(((Long)value).longValue());
                break;
            }
            case -1: 
            case 6: 
            case 10: 
            case 127: {
                break;
            }
            case 13: 
            case 15: {
                throw new IOException("unhandled type: " + value.getClass());
            }
            default: {
                throw new IOException("unknown type: " + value.getClass());
            }
        }
    }

    private byte determineType(Object value) {
        if (value == null) {
            return 10;
        }
        if (value instanceof Document) {
            return 3;
        }
        if (value instanceof ObjectId) {
            return 7;
        }
        if (value instanceof Integer) {
            return 16;
        }
        if (value instanceof Long) {
            return 18;
        }
        if (value instanceof Double) {
            return 1;
        }
        if (value instanceof String) {
            return 2;
        }
        if (value instanceof Boolean) {
            return 8;
        }
        if (value instanceof byte[]) {
            return 5;
        }
        if (value instanceof List) {
            return 4;
        }
        if (value instanceof Date) {
            return 9;
        }
        if (value instanceof BsonTimestamp) {
            return 17;
        }
        if (value instanceof BsonRegularExpression) {
            return 11;
        }
        if (value instanceof MaxKey) {
            return 127;
        }
        if (value instanceof MinKey) {
            return -1;
        }
        if (value instanceof UUID) {
            return 5;
        }
        throw new IllegalArgumentException("Unknown type: " + value.getClass());
    }
}

