/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.bson.BsonRegularExpression;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.ObjectId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class ValueComparator
implements Comparator<Object> {
    private static final List<Class<?>> SORT_PRIORITY = new ArrayList();

    @Override
    public int compare(Object value1, Object value2) {
        Class<?> componentType;
        int t2;
        if (value1 == value2) {
            return 0;
        }
        int t1 = this.getTypeOrder(value1);
        if (t1 != (t2 = this.getTypeOrder(value2))) {
            return t1 < t2 ? -1 : 1;
        }
        Class<?> clazz = value1.getClass();
        if (ObjectId.class.isAssignableFrom(clazz)) {
            return ((ObjectId)value1).compareTo((ObjectId)value2);
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return Double.compare(((Number)value1).doubleValue(), ((Number)value2).doubleValue());
        }
        if (String.class.isAssignableFrom(clazz)) {
            return value1.toString().compareTo(value2.toString());
        }
        if (Date.class.isAssignableFrom(clazz)) {
            Date date1 = (Date)value1;
            Date date2 = (Date)value2;
            return date1.compareTo(date2);
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            boolean b1 = (Boolean)value1;
            boolean b2 = (Boolean)value2;
            return !b1 && b2 ? -1 : (b1 && !b2 ? 1 : 0);
        }
        if (clazz.isArray() && Byte.TYPE.isAssignableFrom(componentType = clazz.getComponentType())) {
            byte[] bytes1 = (byte[])value1;
            byte[] bytes2 = (byte[])value2;
            if (bytes1.length != bytes2.length) {
                return Integer.compare(bytes1.length, bytes2.length);
            }
            for (int i = 0; i < bytes1.length; ++i) {
                int compare = this.compareUnsigned(bytes1[i], bytes2[i]);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
        if (Document.class.isAssignableFrom(clazz)) {
            for (String key : ((Document)value1).keySet()) {
                int cmp = this.compare(((Document)value1).get(key), ((Document)value2).get(key));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        throw new UnsupportedOperationException("can't compare " + clazz);
    }

    private int compareUnsigned(byte b1, byte b2) {
        return Integer.compare(b1 + Integer.MIN_VALUE, b2 + Integer.MIN_VALUE);
    }

    private int getTypeOrder(Object obj) {
        if (obj == null) {
            return -1;
        }
        for (int idx = 0; idx < SORT_PRIORITY.size(); ++idx) {
            if (!SORT_PRIORITY.get(idx).isAssignableFrom(obj.getClass())) continue;
            return idx;
        }
        throw new UnsupportedOperationException("can't sort " + obj.getClass());
    }

    static {
        SORT_PRIORITY.add(Number.class);
        SORT_PRIORITY.add(String.class);
        SORT_PRIORITY.add(Document.class);
        SORT_PRIORITY.add(byte[].class);
        SORT_PRIORITY.add(ObjectId.class);
        SORT_PRIORITY.add(Boolean.class);
        SORT_PRIORITY.add(Date.class);
        SORT_PRIORITY.add(BsonRegularExpression.class);
    }
}

