/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.IndexKey;
import de.bwaldvogel.mongo.backend.QueryOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.BsonRegularExpression;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.DuplicateKeyError;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public abstract class AbstractUniqueIndex<P>
extends Index<P> {
    protected AbstractUniqueIndex(List<IndexKey> keys) {
        super(keys);
    }

    protected abstract P removeDocument(List<Object> var1);

    protected abstract boolean containsKey(List<Object> var1);

    protected abstract boolean putKeyPosition(List<Object> var1, P var2);

    protected abstract Iterable<Map.Entry<List<Object>, P>> getIterable();

    protected abstract P getPosition(List<Object> var1);

    @Override
    public synchronized P remove(Document document) {
        List<Object> key = this.getKeyValue(document);
        return this.removeDocument(key);
    }

    @Override
    public synchronized void checkAdd(Document document) {
        if (this.hasNoValueForKeys(document)) {
            return;
        }
        List<Object> key = this.getKeyValue(document);
        if (this.containsKey(key)) {
            throw new DuplicateKeyError(this, key);
        }
    }

    @Override
    public synchronized void add(Document document, P position) {
        this.checkAdd(document);
        if (this.hasNoValueForKeys(document)) {
            return;
        }
        List<Object> key = this.getKeyValue(document);
        boolean added = this.putKeyPosition(key, position);
        if (!added) {
            throw new IllegalStateException("Position " + position + " already exists. Concurrency issue?");
        }
    }

    private boolean hasNoValueForKeys(Document document) {
        for (String key : this.keys()) {
            if (!Utils.hasSubdocumentValue(document, key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkUpdate(Document oldDocument, Document newDocument) {
        if (this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            return;
        }
        this.checkAdd(newDocument);
    }

    @Override
    public void updateInPlace(Document oldDocument, Document newDocument) throws KeyConstraintError {
    }

    @Override
    public synchronized boolean canHandle(Document query) {
        if (!query.keySet().equals(this.keySet())) {
            return false;
        }
        for (String key : this.keys()) {
            Object queryValue = query.get(key);
            if (!(queryValue instanceof Document)) continue;
            for (String queriedKeys : ((Document)queryValue).keySet()) {
                if (AbstractUniqueIndex.isInQuery(queriedKeys) || !queriedKeys.startsWith("$")) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInQuery(String key) {
        return key.equals(QueryOperator.IN.getValue());
    }

    @Override
    public synchronized Iterable<P> getPositions(Document query) {
        List<Object> queriedKeys = this.getQueriedKeys(query);
        for (Object queriedKey : queriedKeys) {
            if (queriedKey instanceof Document) {
                if (this.isCompoundIndex()) {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
                Document keyObj = (Document)queriedKey;
                if (!Utils.containsQueryExpression(keyObj)) continue;
                if (keyObj.keySet().size() != 1) {
                    throw new UnsupportedOperationException("illegal query key: " + queriedKeys);
                }
                String expression = keyObj.keySet().iterator().next();
                if (!expression.startsWith("$")) continue;
                return this.getPositionsForExpression(keyObj, expression);
            }
            if (!(queriedKey instanceof BsonRegularExpression)) continue;
            if (this.isCompoundIndex()) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            ArrayList<P> positions = new ArrayList<P>();
            for (Map.Entry<List<Object>, P> entry : this.getIterable()) {
                List<Object> obj = entry.getKey();
                Matcher matcher = ((BsonRegularExpression)queriedKey).matcher(obj.toString());
                if (!matcher.find()) continue;
                positions.add(entry.getValue());
            }
            return positions;
        }
        P position = this.getPosition(queriedKeys);
        if (position == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(position);
    }

    private List<Object> getQueriedKeys(Document query) {
        return this.keys().stream().map(query::get).map(Utils::normalizeValue).collect(Collectors.toList());
    }

    private boolean nullAwareEqualsKeys(Document oldDocument, Document newDocument) {
        List<Object> oldKey = this.getKeyValue(oldDocument);
        List<Object> newKey = this.getKeyValue(newDocument);
        return Utils.nullAwareEquals(oldKey, newKey);
    }

    private Iterable<P> getPositionsForExpression(Document keyObj, String operator) {
        if (AbstractUniqueIndex.isInQuery(operator)) {
            TreeSet queriedObjects = new TreeSet((Collection)keyObj.get(operator));
            ArrayList<P> allKeys = new ArrayList<P>();
            for (Object object : queriedObjects) {
                Object keyValue = Utils.normalizeValue(object);
                P key = this.getPosition(new ArrayList<Object>(Collections.singletonList(keyValue)));
                if (key == null) continue;
                allKeys.add(key);
            }
            return allKeys;
        }
        throw new UnsupportedOperationException("unsupported query expression: " + operator);
    }
}

