/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.h2.H2Backend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2MongoServer
extends MongoServer {
    private static final Logger log = LoggerFactory.getLogger(H2MongoServer.class);

    public static void main(String[] args) {
        H2MongoServer mongoServer;
        if (args.length == 1) {
            String fileName = args[0];
            mongoServer = new H2MongoServer(fileName);
        } else {
            mongoServer = new H2MongoServer();
        }
        mongoServer.bind("localhost", 27017);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("shutting down {}", (Object)mongoServer);
            mongoServer.shutdownNow();
        }));
    }

    public H2MongoServer() {
        super((MongoBackend)H2Backend.inMemory());
    }

    public H2MongoServer(String fileName) {
        super((MongoBackend)new H2Backend(fileName));
    }
}

