/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.h2;

import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.AbstractSynchronizedMongoCollection;
import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.CollectionOptions;
import de.bwaldvogel.mongo.backend.CursorRegistry;
import de.bwaldvogel.mongo.backend.DocumentWithPosition;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.QueryResult;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.bson.Document;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.stream.Stream;
import org.h2.mvstore.MVMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Collection
extends AbstractSynchronizedMongoCollection<Object> {
    private static final Logger log = LoggerFactory.getLogger(H2Collection.class);
    private final MVMap<Object, Document> dataMap;
    private final MVMap<String, Object> metaMap;
    private static final String DATA_SIZE_KEY = "dataSize";

    public H2Collection(MongoDatabase database, String collectionName, CollectionOptions options, MVMap<Object, Document> dataMap, MVMap<String, Object> metaMap, CursorRegistry cursorRegistry) {
        super(database, collectionName, options, cursorRegistry);
        this.dataMap = dataMap;
        this.metaMap = metaMap;
        if (!this.metaMap.containsKey((Object)DATA_SIZE_KEY)) {
            this.metaMap.put((Object)DATA_SIZE_KEY, (Object)0L);
        } else {
            log.debug("dataSize of {}: {}", (Object)this.getFullName(), (Object)this.getDataSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDataSize(int sizeDelta) {
        MVMap<String, Object> mVMap = this.metaMap;
        synchronized (mVMap) {
            Number value = (Number)this.metaMap.get((Object)DATA_SIZE_KEY);
            Long newValue = value.longValue() + (long)sizeDelta;
            this.metaMap.put((Object)DATA_SIZE_KEY, (Object)newValue);
        }
    }

    protected int getDataSize() {
        Number value = (Number)this.metaMap.get((Object)DATA_SIZE_KEY);
        return value.intValue();
    }

    protected Object addDocumentInternal(Document document) {
        Object key = this.getIdField() != null ? Utils.getSubdocumentValue((Document)document, (String)this.getIdField()) : UUID.randomUUID();
        Document previous = (Document)this.dataMap.put(Missing.ofNullable((Object)key), (Object)document);
        Assert.isNull((Object)previous, () -> "Document with key '" + key + "' already existed in " + (Object)((Object)this) + ": " + previous);
        return key;
    }

    public int count() {
        return this.dataMap.size();
    }

    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    protected Document getDocument(Object position) {
        return (Document)this.dataMap.get(position);
    }

    protected void removeDocument(Object position) {
        Document remove = (Document)this.dataMap.remove(position);
        if (remove == null) {
            throw new NoSuchElementException("No document with key " + position);
        }
    }

    protected Stream<DocumentWithPosition<Object>> streamAllDocumentsWithPosition() {
        return this.dataMap.entrySet().stream().map(entry -> new DocumentWithPosition((Document)entry.getValue(), entry.getKey()));
    }

    protected QueryResult matchDocuments(Document query, Document orderBy, int numberToSkip, int limit, int batchSize, Document fieldSelector) {
        Stream<Object> documentStream = H2Collection.isNaturalDescending((Document)orderBy) ? this.streamAllDocumentsWithPosition().sorted((o1, o2) -> ValueComparator.desc().compare(o1.getPosition(), o2.getPosition())).map(DocumentWithPosition::getDocument) : this.dataMap.values().stream();
        return this.matchDocumentsFromStream(documentStream, query, orderBy, numberToSkip, limit, batchSize, fieldSelector);
    }

    protected void handleUpdate(Object position, Document oldDocument, Document newDocument) {
        this.dataMap.put(Missing.ofNullable((Object)position), (Object)newDocument);
    }
}

