/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.h2;

import de.bwaldvogel.mongo.backend.AbstractUniqueIndex;
import de.bwaldvogel.mongo.backend.IndexKey;
import de.bwaldvogel.mongo.backend.KeyValue;
import de.bwaldvogel.mongo.backend.Missing;
import java.util.List;
import java.util.Map;
import org.h2.mvstore.MVMap;

public class H2UniqueIndex
extends AbstractUniqueIndex<Object> {
    private final MVMap<KeyValue, Object> mvMap;

    H2UniqueIndex(MVMap<KeyValue, Object> mvMap, String name, List<IndexKey> keys, boolean sparse) {
        super(name, keys, sparse);
        this.mvMap = mvMap;
    }

    protected Object removeDocument(KeyValue keyValue) {
        return this.mvMap.remove((Object)keyValue);
    }

    protected boolean putKeyPosition(KeyValue keyValue, Object position) {
        Object oldValue = this.mvMap.putIfAbsent((Object)keyValue, Missing.ofNullable((Object)position));
        return oldValue == null;
    }

    protected Iterable<Map.Entry<KeyValue, Object>> getIterable() {
        return this.mvMap.entrySet();
    }

    protected Object getPosition(KeyValue keyValue) {
        return this.mvMap.get((Object)keyValue);
    }

    public long getCount() {
        return this.mvMap.sizeAsLong();
    }

    public boolean isEmpty() {
        return this.mvMap.isEmpty();
    }

    public long getDataSize() {
        return this.getCount();
    }
}

