/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.h2;

import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.AbstractMongoBackend;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.h2.H2Database;
import de.bwaldvogel.mongo.exception.MongoServerException;
import java.time.Clock;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Backend
extends AbstractMongoBackend {
    private static final Logger log = LoggerFactory.getLogger(H2Backend.class);
    private final MVStore mvStore;

    public static H2Backend inMemory() {
        return H2Backend.inMemory(H2Backend.defaultClock());
    }

    public static H2Backend inMemory(Clock clock) {
        MVStore mvStore = MVStore.open(null);
        return new H2Backend(mvStore, clock);
    }

    public void commit() {
        long oldVersion = this.mvStore.getCurrentVersion();
        long newVersion = this.mvStore.commit();
        log.debug("Committed MVStore (v: {} \u2192 {})", (Object)oldVersion, (Object)newVersion);
    }

    public H2Backend(MVStore mvStore) {
        this(mvStore, H2Backend.defaultClock());
    }

    public H2Backend(MVStore mvStore, Clock clock) {
        super(clock);
        this.mvStore = mvStore;
        mvStore.getMapNames().stream().filter(mapName -> mapName.startsWith("databases.")).map(mapName -> {
            String fullName = mapName.substring("databases.".length());
            return Utils.firstFragment((String)fullName);
        }).distinct().forEach(databaseName -> {
            log.info("opening database '{}'", databaseName);
            try {
                this.resolveDatabase((String)databaseName);
            }
            catch (MongoServerException e) {
                log.error("Failed to open '{}'", databaseName, (Object)e);
            }
        });
    }

    public H2Backend(String fileName) {
        this(H2Backend.openMvStore(fileName));
    }

    public H2Backend(String fileName, Clock clock) {
        this(H2Backend.openMvStore(fileName), clock);
    }

    private static MVStore openMvStore(String fileName) {
        if (fileName == null) {
            log.info("opening in-memory MVStore");
        } else {
            log.info("opening MVStore in '{}'", (Object)fileName);
        }
        return MVStore.open((String)fileName);
    }

    protected MongoDatabase openOrCreateDatabase(String databaseName) {
        return new H2Database(databaseName, this.mvStore, this.getCursorRegistry());
    }

    public MVStore getMvStore() {
        return this.mvStore;
    }

    public void close() {
        super.close();
        this.mvStore.close();
    }

    public boolean isInMemory() {
        return this.mvStore.getFileStore() == null;
    }

    public String toString() {
        if (this.isInMemory()) {
            return ((Object)((Object)this)).getClass().getSimpleName() + "[inMemory]";
        }
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.mvStore.getFileStore().getFileName() + "]";
    }
}

