/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.h2;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.AbstractSynchronizedMongoDatabase;
import de.bwaldvogel.mongo.backend.CollectionOptions;
import de.bwaldvogel.mongo.backend.CursorRegistry;
import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.IndexKey;
import de.bwaldvogel.mongo.backend.KeyValue;
import de.bwaldvogel.mongo.backend.h2.H2Collection;
import de.bwaldvogel.mongo.backend.h2.H2UniqueIndex;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.oplog.Oplog;
import java.util.List;
import java.util.stream.Collectors;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Database
extends AbstractSynchronizedMongoDatabase<Object> {
    private static final Logger log = LoggerFactory.getLogger(H2Database.class);
    private static final String META_PREFIX = "meta.";
    static final String DATABASES_PREFIX = "databases.";
    private final MVStore mvStore;

    public H2Database(String databaseName, MVStore mvStore, CursorRegistry cursorRegistry) {
        super(databaseName, cursorRegistry);
        this.mvStore = mvStore;
        this.initializeNamespacesAndIndexes();
    }

    protected Index<Object> openOrCreateUniqueIndex(String collectionName, String indexName, List<IndexKey> keys, boolean sparse) {
        MVMap mvMap = this.mvStore.openMap(this.mapNameForIndex(collectionName, indexName));
        return new H2UniqueIndex((MVMap<KeyValue, Object>)mvMap, indexName, keys, sparse);
    }

    protected void dropIndex(MongoCollection<Object> collection, String indexName) {
        super.dropIndex(collection, indexName);
        String name = this.mapNameForIndex(collection.getCollectionName(), indexName);
        log.debug("Removing map '{}'", (Object)name);
        this.mvStore.removeMap(name);
    }

    private String mapNameForIndex(String collectionName, String indexName) {
        return this.getFullCollectionNamespace(collectionName) + "._index_" + indexName;
    }

    public void drop(Oplog oplog) {
        super.drop(oplog);
        List maps = this.mvStore.getMapNames().stream().filter(name -> name.startsWith(this.databaseName + ".") || name.startsWith(DATABASES_PREFIX + this.databaseName) || name.startsWith(META_PREFIX + this.databaseName)).map(arg_0 -> ((MVStore)this.mvStore).openMap(arg_0)).collect(Collectors.toList());
        for (MVMap map : maps) {
            this.mvStore.removeMap(map);
        }
    }

    protected MongoCollection<Object> openOrCreateCollection(String collectionName, CollectionOptions options) {
        String fullCollectionName = this.getFullCollectionNamespace(collectionName);
        MVMap dataMap = this.mvStore.openMap(DATABASES_PREFIX + fullCollectionName);
        MVMap metaMap = this.mvStore.openMap(META_PREFIX + fullCollectionName);
        return new H2Collection((MongoDatabase)this, collectionName, options, (MVMap<Object, Document>)dataMap, (MVMap<String, Object>)metaMap, this.cursorRegistry);
    }

    protected long getStorageSize() {
        FileStore fileStore = this.mvStore.getFileStore();
        if (fileStore != null) {
            return fileStore.size();
        }
        return 0L;
    }

    protected long getFileSize() {
        return this.getStorageSize();
    }

    public void dropCollection(String collectionName, Oplog oplog) {
        super.dropCollection(collectionName, oplog);
        String fullCollectionName = this.getFullCollectionNamespace(collectionName);
        MVMap dataMap = this.mvStore.openMap(DATABASES_PREFIX + fullCollectionName);
        MVMap metaMap = this.mvStore.openMap(META_PREFIX + fullCollectionName);
        this.mvStore.removeMap(dataMap);
        this.mvStore.removeMap(metaMap);
    }

    public void moveCollection(MongoDatabase oldDatabase, MongoCollection<?> collection, String newCollectionName) {
        super.moveCollection(oldDatabase, collection, newCollectionName);
        String fullCollectionName = collection.getFullName();
        String newFullName = this.getFullCollectionNamespace(newCollectionName);
        MVMap dataMap = this.mvStore.openMap(DATABASES_PREFIX + fullCollectionName);
        MVMap metaMap = this.mvStore.openMap(META_PREFIX + fullCollectionName);
        this.mvStore.renameMap(dataMap, DATABASES_PREFIX + newFullName);
        this.mvStore.renameMap(metaMap, META_PREFIX + newFullName);
    }
}

