/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import de.bytefish.jsqlserverbulkinsert.ISqlServerBulkInsert;
import de.bytefish.jsqlserverbulkinsert.mapping.AbstractMapping;
import de.bytefish.jsqlserverbulkinsert.records.SqlServerRecord;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.stream.Stream;

public class SqlServerBulkInsert<TEntity>
implements ISqlServerBulkInsert<TEntity> {
    private final AbstractMapping<TEntity> mapping;

    public SqlServerBulkInsert(AbstractMapping<TEntity> mapping) {
        this.mapping = mapping;
    }

    @Override
    public void saveAll(Connection connection, Stream<TEntity> entities) throws SQLException {
        this.saveAll(connection, new SQLServerBulkCopyOptions(), entities);
    }

    public void saveAll(Connection connection, SQLServerBulkCopyOptions options, Stream<TEntity> entities) throws SQLException {
        try (SQLServerBulkCopy sqlServerBulkCopy = new SQLServerBulkCopy(connection);){
            sqlServerBulkCopy.setBulkCopyOptions(options);
            sqlServerBulkCopy.setDestinationTableName(this.mapping.getTableDefinition().GetFullQualifiedTableName());
            SqlServerRecord<TEntity> record = new SqlServerRecord<TEntity>(this.mapping.getColumns(), entities.iterator());
            this.internalWriteToServer(sqlServerBulkCopy, record);
        }
    }

    public void internalWriteToServer(SQLServerBulkCopy sqlServerBulkCopy, ISQLServerBulkRecord record) {
        try {
            sqlServerBulkCopy.writeToServer(record);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

