/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert.model;

import de.bytefish.jsqlserverbulkinsert.functional.Func2;
import de.bytefish.jsqlserverbulkinsert.model.ColumnMetaData;

public class ColumnDefinition<TEntityType> {
    private final ColumnMetaData columnMetaData;
    private final Func2<TEntityType, Object> propertyGetter;

    public ColumnDefinition(ColumnMetaData columnMetaData, Func2<TEntityType, Object> propertyGetter) {
        if (columnMetaData == null) {
            throw new IllegalArgumentException("columnMetaData");
        }
        if (propertyGetter == null) {
            throw new IllegalArgumentException("propertyGetter");
        }
        this.columnMetaData = columnMetaData;
        this.propertyGetter = propertyGetter;
    }

    public ColumnMetaData getColumnMetaData() {
        return this.columnMetaData;
    }

    public Object getPropertyValue(TEntityType entity) {
        return this.propertyGetter.invoke(entity);
    }

    public String toString() {
        return String.format("ColumnDefinition (ColumnMetaData = {%1$s}, Serialize = {%2$s})", this.columnMetaData, this.propertyGetter);
    }
}

