/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert.model;

import de.bytefish.jsqlserverbulkinsert.util.StringUtils;

public class TableDefinition {
    private final String schema;
    private final String tableName;

    public TableDefinition(String tableName) {
        this("", tableName);
    }

    public TableDefinition(String schema, String tableName) {
        this.schema = schema;
        this.tableName = tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String GetFullQualifiedTableName() {
        if (StringUtils.isNullOrWhiteSpace(this.schema)) {
            return this.tableName;
        }
        return String.format("%1$s.%2$s", this.schema, this.tableName);
    }

    public String toString() {
        return String.format("TableDefinition (Schema = {%1$s}, TableName = {%2$s})", this.schema, this.tableName);
    }
}

