/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.util;

import de.bytefish.pgbulkinsert.exceptions.PgConnectionException;
import de.bytefish.pgbulkinsert.util.StringUtils;
import java.sql.Connection;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.PGConnection;

public final class PostgreSqlUtils {
    public static final char QuoteChar = '\"';

    private PostgreSqlUtils() {
    }

    public static PGConnection getPGConnection(Connection connection) {
        return PostgreSqlUtils.tryGetPGConnection(connection).orElseThrow(() -> new PgConnectionException("Could not obtain a PGConnection"));
    }

    public static Optional<PGConnection> tryGetPGConnection(Connection connection) {
        Optional<PGConnection> fromCast = PostgreSqlUtils.tryCastConnection(connection);
        if (fromCast.isPresent()) {
            return fromCast;
        }
        return PostgreSqlUtils.tryUnwrapConnection(connection);
    }

    private static Optional<PGConnection> tryCastConnection(Connection connection) {
        if (connection instanceof PGConnection) {
            return Optional.of((PGConnection)connection);
        }
        return Optional.empty();
    }

    private static Optional<PGConnection> tryUnwrapConnection(Connection connection) {
        try {
            if (connection.isWrapperFor(PGConnection.class)) {
                return Optional.of(connection.unwrap(PGConnection.class));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static String quoteIdentifier(String identifier) {
        return PostgreSqlUtils.requiresQuoting(identifier) ? '\"' + identifier + '\"' : identifier;
    }

    public static String getFullyQualifiedTableName(@Nullable String schemaName, String tableName, boolean usePostgresQuoting) {
        if (usePostgresQuoting) {
            return StringUtils.isNullOrWhiteSpace(schemaName) ? PostgreSqlUtils.quoteIdentifier(tableName) : String.format("%s.%s", PostgreSqlUtils.quoteIdentifier(schemaName), PostgreSqlUtils.quoteIdentifier(tableName));
        }
        if (StringUtils.isNullOrWhiteSpace(schemaName)) {
            return tableName;
        }
        return String.format("%1$s.%2$s", schemaName, tableName);
    }

    private static boolean requiresQuoting(String identifier) {
        char first = identifier.charAt(0);
        char last = identifier.charAt(identifier.length() - 1);
        return first != '\"' || last != '\"';
    }
}

