/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.util.BigDecimalUtils;
import java.io.DataOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class BigDecimalValueHandler<T extends Number>
extends BaseValueHandler<T> {
    private static final int DECIMAL_DIGITS = 4;
    private static final BigInteger TEN_THOUSAND = new BigInteger("10000");

    @Override
    protected void internalHandle(DataOutputStream buffer, T value) throws Exception {
        BigDecimal tmpValue = BigDecimalValueHandler.getNumericAsBigDecimal(value);
        int fractionDigits = tmpValue.scale();
        int fractionGroups = fractionDigits > 0 ? (fractionDigits + 3) / 4 : 0;
        List<Integer> digits = this.digits(tmpValue);
        buffer.writeInt(8 + 2 * digits.size());
        buffer.writeShort(digits.size());
        buffer.writeShort(digits.size() - fractionGroups - 1);
        buffer.writeShort(tmpValue.signum() == 1 ? 0 : 16384);
        buffer.writeShort(fractionDigits > 0 ? fractionDigits : 0);
        for (int pos = digits.size() - 1; pos >= 0; --pos) {
            int valueToWrite = digits.get(pos);
            buffer.writeShort(valueToWrite);
        }
    }

    @Override
    public int getLength(T value) {
        List<Integer> digits = this.digits(BigDecimalValueHandler.getNumericAsBigDecimal(value));
        return 8 + 2 * digits.size();
    }

    private static BigDecimal getNumericAsBigDecimal(Number source) {
        if (source instanceof BigDecimal) {
            return (BigDecimal)source;
        }
        if (source instanceof BigInteger) {
            return new BigDecimal((BigInteger)source);
        }
        return BigDecimalUtils.toBigDecimal(source.doubleValue());
    }

    private List<Integer> digits(BigDecimal value) {
        BigInteger unscaledValue = value.unscaledValue();
        if (value.signum() == -1) {
            unscaledValue = unscaledValue.negate();
        }
        ArrayList<Integer> digits = new ArrayList<Integer>();
        if (value.scale() > 0) {
            BigInteger[] result;
            int scaleRemainder = value.scale() % 4;
            if (scaleRemainder != 0) {
                result = unscaledValue.divideAndRemainder(BigInteger.TEN.pow(scaleRemainder));
                int digit = result[1].intValue() * (int)Math.pow(10.0, 4 - scaleRemainder);
                digits.add(digit);
                unscaledValue = result[0];
            }
            while (!unscaledValue.equals(BigInteger.ZERO)) {
                result = unscaledValue.divideAndRemainder(TEN_THOUSAND);
                digits.add(result[1].intValue());
                unscaledValue = result[0];
            }
        } else {
            BigInteger originalValue = unscaledValue.multiply(BigInteger.TEN.pow(Math.abs(value.scale())));
            while (!originalValue.equals(BigInteger.ZERO)) {
                BigInteger[] result = originalValue.divideAndRemainder(TEN_THOUSAND);
                digits.add(result[1].intValue());
                originalValue = result[0];
            }
        }
        return digits;
    }
}

