// Generated by delombok at Fri Apr 01 13:59:16 CEST 2022
package de.captaingoldfish.scim.sdk.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import de.captaingoldfish.scim.sdk.client.http.BasicAuth;
import de.captaingoldfish.scim.sdk.client.http.ConfigManipulator;
import de.captaingoldfish.scim.sdk.client.http.ProxyHelper;
import de.captaingoldfish.scim.sdk.client.keys.KeyStoreWrapper;


/**
 * author Pascal Knueppel <br>
 * created at: 10.12.2019 - 13:39 <br>
 * <br>
 */
public class ScimClientConfig
{

  /**
   * the default timeout value to use in seconds
   */
  public static final int DEFAULT_TIMEOUT = 10;

  /**
   * request timeout in seconds
   */
  private int requestTimeout;

  /**
   * socket timeout in seconds
   */
  private int socketTimeout;

  /**
   * connect timeout in seconds
   */
  private int connectTimeout;

  /**
   * if cookie management should be enabled or not. Default is false.
   */
  private boolean enableCookieManagement;

  /**
   * if large request operation lists should automatically be split into several requests based on the
   * maxOperations value from the service provider. Please note that a failed request in the middle of the
   * process might cause unwanted results on the server that need to be resolved manually.
   */
  private boolean enableAutomaticBulkRequestSplitting;

  /**
   * the hostname verifier that should be used in the requests
   */
  private HostnameVerifier hostnameVerifier;

  /**
   * proxy if the request must be sent through a proxy
   */
  private ProxyHelper proxy;

  /**
   * the keystore that should be used for client authentication
   */
  private KeyStoreWrapper clientAuth;

  /**
   * the truststore to trust the server
   */
  private KeyStoreWrapper truststore;

  /**
   * additional http headers that may be used to authorize at the scim server
   */
  private Map<String, String[]> httpHeaders;

  /**
   * an optional basic authentication object
   */
  private BasicAuth basicAuth;

  /**
   * may be used to manipulate the apache configuration before the http client is created
   */
  private ConfigManipulator configManipulator;

  public ScimClientConfig(Integer requestTimeout,
                          Integer socketTimeout,
                          Integer connectTimeout,
                          boolean enableCookieManagement,
                          boolean enableAutomaticBulkRequestSplitting,
                          HostnameVerifier hostnameVerifier,
                          ProxyHelper proxy,
                          KeyStoreWrapper clientAuth,
                          KeyStoreWrapper truststore,
                          Map<String, String> httpHeaders,
                          Map<String, String[]> httpMultiHeaders,
                          BasicAuth basicAuth,
                          ConfigManipulator configManipulator)
  {
    this.requestTimeout = requestTimeout == null ? DEFAULT_TIMEOUT : requestTimeout;
    this.socketTimeout = socketTimeout == null ? DEFAULT_TIMEOUT : socketTimeout;
    this.connectTimeout = connectTimeout == null ? DEFAULT_TIMEOUT : connectTimeout;
    this.enableCookieManagement = enableCookieManagement;
    this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
    this.hostnameVerifier = hostnameVerifier;
    this.proxy = proxy;
    this.clientAuth = clientAuth;
    this.truststore = truststore;
    setHeaders(httpHeaders, httpMultiHeaders);
    this.basicAuth = basicAuth;
    this.configManipulator = configManipulator;
  }

  /**
   * merges the values of the single headers map and the multi-headers map into a single map
   */
  private void setHeaders(Map<String, String> httpSingleHeaders, Map<String, String[]> httpMultiHeaders)
  {
    this.httpHeaders = new HashMap<>();
    if (httpSingleHeaders != null)
    {
      httpSingleHeaders.forEach((key, value) -> this.httpHeaders.put(key, new String[]{value}));
    }
    if (httpMultiHeaders != null)
    {
      httpMultiHeaders.forEach((key, valueArray) -> {
        String[] multiValues = this.httpHeaders.get(key);
        if (multiValues == null)
        {
          this.httpHeaders.put(key, valueArray);
        }
        else
        {
          List<String> headerList = new ArrayList<>(Arrays.asList(multiValues));
          headerList.addAll(Arrays.asList(valueArray));
          this.httpHeaders.put(key, headerList.toArray(new String[0]));
        }
      });
    }
  }


  /**
   * override lombok builder
   */
  public static class ScimClientConfigBuilder
  {

    @java.lang.SuppressWarnings("all")
    private Integer requestTimeout;

    @java.lang.SuppressWarnings("all")
    private Integer socketTimeout;

    @java.lang.SuppressWarnings("all")
    private Integer connectTimeout;

    @java.lang.SuppressWarnings("all")
    private boolean enableCookieManagement;

    @java.lang.SuppressWarnings("all")
    private boolean enableAutomaticBulkRequestSplitting;

    @java.lang.SuppressWarnings("all")
    private HostnameVerifier hostnameVerifier;

    @java.lang.SuppressWarnings("all")
    private ProxyHelper proxy;

    @java.lang.SuppressWarnings("all")
    private KeyStoreWrapper clientAuth;

    @java.lang.SuppressWarnings("all")
    private KeyStoreWrapper truststore;

    @java.lang.SuppressWarnings("all")
    private Map<String, String> httpHeaders;

    @java.lang.SuppressWarnings("all")
    private Map<String, String[]> httpMultiHeaders;

    @java.lang.SuppressWarnings("all")
    private BasicAuth basicAuth;

    @java.lang.SuppressWarnings("all")
    private ConfigManipulator configManipulator;

    public ScimClientConfigBuilder basic(String username, String password)
    {
      basicAuth = BasicAuth.builder().username(username).password(password).build();
      return this;
    }

    @java.lang.SuppressWarnings("all")
    ScimClientConfigBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder requestTimeout(final Integer requestTimeout)
    {
      this.requestTimeout = requestTimeout;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder socketTimeout(final Integer socketTimeout)
    {
      this.socketTimeout = socketTimeout;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder connectTimeout(final Integer connectTimeout)
    {
      this.connectTimeout = connectTimeout;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder enableCookieManagement(final boolean enableCookieManagement)
    {
      this.enableCookieManagement = enableCookieManagement;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder enableAutomaticBulkRequestSplitting(final boolean enableAutomaticBulkRequestSplitting)
    {
      this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder hostnameVerifier(final HostnameVerifier hostnameVerifier)
    {
      this.hostnameVerifier = hostnameVerifier;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder proxy(final ProxyHelper proxy)
    {
      this.proxy = proxy;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder clientAuth(final KeyStoreWrapper clientAuth)
    {
      this.clientAuth = clientAuth;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder truststore(final KeyStoreWrapper truststore)
    {
      this.truststore = truststore;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder httpHeaders(final Map<String, String> httpHeaders)
    {
      this.httpHeaders = httpHeaders;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder httpMultiHeaders(final Map<String, String[]> httpMultiHeaders)
    {
      this.httpMultiHeaders = httpMultiHeaders;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder basicAuth(final BasicAuth basicAuth)
    {
      this.basicAuth = basicAuth;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ScimClientConfig.ScimClientConfigBuilder configManipulator(final ConfigManipulator configManipulator)
    {
      this.configManipulator = configManipulator;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public ScimClientConfig build()
    {
      return new ScimClientConfig(this.requestTimeout, this.socketTimeout, this.connectTimeout,
                                  this.enableCookieManagement, this.enableAutomaticBulkRequestSplitting,
                                  this.hostnameVerifier, this.proxy, this.clientAuth, this.truststore, this.httpHeaders,
                                  this.httpMultiHeaders, this.basicAuth, this.configManipulator);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString()
    {
      return "ScimClientConfig.ScimClientConfigBuilder(requestTimeout=" + this.requestTimeout + ", socketTimeout="
             + this.socketTimeout + ", connectTimeout=" + this.connectTimeout + ", enableCookieManagement="
             + this.enableCookieManagement + ", enableAutomaticBulkRequestSplitting="
             + this.enableAutomaticBulkRequestSplitting + ", hostnameVerifier=" + this.hostnameVerifier + ", proxy="
             + this.proxy + ", clientAuth=" + this.clientAuth + ", truststore=" + this.truststore + ", httpHeaders="
             + this.httpHeaders + ", httpMultiHeaders=" + this.httpMultiHeaders + ", basicAuth=" + this.basicAuth
             + ", configManipulator=" + this.configManipulator + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static ScimClientConfig.ScimClientConfigBuilder builder()
  {
    return new ScimClientConfig.ScimClientConfigBuilder();
  }

  /**
   * request timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  public int getRequestTimeout()
  {
    return this.requestTimeout;
  }

  /**
   * socket timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  public int getSocketTimeout()
  {
    return this.socketTimeout;
  }

  /**
   * connect timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  public int getConnectTimeout()
  {
    return this.connectTimeout;
  }

  /**
   * if cookie management should be enabled or not. Default is false.
   */
  @java.lang.SuppressWarnings("all")
  public boolean isEnableCookieManagement()
  {
    return this.enableCookieManagement;
  }

  /**
   * if large request operation lists should automatically be split into several requests based on the
   * maxOperations value from the service provider. Please note that a failed request in the middle of the
   * process might cause unwanted results on the server that need to be resolved manually.
   */
  @java.lang.SuppressWarnings("all")
  public boolean isEnableAutomaticBulkRequestSplitting()
  {
    return this.enableAutomaticBulkRequestSplitting;
  }

  /**
   * the hostname verifier that should be used in the requests
   */
  @java.lang.SuppressWarnings("all")
  public HostnameVerifier getHostnameVerifier()
  {
    return this.hostnameVerifier;
  }

  /**
   * proxy if the request must be sent through a proxy
   */
  @java.lang.SuppressWarnings("all")
  public ProxyHelper getProxy()
  {
    return this.proxy;
  }

  /**
   * the keystore that should be used for client authentication
   */
  @java.lang.SuppressWarnings("all")
  public KeyStoreWrapper getClientAuth()
  {
    return this.clientAuth;
  }

  /**
   * the truststore to trust the server
   */
  @java.lang.SuppressWarnings("all")
  public KeyStoreWrapper getTruststore()
  {
    return this.truststore;
  }

  /**
   * additional http headers that may be used to authorize at the scim server
   */
  @java.lang.SuppressWarnings("all")
  public Map<String, String[]> getHttpHeaders()
  {
    return this.httpHeaders;
  }

  /**
   * an optional basic authentication object
   */
  @java.lang.SuppressWarnings("all")
  public BasicAuth getBasicAuth()
  {
    return this.basicAuth;
  }

  /**
   * may be used to manipulate the apache configuration before the http client is created
   */
  @java.lang.SuppressWarnings("all")
  public ConfigManipulator getConfigManipulator()
  {
    return this.configManipulator;
  }

  /**
   * request timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  public void setRequestTimeout(final int requestTimeout)
  {
    this.requestTimeout = requestTimeout;
  }

  /**
   * socket timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  public void setSocketTimeout(final int socketTimeout)
  {
    this.socketTimeout = socketTimeout;
  }

  /**
   * connect timeout in seconds
   */
  @java.lang.SuppressWarnings("all")
  public void setConnectTimeout(final int connectTimeout)
  {
    this.connectTimeout = connectTimeout;
  }

  /**
   * if cookie management should be enabled or not. Default is false.
   */
  @java.lang.SuppressWarnings("all")
  public void setEnableCookieManagement(final boolean enableCookieManagement)
  {
    this.enableCookieManagement = enableCookieManagement;
  }

  /**
   * if large request operation lists should automatically be split into several requests based on the
   * maxOperations value from the service provider. Please note that a failed request in the middle of the
   * process might cause unwanted results on the server that need to be resolved manually.
   */
  @java.lang.SuppressWarnings("all")
  public void setEnableAutomaticBulkRequestSplitting(final boolean enableAutomaticBulkRequestSplitting)
  {
    this.enableAutomaticBulkRequestSplitting = enableAutomaticBulkRequestSplitting;
  }

  /**
   * the hostname verifier that should be used in the requests
   */
  @java.lang.SuppressWarnings("all")
  public void setHostnameVerifier(final HostnameVerifier hostnameVerifier)
  {
    this.hostnameVerifier = hostnameVerifier;
  }

  /**
   * proxy if the request must be sent through a proxy
   */
  @java.lang.SuppressWarnings("all")
  public void setProxy(final ProxyHelper proxy)
  {
    this.proxy = proxy;
  }

  /**
   * the keystore that should be used for client authentication
   */
  @java.lang.SuppressWarnings("all")
  public void setClientAuth(final KeyStoreWrapper clientAuth)
  {
    this.clientAuth = clientAuth;
  }

  /**
   * the truststore to trust the server
   */
  @java.lang.SuppressWarnings("all")
  public void setTruststore(final KeyStoreWrapper truststore)
  {
    this.truststore = truststore;
  }

  /**
   * additional http headers that may be used to authorize at the scim server
   */
  @java.lang.SuppressWarnings("all")
  public void setHttpHeaders(final Map<String, String[]> httpHeaders)
  {
    this.httpHeaders = httpHeaders;
  }

  /**
   * an optional basic authentication object
   */
  @java.lang.SuppressWarnings("all")
  public void setBasicAuth(final BasicAuth basicAuth)
  {
    this.basicAuth = basicAuth;
  }

  /**
   * may be used to manipulate the apache configuration before the http client is created
   */
  @java.lang.SuppressWarnings("all")
  public void setConfigManipulator(final ConfigManipulator configManipulator)
  {
    this.configManipulator = configManipulator;
  }

  @java.lang.SuppressWarnings("all")
  public ScimClientConfig()
  {}
}
