/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client;

import de.captaingoldfish.scim.sdk.client.ScimClientConfig;
import de.captaingoldfish.scim.sdk.client.builder.BulkBuilder;
import de.captaingoldfish.scim.sdk.client.builder.CreateBuilder;
import de.captaingoldfish.scim.sdk.client.builder.DeleteBuilder;
import de.captaingoldfish.scim.sdk.client.builder.GetBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ListBuilder;
import de.captaingoldfish.scim.sdk.client.builder.PatchBuilder;
import de.captaingoldfish.scim.sdk.client.builder.UpdateBuilder;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.client.response.ServerResponse;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimRequestBuilder
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ScimRequestBuilder.class);
    private final String baseUrl;
    private final ScimClientConfig scimClientConfig;
    private ScimHttpClient scimHttpClient;
    private ServiceProvider serviceProvider;

    public ScimRequestBuilder(String baseUrl, ScimClientConfig scimClientConfig) {
        this.baseUrl = baseUrl.replaceFirst("/$", "");
        this.scimClientConfig = scimClientConfig;
        this.scimHttpClient = new ScimHttpClient(scimClientConfig);
        this.serviceProvider = this.loadServiceProviderConfiguration();
    }

    public ServiceProvider loadServiceProviderConfiguration() {
        try {
            boolean isError;
            log.info("Trying to load service provider configuration from SCIM provider");
            ServerResponse response = this.get(ServiceProvider.class, "/ServiceProviderConfig").sendRequest();
            boolean bl = isError = !response.isSuccess();
            if (isError) {
                log.warn("Failed to load service provider configuration: status: '{}' responseBody: '{}'", (Object)response.getHttpStatus(), (Object)response.getResponseBody());
            }
            return (ServiceProvider)response.getResource();
        }
        catch (Exception ex) {
            log.warn("Failed to load service provider configuration from SCIM provider", (Throwable)ex);
            return null;
        }
    }

    public <T extends ResourceNode> CreateBuilder<T> create(Class<T> type, String endpoint) {
        return new CreateBuilder<T>(this.baseUrl, endpoint, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> CreateBuilder<T> create(String fullyQualifiedUrl, Class<T> type) {
        return new CreateBuilder<T>(fullyQualifiedUrl, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> GetBuilder<T> get(Class<T> type, String endpoint, String resourceId) {
        return new GetBuilder<T>(this.baseUrl, endpoint, resourceId, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> GetBuilder<T> get(Class<T> type, String endpoint) {
        return new GetBuilder<T>(this.baseUrl, endpoint, null, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> GetBuilder<T> get(String fullyQualifiedUrl, Class<T> type) {
        return new GetBuilder<T>(fullyQualifiedUrl, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> DeleteBuilder<T> delete(Class<T> type, String endpoint, String resourceId) {
        return new DeleteBuilder<T>(this.baseUrl, endpoint, resourceId, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> DeleteBuilder<T> delete(Class<T> type, String endpoint) {
        return new DeleteBuilder<T>(this.baseUrl, endpoint, null, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> DeleteBuilder<T> delete(String fullyQualifiedUrl, Class<T> type) {
        return new DeleteBuilder<T>(fullyQualifiedUrl, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> UpdateBuilder<T> update(Class<T> type, String endpoint, String resourceId) {
        return new UpdateBuilder<T>(this.baseUrl, endpoint, resourceId, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> UpdateBuilder<T> update(Class<T> type, String endpoint) {
        return new UpdateBuilder<T>(this.baseUrl, endpoint, null, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> UpdateBuilder<T> update(String fullyQualifiedUrl, Class<T> type) {
        return new UpdateBuilder<T>(fullyQualifiedUrl, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> ListBuilder<T> list(Class<T> type, String endpoint) {
        return new ListBuilder<T>(this.baseUrl, endpoint, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> ListBuilder<T> list(String fullyQualifiedUrl, Class<T> type) {
        return new ListBuilder<T>(fullyQualifiedUrl, type, this.scimHttpClient);
    }

    public BulkBuilder bulk() {
        return new BulkBuilder(this.baseUrl, this.scimHttpClient, false, this.serviceProvider);
    }

    public BulkBuilder bulk(String fullyQualifiedUrl) {
        return new BulkBuilder(fullyQualifiedUrl, this.scimHttpClient, true, this.serviceProvider);
    }

    public <T extends ResourceNode> PatchBuilder<T> patch(Class<T> type, String endpoint, String resourceId) {
        return new PatchBuilder<T>(this.baseUrl, endpoint, resourceId, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> PatchBuilder<T> patch(Class<T> type, String endpoint) {
        return new PatchBuilder<T>(this.baseUrl, endpoint, null, type, this.scimHttpClient);
    }

    public <T extends ResourceNode> PatchBuilder<T> patch(String fullyQualifiedUrl, Class<T> type) {
        return new PatchBuilder<T>(fullyQualifiedUrl, type, this.scimHttpClient);
    }

    @Override
    public void close() {
        this.scimHttpClient.close();
    }

    public ScimClientConfig getScimClientConfig() {
        return this.scimClientConfig;
    }

    protected ScimHttpClient getScimHttpClient() {
        return this.scimHttpClient;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }
}

