/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.client.response.ServerResponse;
import de.captaingoldfish.scim.sdk.common.constants.enums.Comparator;
import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.request.SearchRequest;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.response.ListResponse;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class ListBuilder<T extends ResourceNode> {
    private final String baseUrl;
    private final String endpoint;
    private final Class<T> responseEntityType;
    private final Map<String, String> requestParameters = new HashMap<String, String>();
    private final ScimHttpClient scimHttpClient;
    private final String fullUrl;

    public ListBuilder(String fullUrl, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        this.baseUrl = null;
        this.endpoint = null;
        this.responseEntityType = responseEntityType;
        this.scimHttpClient = scimHttpClient;
        this.fullUrl = fullUrl;
    }

    public ListBuilder(String baseUrl, String endpoint, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        this.baseUrl = baseUrl;
        this.endpoint = endpoint;
        this.responseEntityType = responseEntityType;
        this.scimHttpClient = scimHttpClient;
        this.fullUrl = null;
    }

    public ListBuilder<T> count(int count) {
        this.requestParameters.put("count", String.valueOf(count));
        return this;
    }

    public ListBuilder<T> startIndex(long startIndex) {
        this.requestParameters.put("startIndex", String.valueOf(startIndex));
        return this;
    }

    public ListBuilder<T> sortBy(String sortBy) {
        this.requestParameters.put("sortBy", sortBy);
        return this;
    }

    public ListBuilder<T> sortOrder(SortOrder sortOrder) {
        this.requestParameters.put("sortOrder", sortOrder.name().toLowerCase());
        return this;
    }

    public ListBuilder<T> attributes(String ... attributeNames) {
        if (attributeNames != null) {
            this.requestParameters.put("attributes", String.join((CharSequence)",", attributeNames));
        }
        return this;
    }

    public ListBuilder<T> excludedAttributes(String ... attributeNames) {
        if (attributeNames != null) {
            this.requestParameters.put("excludedAttributes", String.join((CharSequence)",", attributeNames));
        }
        return this;
    }

    public FilterBuilder<T> filter(String attributeName, Comparator comparator, String value) {
        return this.filter(false, attributeName, comparator, value);
    }

    public FilterBuilder<T> filter(boolean openParanthesis, String attributeName, Comparator comparator, String value) {
        return new FilterBuilder(this, attributeName, comparator, value, openParanthesis);
    }

    public ListBuilder<T> filter(String filter) {
        this.requestParameters.put("filter", filter);
        return this;
    }

    public ListBuilder<T> custom(String attributeName, String attribute) {
        this.requestParameters.put(attributeName, attribute);
        return this;
    }

    public GetRequestBuilder<T> get() {
        return new GetRequestBuilder(this);
    }

    public PostRequestBuilder<T> post() {
        return new PostRequestBuilder(this);
    }

    protected Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public class FilterBuilder<T extends ResourceNode> {
        private final ListBuilder<T> listBuilder;
        private final StringBuilder filterString = new StringBuilder();
        private int openedParenthesis = 0;
        private int closedParenthesis = 0;

        public FilterBuilder(ListBuilder<T> listBuilder, String attributeName, Comparator comparator, String value, boolean openParenthesis) {
            this.listBuilder = listBuilder;
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
        }

        private FilterBuilder<T> openParenthesis(boolean openParenthesis) {
            if (openParenthesis) {
                ++this.openedParenthesis;
                this.filterString.append("(");
            }
            return this;
        }

        public FilterBuilder<T> closeParenthesis() {
            ++this.closedParenthesis;
            this.filterString.append(")");
            return this;
        }

        private FilterBuilder<T> closeParenthesis(boolean closeParenthesis) {
            if (closeParenthesis) {
                return this.closeParenthesis();
            }
            return this;
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, String value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, String value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Boolean value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Boolean value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Integer value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Integer value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Long value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Long value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Double value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Double value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Instant value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Instant value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, String value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, String value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Integer value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Integer value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Long value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Long value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Double value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Double value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Instant value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Instant value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value.toString());
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value.toString());
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        private void setExpression(String attributeName, Comparator comparator, Object value) {
            this.filterString.append(attributeName).append(" ").append(comparator.name());
            if (value instanceof String) {
                this.filterString.append(value == null ? "" : " ").append("\"").append(value == null ? "" : value).append("\"");
            } else {
                this.filterString.append(value == null ? "" : " " + value);
            }
        }

        public ListBuilder<T> build() {
            if (this.openedParenthesis != this.closedParenthesis) {
                throw new IllegalStateException("error within filter expression\n\topened parentheses: " + this.openedParenthesis + "\n\tclosed parentheses: " + this.closedParenthesis + "\n\tfilter: " + this.filterString.toString());
            }
            ((ListBuilder)this.listBuilder).requestParameters.put("filter", this.filterString.toString());
            return this.listBuilder;
        }
    }

    public static class ListServerResponse<T extends ResourceNode>
    extends ServerResponse<ListResponse<T>> {
        private Class<T> responseEntityType;

        public ListServerResponse(HttpResponse httpResponse, boolean expectedResponseCode, Class<ListResponse<T>> type, Class<T> responseEntityType, Function<HttpResponse, Boolean> isResponseParseable) {
            super(httpResponse, expectedResponseCode, type, isResponseParseable);
            this.responseEntityType = responseEntityType;
        }

        @Override
        public <R extends ScimObjectNode> R getResource(Class<R> responseType) {
            ListResponse listResponse = (ListResponse)JsonHelper.readJsonDocument((String)this.getResponseBody(), ListResponse.class);
            List typedResources = listResponse.getListedResources().parallelStream().map(scimObjectNode -> (ResourceNode)JsonHelper.readJsonDocument((String)scimObjectNode.toString(), this.responseEntityType)).collect(Collectors.toList());
            ListResponse typedListResponse = new ListResponse(this.responseEntityType);
            typedListResponse.setItemsPerPage(Integer.valueOf(listResponse.getItemsPerPage()));
            typedListResponse.setStartIndex(Long.valueOf(listResponse.getStartIndex()));
            typedListResponse.setTotalResults(Long.valueOf(listResponse.getTotalResults()));
            typedListResponse.setListedResources(typedResources);
            return (R)typedListResponse;
        }
    }

    public static class PostRequestBuilder<T extends ResourceNode>
    extends RequestBuilder<ListResponse<T>> {
        private ListBuilder<T> listBuilder;

        public PostRequestBuilder(ListBuilder<T> listBuilder) {
            super(((ListBuilder)listBuilder).baseUrl, ((ListBuilder)listBuilder).endpoint, new ListResponse().getClass(), ((ListBuilder)listBuilder).scimHttpClient);
            this.listBuilder = listBuilder;
        }

        @Override
        protected boolean isExpectedResponseCode(int httpStatus) {
            return 200 == httpStatus;
        }

        @Override
        protected HttpUriRequest getHttpUriRequest() {
            String url;
            HttpPost httpPost = StringUtils.isBlank((CharSequence)((ListBuilder)this.listBuilder).fullUrl) ? new HttpPost(this.getBaseUrl() + this.getEndpoint() + "/.search") : ((url = ((ListBuilder)this.listBuilder).fullUrl).endsWith("/.search") ? new HttpPost(((ListBuilder)this.listBuilder).fullUrl) : new HttpPost(((ListBuilder)this.listBuilder).fullUrl + "/.search"));
            if (!((ListBuilder)this.listBuilder).requestParameters.isEmpty()) {
                SearchRequest searchRequest = SearchRequest.builder().build();
                ((ListBuilder)this.listBuilder).requestParameters.forEach((arg_0, arg_1) -> ((SearchRequest)searchRequest).put(arg_0, arg_1));
                super.setResource((JsonNode)searchRequest);
                StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
                httpPost.setEntity((HttpEntity)stringEntity);
            }
            return httpPost;
        }

        @Override
        protected Function<HttpResponse, Boolean> isResponseParseable() {
            return httpResponse -> {
                String responseBody = httpResponse.getResponseBody();
                if (StringUtils.isNotBlank((CharSequence)responseBody) && responseBody.contains("urn:ietf:params:scim:api:messages:2.0:ListResponse")) {
                    return true;
                }
                return false;
            };
        }

        @Override
        protected ServerResponse<ListResponse<T>> toResponse(HttpResponse response) {
            return new ListServerResponse(response, this.isExpectedResponseCode(response.getHttpStatusCode()), this.getResponseEntityType(), ((ListBuilder)this.listBuilder).responseEntityType, this.isResponseParseable());
        }
    }

    public static class GetRequestBuilder<T extends ResourceNode>
    extends RequestBuilder<ListResponse<T>> {
        private ListBuilder<T> listBuilder;

        public GetRequestBuilder(ListBuilder<T> listBuilder) {
            super(((ListBuilder)listBuilder).baseUrl, ((ListBuilder)listBuilder).endpoint, new ListResponse().getClass(), ((ListBuilder)listBuilder).scimHttpClient);
            this.listBuilder = listBuilder;
        }

        @Override
        protected boolean isExpectedResponseCode(int httpStatus) {
            return 200 == httpStatus;
        }

        @Override
        protected HttpUriRequest getHttpUriRequest() {
            StringBuilder queryBuilder = new StringBuilder();
            if (!((ListBuilder)this.listBuilder).requestParameters.isEmpty()) {
                if (StringUtils.contains((CharSequence)((ListBuilder)this.listBuilder).fullUrl, (CharSequence)"?")) {
                    queryBuilder.append("&");
                } else {
                    queryBuilder.append("?");
                }
                ArrayList pairs = new ArrayList();
                ((ListBuilder)this.listBuilder).requestParameters.forEach((key, value) -> {
                    try {
                        pairs.add(key + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                });
                queryBuilder.append(String.join((CharSequence)"&", pairs));
            }
            HttpGet httpGet = StringUtils.isBlank((CharSequence)((ListBuilder)this.listBuilder).fullUrl) ? new HttpGet(this.getBaseUrl() + this.getEndpoint() + queryBuilder.toString()) : new HttpGet(((ListBuilder)this.listBuilder).fullUrl + queryBuilder.toString());
            return httpGet;
        }

        @Override
        protected Function<HttpResponse, Boolean> isResponseParseable() {
            return httpResponse -> {
                String responseBody = httpResponse.getResponseBody();
                if (StringUtils.isNotBlank((CharSequence)responseBody) && responseBody.contains("urn:ietf:params:scim:api:messages:2.0:ListResponse")) {
                    return true;
                }
                return false;
            };
        }

        @Override
        protected ServerResponse<ListResponse<T>> toResponse(HttpResponse response) {
            return new ListServerResponse(response, this.isExpectedResponseCode(response.getHttpStatusCode()), this.getResponseEntityType(), ((ListBuilder)this.listBuilder).responseEntityType, this.isResponseParseable());
        }
    }
}

