// Generated by delombok at Tue Oct 15 15:17:40 CEST 2024
package de.captaingoldfish.scim.sdk.common.response;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.HttpHeader;
import de.captaingoldfish.scim.sdk.common.resources.AbstractSchemasHolder;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;


/**
 * author Pascal Knueppel <br>
 * created at: 03.10.2019 - 19:29 <br>
 * <br>
 * The abstract implementation for all responses created by this framework
 */
public abstract class ScimResponse extends AbstractSchemasHolder
{

  /**
   * contains the http header attributes for the response
   */
  private Map<String, String> httpHeaders = new HashMap<>();

  public ScimResponse(JsonNode responseNode)
  {
    super();
    if (responseNode != null)
    {
      responseNode.fields().forEachRemaining(childNode -> {
        this.set(childNode.getKey(), childNode.getValue());
      });
    }
    httpHeaders.put(HttpHeader.CONTENT_TYPE_HEADER, HttpHeader.SCIM_CONTENT_TYPE);
  }

  /**
   * will set the entity tag into the response headers
   *
   * @param meta the meta attribute that might contain a version-attribute which is the entity tag
   */
  protected void setETag(Meta meta)
  {
    if (meta != null && meta.getVersion().isPresent())
    {
      getHttpHeaders().put(HttpHeader.E_TAG_HEADER, meta.getVersion().get().getEntityTag());
    }
  }

  /**
   * builds a response object that should be usable with most of the common rest apis
   *
   * @return a jax-rs response containing the response body and the http headers
   */
  public Response buildResponse()
  {
    Response.ResponseBuilder responseBuilder = Response.status(getHttpStatus());
    httpHeaders.forEach(responseBuilder::header);
    if (this.size() != 0)
    {
      responseBuilder.entity(toString());
    }
    return responseBuilder.build();
  }

  /**
   * builds a response object that should be usable with most of the common rest apis
   *
   * @return a jakarta-rs response containing the response body and the http headers
   */
  public jakarta.ws.rs.core.Response buildJakartaResponse()
  {
    jakarta.ws.rs.core.Response.ResponseBuilder responseBuilder = jakarta.ws.rs.core.Response.status(getHttpStatus());
    httpHeaders.forEach(responseBuilder::header);
    if (this.size() != 0)
    {
      responseBuilder.entity(toString());
    }
    return responseBuilder.build();
  }

  /**
   * the http status code of the response
   */
  public abstract int getHttpStatus();

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected ScimResponse()
  {}

  /**
   * contains the http header attributes for the response
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getHttpHeaders()
  {
    return this.httpHeaders;
  }
}
