/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.ResponseException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponse
extends ScimResponse {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorResponse.class);
    private ScimException scimException;

    public ErrorResponse(JsonNode responseNode) {
        super(responseNode);
        this.setSchemas(Collections.singletonList("urn:ietf:params:scim:api:messages:2.0:Error"));
        this.scimException = new ResponseException(this.getDetail().orElse(null), this.getStatus(), this.getScimType().orElse(null));
    }

    public ErrorResponse(ScimException scimException) {
        this(scimException, false);
    }

    public ErrorResponse(ScimException scimException, boolean useDetailMessage) {
        super((JsonNode)null);
        this.scimException = scimException;
        if (500 == this.getHttpStatus() && !useDetailMessage) {
            log.error(scimException.getMessage(), (Throwable)scimException);
            this.setDetail("An internal error has occurred.");
        } else {
            log.debug(scimException.getMessage(), (Throwable)scimException);
            this.setDetail(scimException.getDetail());
        }
        this.setSchemas(Collections.singletonList("urn:ietf:params:scim:api:messages:2.0:Error"));
        this.setStatus(scimException.getStatus());
        this.setScimType(scimException.getScimType());
        Optional.ofNullable(scimException.getResponseHeaders()).ifPresent(this.getHttpHeaders()::putAll);
    }

    public int getStatus() {
        return this.getIntegerAttribute("status").orElseThrow(() -> new InternalServerException("the http 'status' is a mandatory attribute", null, null));
    }

    public void setStatus(int status) {
        this.setAttribute("status", status);
    }

    public Optional<String> getScimType() {
        return this.getStringAttribute("scimType");
    }

    public void setScimType(String scimType) {
        this.setAttribute("scimType", scimType);
    }

    public Optional<String> getDetail() {
        return this.getStringAttribute("detail");
    }

    public void setDetail(String detail) {
        this.setAttribute("detail", detail);
    }

    public List<String> getErrorMessages() {
        ObjectNode errors = (ObjectNode)this.get("errors");
        if (errors == null) {
            return Collections.emptyList();
        }
        ArrayNode errorMessages = Optional.ofNullable((ArrayNode)errors.get("errorMessages")).orElse(new ArrayNode(JsonNodeFactory.instance));
        if (errorMessages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> errorMessageList = new ArrayList<String>();
        errorMessages.forEach(node -> errorMessageList.add(node.textValue()));
        return errorMessageList;
    }

    public Map<String, List<String>> getFieldErrors() {
        ObjectNode errors = (ObjectNode)this.get("errors");
        if (errors == null) {
            return new HashMap<String, List<String>>();
        }
        ObjectNode fieldErrors = Optional.ofNullable((ObjectNode)errors.get("fieldErrors")).orElse(new ObjectNode(JsonNodeFactory.instance));
        if (fieldErrors.isEmpty()) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> errorMessageList = new HashMap<String, List<String>>();
        fieldErrors.fields().forEachRemaining(nodeDefinition -> {
            ArrayList errorMessages = new ArrayList();
            ((JsonNode)nodeDefinition.getValue()).forEach(node -> errorMessages.add(node.textValue()));
            errorMessageList.put((String)nodeDefinition.getKey(), errorMessages);
        });
        return errorMessageList;
    }

    @Override
    public int getHttpStatus() {
        return this.scimException == null ? 0 : this.scimException.getStatus();
    }

    private boolean useEmptyBody() {
        return this.getHttpStatus() < 400 && StringUtils.isBlank((CharSequence)this.getDetail().orElse(null)) && StringUtils.isBlank((CharSequence)this.getScimType().orElse(null));
    }

    @Override
    public String toString() {
        if (this.useEmptyBody()) {
            return "";
        }
        return super.toString();
    }

    @Override
    public String toPrettyString() {
        if (this.useEmptyBody()) {
            return "";
        }
        return super.toPrettyString();
    }

    @Generated
    public ErrorResponse() {
    }

    @Generated
    public ScimException getScimException() {
        return this.scimException;
    }
}

