/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.response;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.List;
import lombok.Generated;

public class BulkResponseGetOperation
extends ScimObjectNode {
    public BulkResponseGetOperation(String nodePath, String resourceId, Integer status, String resourceType, ScimResponse resource, List<BulkResponseGetOperation> children) {
        this.setNodePath(nodePath);
        this.setResourceId(resourceId);
        this.setStatus(status);
        this.setResourceType(resourceType);
        this.setResource(resource);
        this.setChildren(children);
    }

    public String getResourceId() {
        return this.getStringAttribute("resourceId").orElse(null);
    }

    public void setResourceId(String resourceId) {
        this.setAttribute("resourceId", resourceId);
    }

    public String getNodePath() {
        return this.getStringAttribute("nodePath").orElse(null);
    }

    public void setNodePath(String nodePath) {
        this.setAttribute("nodePath", nodePath);
    }

    public Integer getStatus() {
        return this.getIntegerAttribute("status").orElse(0);
    }

    public void setStatus(Integer status) {
        this.setAttribute("status", status);
    }

    public String getResourceType() {
        return this.getStringAttribute("resourceType").orElse(null);
    }

    public void setResourceType(String resourceType) {
        this.setAttribute("resourceType", resourceType);
    }

    public <T extends ResourceNode> T getResource(Class<T> type) {
        JsonNode resourceNode = this.get("resource");
        if (resourceNode == null) {
            return null;
        }
        if (resourceNode.isTextual()) {
            return (T)((ResourceNode)JsonHelper.readJsonDocument(resourceNode.toString(), type));
        }
        return (T)((ResourceNode)JsonHelper.copyResourceToObject(resourceNode, type));
    }

    public ErrorResponse getErrorResponse() {
        JsonNode resourceNode = this.get("resource");
        if (resourceNode == null) {
            return null;
        }
        if (resourceNode.isTextual()) {
            return JsonHelper.readJsonDocument(resourceNode.toString(), ErrorResponse.class);
        }
        return JsonHelper.copyResourceToObject(resourceNode, ErrorResponse.class);
    }

    public <T extends ScimResponse> void setResource(T resource) {
        this.setAttribute("resource", resource);
    }

    public List<BulkResponseGetOperation> getChildren() {
        return this.getArrayAttribute("children", BulkResponseGetOperation.class);
    }

    public void setChildren(List<BulkResponseGetOperation> children) {
        this.setAttribute("children", children);
    }

    @Generated
    public static BulkResponseGetOperationBuilder builder() {
        return new BulkResponseGetOperationBuilder();
    }

    @Generated
    public BulkResponseGetOperation() {
    }

    public static class BulkResponseGetOperationBuilder {
        @Generated
        private String nodePath;
        @Generated
        private String resourceId;
        @Generated
        private Integer status;
        @Generated
        private String resourceType;
        @Generated
        private ScimResponse resource;
        @Generated
        private List<BulkResponseGetOperation> children;

        @Generated
        public BulkResponseGetOperationBuilder nodePath(String nodePath) {
            this.nodePath = nodePath;
            return this;
        }

        @Generated
        public BulkResponseGetOperationBuilder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Generated
        public BulkResponseGetOperationBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        @Generated
        public BulkResponseGetOperationBuilder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Generated
        public BulkResponseGetOperationBuilder resource(ScimResponse resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public BulkResponseGetOperationBuilder children(List<BulkResponseGetOperation> children) {
            this.children = children;
            return this;
        }

        @Generated
        public BulkResponseGetOperation build() {
            return new BulkResponseGetOperation(this.nodePath, this.resourceId, this.status, this.resourceType, this.resource, this.children);
        }

        @Generated
        public String toString() {
            return "BulkResponseGetOperation.BulkResponseGetOperationBuilder(nodePath=" + this.nodePath + ", resourceId=" + this.resourceId + ", status=" + this.status + ", resourceType=" + this.resourceType + ", resource=" + this.resource + ", children=" + this.children + ")";
        }
    }
}

