// Generated by delombok at Mon Sep 08 23:23:30 CEST 2025
package de.captaingoldfish.scim.sdk.common.resources;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.constants.ResourceTypeNames;
import de.captaingoldfish.scim.sdk.common.constants.SchemaUris;
import de.captaingoldfish.scim.sdk.common.resources.complex.BulkConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.ChangePasswordConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.ETagConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.FilterConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.SortConfig;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.AuthenticationScheme;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;


/**
 * author Pascal Knueppel <br>
 * created at: 18.10.2019 - 09:39 <br>
 * <br>
 * SCIM provides a schema for representing the service provider's configuration, identified using the
 * following schema URI: "urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig". The service provider
 * configuration resource enables a service provider to discover SCIM specification features in a standardized
 * form as well as provide additional implementation details to clients. All attributes have a mutability of
 * "readOnly". Unlike other core resources, the "id" attribute is not required for the service provider
 * configuration resource.
 */
public class ServiceProvider extends ResourceNode
{

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ServiceProvider.class);

  /**
   * this thread pool can be set to override the default thread pool when resources are auto-sorted or
   * auto-filtered
   */
  private ForkJoinPool threadPool = ForkJoinPool.commonPool();

  /**
   * if the attributes within the resource objects should be extracted case-insensitive or case exact by their
   * attribute-names.<br>
   * This feature does not work for patch requests
   */
  private boolean caseInsensitiveValidation;

  /**
   * if the {@link SchemaAttribute#getDefaultValue()} should be respected on requests
   */
  private boolean useDefaultValuesOnRequest = true;

  /**
   * if the {@link SchemaAttribute#getDefaultValue()} should be respected on responses
   */
  private boolean useDefaultValuesOnResponse = true;

  /**
   * if required attributes should only be validated on request or on request and response
   */
  private boolean ignoreRequiredAttributesOnResponse = false;

  /**
   * if required extensions should only be validated on request or on request and response
   */
  private boolean ignoreRequiredExtensionsOnResponse = false;

  private boolean lenientContentTypeChecking = false;

  /**
   * @param documentationUri the URL to the documentation of the application
   * @param patchConfig the patch configuration
   * @param changePasswordConfig if changing passwords is supported or not
   * @param sortConfig the sorting configuration
   * @param eTagConfig the etag configuration
   * @param filterConfig the filter configuration
   * @param bulkConfig the bulk configuration
   * @param authenticationSchemes the supported authentication schemes
   * @param forkJoinPool the join pool that is used to handle parallel streams. The
   *          {@link ForkJoinPool#commonPool()} is used by default.
   * @param caseInsensitiveValidation if attributes within the JSON document should be extracted
   *          case-insensitive or case-sensitive. The difference here is that the case-insensitive check uses
   *          another comparator that eats up more performance than the case-sensitive comparator.
   */
  public ServiceProvider(String documentationUri,
                         PatchConfig patchConfig,
                         ChangePasswordConfig changePasswordConfig,
                         SortConfig sortConfig,
                         ETagConfig eTagConfig,
                         FilterConfig filterConfig,
                         BulkConfig bulkConfig,
                         List<AuthenticationScheme> authenticationSchemes,
                         ForkJoinPool forkJoinPool,
                         boolean caseInsensitiveValidation,
                         boolean useDefaultValuesOnRequest,
                         boolean useDefaultValuesOnResponse,
                         Boolean ignoreRequiredAttributesOnResponse,
                         Boolean ignoreRequiredExtensionsOnResponse,
                         boolean lenientContentTypeChecking)
  {
    setSchemas(Arrays.asList(SchemaUris.SERVICE_PROVIDER_CONFIG_URI));
    setDocumentationUri(documentationUri);
    setPatchConfig(patchConfig);
    setChangePasswordConfig(changePasswordConfig);
    setSortConfig(sortConfig);
    setETagConfig(eTagConfig);
    setFilterConfig(filterConfig);
    setBulkConfig(bulkConfig);
    setAuthenticationSchemes(authenticationSchemes);
    Meta meta = Meta.builder()
                    .resourceType(ResourceTypeNames.SERVICE_PROVIDER_CONFIG)
                    .created(LocalDateTime.now())
                    .lastModified(LocalDateTime.now())
                    .build();
    setMeta(meta);
    Optional.ofNullable(forkJoinPool).ifPresent(this::setThreadPool);
    this.caseInsensitiveValidation = caseInsensitiveValidation;
    this.useDefaultValuesOnRequest = useDefaultValuesOnRequest;
    this.useDefaultValuesOnResponse = useDefaultValuesOnResponse;
    this.lenientContentTypeChecking = lenientContentTypeChecking;
    this.ignoreRequiredAttributesOnResponse = Optional.ofNullable(ignoreRequiredAttributesOnResponse).orElse(true);
    this.ignoreRequiredExtensionsOnResponse = Optional.ofNullable(ignoreRequiredExtensionsOnResponse).orElse(true);
  }

  /**
   * An HTTP-addressable URL pointing to the service provider's human-consumable help documentation. OPTIONAL.
   */
  public Optional<String> getDocumentationUri()
  {
    return getStringAttribute(AttributeNames.RFC7643.DOCUMENTATION_URI);
  }

  /**
   * An HTTP-addressable URL pointing to the service provider's human-consumable help documentation. OPTIONAL.
   */
  public void setDocumentationUri(String documentationUri)
  {
    setAttribute(AttributeNames.RFC7643.DOCUMENTATION_URI, documentationUri);
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies PATCH configuration options. REQUIRED. See Section 3.5.2 of [RFC7644].
   */
  public PatchConfig getPatchConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.PATCH, PatchConfig.class).orElseGet(PatchConfig::new);
  }

  /**
   * A complex type that specifies PATCH configuration options. REQUIRED. See Section 3.5.2 of [RFC7644].
   */
  public void setPatchConfig(PatchConfig patchConfig)
  {
    setAttribute(AttributeNames.RFC7643.PATCH,
                 Optional.ofNullable(patchConfig).orElseGet(() -> PatchConfig.builder().build()));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies bulk configuration options. See Section 3.7 of [RFC7644]. REQUIRED.
   */
  public BulkConfig getBulkConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.BULK, BulkConfig.class).orElseGet(BulkConfig::new);
  }

  /**
   * A complex type that specifies bulk configuration options. See Section 3.7 of [RFC7644]. REQUIRED.
   */
  public void setBulkConfig(BulkConfig bulkConfig)
  {
    setAttribute(AttributeNames.RFC7643.BULK,
                 Optional.ofNullable(bulkConfig).orElseGet(() -> BulkConfig.builder().build()));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies FILTER options. REQUIRED. See Section 3.4.2.2 of [RFC7644].
   */
  public FilterConfig getFilterConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.FILTER, FilterConfig.class).orElseGet((FilterConfig::new));
  }

  /**
   * A complex type that specifies FILTER options. REQUIRED. See Section 3.4.2.2 of [RFC7644].
   */
  public void setFilterConfig(FilterConfig filterConfig)
  {
    setAttribute(AttributeNames.RFC7643.FILTER, Optional.ofNullable(filterConfig).orElseGet(FilterConfig::new));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies configuration options related to changing a password. REQUIRED.
   */
  public ChangePasswordConfig getChangePasswordConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.CHANGE_PASSWORD,
                              ChangePasswordConfig.class).orElseGet(ChangePasswordConfig::new);
  }

  /**
   * A complex type that specifies configuration options related to changing a password. REQUIRED.
   */
  public void setChangePasswordConfig(ChangePasswordConfig changePasswordConfig)
  {
    setAttribute(AttributeNames.RFC7643.CHANGE_PASSWORD,
                 Optional.ofNullable(changePasswordConfig).orElseGet(ChangePasswordConfig::new));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies Sort configuration options. REQUIRED.
   */
  public SortConfig getSortConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.SORT, SortConfig.class).orElseGet(SortConfig::new);
  }

  /**
   * A complex type that specifies Sort configuration options. REQUIRED.
   */
  public void setSortConfig(SortConfig sortConfig)
  {
    setAttribute(AttributeNames.RFC7643.SORT, Optional.ofNullable(sortConfig).orElseGet(SortConfig::new));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies ETag configuration options. REQUIRED.
   */
  public ETagConfig getETagConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.ETAG, ETagConfig.class).orElseGet(ETagConfig::new);
  }

  /**
   * A complex type that specifies ETag configuration options. REQUIRED.
   */
  public void setETagConfig(ETagConfig eTagConfig)
  {
    setAttribute(AttributeNames.RFC7643.ETAG, Optional.ofNullable(eTagConfig).orElseGet(ETagConfig::new));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A multi-valued complex type that specifies supported authentication scheme properties. To enable seamless
   * discovery of configurations, the service provider SHOULD, with the appropriate security considerations,
   * make the authenticationSchemes attribute publicly accessible without prior authentication. REQUIRED.
   */
  public List<AuthenticationScheme> getAuthenticationSchemes()
  {
    return getArrayAttribute(AttributeNames.RFC7643.AUTHENTICATION_SCHEMES, AuthenticationScheme.class);
  }

  /**
   * A multi-valued complex type that specifies supported authentication scheme properties. To enable seamless
   * discovery of configurations, the service provider SHOULD, with the appropriate security considerations,
   * make the authenticationSchemes attribute publicly accessible without prior authentication. REQUIRED.
   */
  public void setAuthenticationSchemes(List<AuthenticationScheme> authenticationSchemes)
  {
    setAttribute(AttributeNames.RFC7643.AUTHENTICATION_SCHEMES, authenticationSchemes);
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * @see #threadPool
   */
  public void setThreadPool(ForkJoinPool threadPool)
  {
    this.threadPool = Objects.requireNonNull(threadPool);
  }


  /**
   * override lombok builder
   */
  public static class ServiceProviderBuilder
  {

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String documentationUri;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private PatchConfig patchConfig;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private ChangePasswordConfig changePasswordConfig;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private SortConfig sortConfig;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private ETagConfig eTagConfig;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private FilterConfig filterConfig;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BulkConfig bulkConfig;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private List<AuthenticationScheme> authenticationSchemes;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private ForkJoinPool forkJoinPool;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean caseInsensitiveValidation;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean useDefaultValuesOnRequest;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean useDefaultValuesOnResponse;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean ignoreRequiredAttributesOnResponse;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Boolean ignoreRequiredExtensionsOnResponse;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean lenientContentTypeChecking;

    /**
     * make builder constructor public in order to allow inheritance for this builder
     */
    public ServiceProviderBuilder()
    {}

    /**
     * @param documentationUri the URL to the documentation of the application
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder documentationUri(final String documentationUri)
    {
      this.documentationUri = documentationUri;
      return this;
    }

    /**
     * @param patchConfig the patch configuration
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder patchConfig(final PatchConfig patchConfig)
    {
      this.patchConfig = patchConfig;
      return this;
    }

    /**
     * @param changePasswordConfig if changing passwords is supported or not
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder changePasswordConfig(final ChangePasswordConfig changePasswordConfig)
    {
      this.changePasswordConfig = changePasswordConfig;
      return this;
    }

    /**
     * @param sortConfig the sorting configuration
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder sortConfig(final SortConfig sortConfig)
    {
      this.sortConfig = sortConfig;
      return this;
    }

    /**
     * @param eTagConfig the etag configuration
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder eTagConfig(final ETagConfig eTagConfig)
    {
      this.eTagConfig = eTagConfig;
      return this;
    }

    /**
     * @param filterConfig the filter configuration
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder filterConfig(final FilterConfig filterConfig)
    {
      this.filterConfig = filterConfig;
      return this;
    }

    /**
     * @param bulkConfig the bulk configuration
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder bulkConfig(final BulkConfig bulkConfig)
    {
      this.bulkConfig = bulkConfig;
      return this;
    }

    /**
     * @param authenticationSchemes the supported authentication schemes
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder authenticationSchemes(final List<AuthenticationScheme> authenticationSchemes)
    {
      this.authenticationSchemes = authenticationSchemes;
      return this;
    }

    /**
     * @param forkJoinPool the join pool that is used to handle parallel streams. The
     *          {@link ForkJoinPool#commonPool()} is used by default.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder forkJoinPool(final ForkJoinPool forkJoinPool)
    {
      this.forkJoinPool = forkJoinPool;
      return this;
    }

    /**
     * @param caseInsensitiveValidation if attributes within the JSON document should be extracted
     *          case-insensitive or case-sensitive. The difference here is that the case-insensitive check uses
     *          another comparator that eats up more performance than the case-sensitive comparator.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder caseInsensitiveValidation(final boolean caseInsensitiveValidation)
    {
      this.caseInsensitiveValidation = caseInsensitiveValidation;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder useDefaultValuesOnRequest(final boolean useDefaultValuesOnRequest)
    {
      this.useDefaultValuesOnRequest = useDefaultValuesOnRequest;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder useDefaultValuesOnResponse(final boolean useDefaultValuesOnResponse)
    {
      this.useDefaultValuesOnResponse = useDefaultValuesOnResponse;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder ignoreRequiredAttributesOnResponse(final Boolean ignoreRequiredAttributesOnResponse)
    {
      this.ignoreRequiredAttributesOnResponse = ignoreRequiredAttributesOnResponse;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder ignoreRequiredExtensionsOnResponse(final Boolean ignoreRequiredExtensionsOnResponse)
    {
      this.ignoreRequiredExtensionsOnResponse = ignoreRequiredExtensionsOnResponse;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider.ServiceProviderBuilder lenientContentTypeChecking(final boolean lenientContentTypeChecking)
    {
      this.lenientContentTypeChecking = lenientContentTypeChecking;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceProvider build()
    {
      return new ServiceProvider(this.documentationUri, this.patchConfig, this.changePasswordConfig, this.sortConfig,
                                 this.eTagConfig, this.filterConfig, this.bulkConfig, this.authenticationSchemes,
                                 this.forkJoinPool, this.caseInsensitiveValidation, this.useDefaultValuesOnRequest,
                                 this.useDefaultValuesOnResponse, this.ignoreRequiredAttributesOnResponse,
                                 this.ignoreRequiredExtensionsOnResponse, this.lenientContentTypeChecking);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString()
    {
      return "ServiceProvider.ServiceProviderBuilder(documentationUri=" + this.documentationUri + ", patchConfig="
             + this.patchConfig + ", changePasswordConfig=" + this.changePasswordConfig + ", sortConfig="
             + this.sortConfig + ", eTagConfig=" + this.eTagConfig + ", filterConfig=" + this.filterConfig
             + ", bulkConfig=" + this.bulkConfig + ", authenticationSchemes=" + this.authenticationSchemes
             + ", forkJoinPool=" + this.forkJoinPool + ", caseInsensitiveValidation=" + this.caseInsensitiveValidation
             + ", useDefaultValuesOnRequest=" + this.useDefaultValuesOnRequest + ", useDefaultValuesOnResponse="
             + this.useDefaultValuesOnResponse + ", ignoreRequiredAttributesOnResponse="
             + this.ignoreRequiredAttributesOnResponse + ", ignoreRequiredExtensionsOnResponse="
             + this.ignoreRequiredExtensionsOnResponse + ", lenientContentTypeChecking="
             + this.lenientContentTypeChecking + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static ServiceProvider.ServiceProviderBuilder builder()
  {
    return new ServiceProvider.ServiceProviderBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ServiceProvider()
  {}

  /**
   * this thread pool can be set to override the default thread pool when resources are auto-sorted or
   * auto-filtered
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ForkJoinPool getThreadPool()
  {
    return this.threadPool;
  }

  /**
   * if the attributes within the resource objects should be extracted case-insensitive or case exact by their
   * attribute-names.<br>
   * This feature does not work for patch requests
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isCaseInsensitiveValidation()
  {
    return this.caseInsensitiveValidation;
  }

  /**
   * if the {@link SchemaAttribute#getDefaultValue()} should be respected on requests
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isUseDefaultValuesOnRequest()
  {
    return this.useDefaultValuesOnRequest;
  }

  /**
   * if the {@link SchemaAttribute#getDefaultValue()} should be respected on requests
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUseDefaultValuesOnRequest(final boolean useDefaultValuesOnRequest)
  {
    this.useDefaultValuesOnRequest = useDefaultValuesOnRequest;
  }

  /**
   * if the {@link SchemaAttribute#getDefaultValue()} should be respected on responses
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isUseDefaultValuesOnResponse()
  {
    return this.useDefaultValuesOnResponse;
  }

  /**
   * if the {@link SchemaAttribute#getDefaultValue()} should be respected on responses
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUseDefaultValuesOnResponse(final boolean useDefaultValuesOnResponse)
  {
    this.useDefaultValuesOnResponse = useDefaultValuesOnResponse;
  }

  /**
   * if required attributes should only be validated on request or on request and response
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isIgnoreRequiredAttributesOnResponse()
  {
    return this.ignoreRequiredAttributesOnResponse;
  }

  /**
   * if required attributes should only be validated on request or on request and response
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIgnoreRequiredAttributesOnResponse(final boolean ignoreRequiredAttributesOnResponse)
  {
    this.ignoreRequiredAttributesOnResponse = ignoreRequiredAttributesOnResponse;
  }

  /**
   * if required extensions should only be validated on request or on request and response
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isIgnoreRequiredExtensionsOnResponse()
  {
    return this.ignoreRequiredExtensionsOnResponse;
  }

  /**
   * if required extensions should only be validated on request or on request and response
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIgnoreRequiredExtensionsOnResponse(final boolean ignoreRequiredExtensionsOnResponse)
  {
    this.ignoreRequiredExtensionsOnResponse = ignoreRequiredExtensionsOnResponse;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isLenientContentTypeChecking()
  {
    return this.lenientContentTypeChecking;
  }
}
