/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.resources.AbstractSchemasHolder;
import de.captaingoldfish.scim.sdk.common.utils.RequestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SearchRequest
extends AbstractSchemasHolder {
    public SearchRequest() {
        this(null, null, null, null, null, null, null, null, null);
    }

    public SearchRequest(Long startIndex, Integer count, String filter, String sortBy, SortOrder sortOrder, String attributesString, List<String> attributes, String excludedAttributesString, List<String> excludedAttributes) {
        this.setSchemas(Collections.singletonList("urn:ietf:params:scim:api:messages:2.0:SearchRequest"));
        this.setStartIndex(startIndex);
        this.setCount(count);
        this.setFilter(filter);
        this.setSortBy(sortBy);
        this.setSortOrder(sortOrder);
        if (StringUtils.isNotBlank((CharSequence)attributesString)) {
            this.setAttributes(attributesString);
        } else {
            this.setAttributes(attributes);
        }
        if (StringUtils.isNotBlank((CharSequence)excludedAttributesString)) {
            this.setExcludedAttributes(excludedAttributesString);
        } else {
            this.setExcludedAttributes(excludedAttributes);
        }
    }

    public Optional<Long> getStartIndex() {
        return this.getLongAttribute("startIndex");
    }

    public void setStartIndex(Long startIndex) {
        this.setAttribute("startIndex", startIndex);
    }

    public Optional<Integer> getCount() {
        return this.getLongAttribute("count").map(Long::intValue);
    }

    public void setCount(Integer count) {
        this.setAttribute("count", count == null ? null : Long.valueOf(count.intValue()));
    }

    public Optional<String> getFilter() {
        return this.getStringAttribute("filter");
    }

    public void setFilter(String filter) {
        this.setAttribute("filter", filter);
    }

    public Optional<String> getSortBy() {
        return this.getStringAttribute("sortBy");
    }

    public void setSortBy(String sortBy) {
        this.setAttribute("sortBy", sortBy);
    }

    public Optional<String> getSortOrder() {
        return this.getStringAttribute("sortOrder");
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.setAttribute("sortOrder", (String)Optional.ofNullable(sortOrder).map(order -> order.name().toLowerCase()).orElse(null));
    }

    public List<String> getAttributes() {
        JsonNode attributes = this.get("attributes");
        if (attributes instanceof ArrayNode) {
            return this.getSimpleArrayAttribute("attributes");
        }
        if (attributes instanceof TextNode) {
            return Optional.ofNullable(attributes.textValue()).map(RequestUtils::getAttributeList).orElseGet(ArrayList::new);
        }
        return Collections.emptyList();
    }

    public void setAttributes(String attributes) {
        List<String> attributeList = RequestUtils.getAttributeList(attributes);
        this.setAttributes(attributeList);
    }

    public void setAttributes(List<String> attributes) {
        this.setStringAttributeList("attributes", attributes);
    }

    public List<String> getExcludedAttributes() {
        JsonNode attributes = this.get("excludedAttributes");
        if (attributes instanceof ArrayNode) {
            return this.getSimpleArrayAttribute("excludedAttributes");
        }
        if (attributes instanceof TextNode) {
            return Optional.ofNullable(attributes.textValue()).map(RequestUtils::getAttributeList).orElseGet(ArrayList::new);
        }
        return Collections.emptyList();
    }

    public void setExcludedAttributes(String excludedAttributes) {
        List<String> excludedAttributeList = RequestUtils.getAttributeList(excludedAttributes);
        this.setExcludedAttributes(excludedAttributeList);
    }

    public void setExcludedAttributes(List<String> excludedAttributes) {
        this.setStringAttributeList("excludedAttributes", excludedAttributes);
    }

    @Generated
    public static SearchRequestBuilder builder() {
        return new SearchRequestBuilder();
    }

    public static class SearchRequestBuilder {
        @Generated
        private Long startIndex;
        @Generated
        private Integer count;
        @Generated
        private String filter;
        @Generated
        private String sortBy;
        @Generated
        private SortOrder sortOrder;
        @Generated
        private String attributesString;
        @Generated
        private List<String> attributes;
        @Generated
        private String excludedAttributesString;
        @Generated
        private List<String> excludedAttributes;

        @Generated
        public SearchRequestBuilder startIndex(Long startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        @Generated
        public SearchRequestBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        @Generated
        public SearchRequestBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Generated
        public SearchRequestBuilder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Generated
        public SearchRequestBuilder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Generated
        public SearchRequestBuilder attributesString(String attributesString) {
            this.attributesString = attributesString;
            return this;
        }

        @Generated
        public SearchRequestBuilder attributes(List<String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public SearchRequestBuilder excludedAttributesString(String excludedAttributesString) {
            this.excludedAttributesString = excludedAttributesString;
            return this;
        }

        @Generated
        public SearchRequestBuilder excludedAttributes(List<String> excludedAttributes) {
            this.excludedAttributes = excludedAttributes;
            return this;
        }

        @Generated
        public SearchRequest build() {
            return new SearchRequest(this.startIndex, this.count, this.filter, this.sortBy, this.sortOrder, this.attributesString, this.attributes, this.excludedAttributesString, this.excludedAttributes);
        }

        @Generated
        public String toString() {
            return "SearchRequest.SearchRequestBuilder(startIndex=" + this.startIndex + ", count=" + this.count + ", filter=" + this.filter + ", sortBy=" + this.sortBy + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", attributesString=" + this.attributesString + ", attributes=" + this.attributes + ", excludedAttributesString=" + this.excludedAttributesString + ", excludedAttributes=" + this.excludedAttributes + ")";
        }
    }
}

