/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.resources.AbstractSchemasHolder;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import java.util.Optional;

public abstract class ResourceNode
extends AbstractSchemasHolder {
    public Optional<String> getId() {
        return this.getStringAttribute("id");
    }

    public void setId(String id) {
        this.setAttribute("id", id);
    }

    public Optional<String> getExternalId() {
        return this.getStringAttribute("externalId");
    }

    public void setExternalId(String externalId) {
        this.setAttribute("externalId", externalId);
    }

    public Optional<Meta> getMeta() {
        return this.getObjectAttribute("meta", Meta.class);
    }

    public void setMeta(Meta meta) {
        if (this.getMeta().isPresent()) {
            throw new InternalServerException("meta attribute is already present please do not override the whole meta attribute but the single values", null, null);
        }
        this.setAttribute("meta", meta);
    }

    public Optional<JsonNode> getSortingAttribute(SchemaAttribute sortBy) {
        if (sortBy == null) {
            return Optional.empty();
        }
        if (Type.COMPLEX.equals((Object)sortBy.getType())) {
            throw new BadRequestException(" the attribute name must be a path to a sub-attribute in standard attribute notation, e.g., \"sortBy=name.givenName\".", null, "invalidPath");
        }
        Optional<JsonNode> parentNode = this.getSubNodeFromParent((JsonNode)this, false, sortBy.getParent());
        if (parentNode.isPresent()) {
            return this.getSubNodeFromParent(parentNode.get(), Type.COMPLEX.equals((Object)sortBy.getParent().getType()), sortBy);
        }
        return this.getSubNodeFromParent((JsonNode)this, false, sortBy);
    }

    private Optional<JsonNode> getSubNodeFromParent(JsonNode parent, boolean isComplex, SchemaAttribute sortBy) {
        if (sortBy == null) {
            return Optional.empty();
        }
        if (parent.size() == 0) {
            return Optional.empty();
        }
        if (parent.isArray() && isComplex) {
            JsonNode primaryNode = this.getPrimarySortingNodeFromMultiComplex((ArrayNode)parent);
            return Optional.ofNullable(primaryNode.get(sortBy.getName()));
        }
        if (parent.isArray()) {
            return Optional.ofNullable(parent.get(0));
        }
        return Optional.ofNullable(parent.get(sortBy.getName()));
    }

    private JsonNode getPrimarySortingNodeFromMultiComplex(ArrayNode arrayNode) {
        JsonNode primaryNode = null;
        for (int i = 0; i < arrayNode.size(); ++i) {
            JsonNode multiComplexNode = arrayNode.get(i);
            JsonNode primary = multiComplexNode.get("primary");
            if (primary == null || !primary.isBoolean() || !primary.booleanValue()) continue;
            primaryNode = multiComplexNode;
            break;
        }
        if (primaryNode == null) {
            primaryNode = arrayNode.get(0);
        }
        return primaryNode;
    }

    public boolean remove(SchemaAttribute attribute) {
        if (attribute == null) {
            return false;
        }
        ResourceNode resourceToHandle = this;
        boolean isExtensionReference = this.has(attribute.getSchema().getNonNullId());
        if (isExtensionReference) {
            resourceToHandle = (ObjectNode)this.get(attribute.getSchema().getNonNullId());
        }
        if (attribute.getParent() == null) {
            return resourceToHandle.remove(attribute.getName()) != null;
        }
        JsonNode attribteNode = resourceToHandle.get(attribute.getParent().getName());
        if (attribteNode == null) {
            return false;
        }
        if (attribteNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)attribteNode;
            boolean removedAnElement = false;
            for (JsonNode jsonNode : arrayNode) {
                ObjectNode complexNode = (ObjectNode)jsonNode;
                removedAnElement = complexNode.remove(attribute.getName()) != null || removedAnElement;
            }
            return removedAnElement;
        }
        ObjectNode complexNode = (ObjectNode)attribteNode;
        return complexNode.remove(attribute.getName()) != null;
    }
}

