/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.IncompatibleAttributeException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonHelper.class);

    public static JsonNode loadJsonDocument(String classPathLocation) {
        JsonNode jsonNode;
        block8: {
            log.trace("Trying to read classpath resource from: {}", (Object)classPathLocation);
            InputStream inputStream = JsonHelper.class.getResourceAsStream(classPathLocation);
            try {
                jsonNode = new ObjectMapper().readTree(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new de.captaingoldfish.scim.sdk.common.exceptions.IOException(e.getMessage(), (Throwable)e, null, null);
                }
            }
            inputStream.close();
        }
        return jsonNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends ObjectNode> T loadJsonDocument(String classPathLocation, Class<T> type) {
        log.trace("Trying to read classpath resource from: {}", (Object)classPathLocation);
        try (InputStream inputStream = JsonHelper.class.getResourceAsStream(classPathLocation);){
            JsonNode jsonNode = new ObjectMapper().readTree(inputStream);
            T t = JsonHelper.copyResourceToObject(jsonNode, type);
            return t;
        }
        catch (IOException e) {
            throw new de.captaingoldfish.scim.sdk.common.exceptions.IOException(e.getMessage(), (Throwable)e, null, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends ObjectNode> T loadJsonDocument(File file, Class<T> type) {
        log.trace("Trying to read classpath resource from: {}", (Object)file.getAbsolutePath());
        try (FileInputStream inputStream = new FileInputStream(file);){
            JsonNode jsonNode = new ObjectMapper().readTree((InputStream)inputStream);
            T t = JsonHelper.copyResourceToObject(jsonNode, type);
            return t;
        }
        catch (IOException e) {
            throw new de.captaingoldfish.scim.sdk.common.exceptions.IOException(e.getMessage(), (Throwable)e, null, null);
        }
    }

    public static JsonNode loadJsonDocument(File file) {
        JsonNode jsonNode;
        log.trace("Trying to read classpath resource from: {}", (Object)file.getAbsolutePath());
        FileInputStream inputStream = new FileInputStream(file);
        try {
            jsonNode = new ObjectMapper().readTree((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new de.captaingoldfish.scim.sdk.common.exceptions.IOException(e.getMessage(), (Throwable)e, null, null);
            }
        }
        ((InputStream)inputStream).close();
        return jsonNode;
    }

    public static JsonNode readJsonDocument(String jsonDocument) {
        JsonNode jsonNode;
        if (StringUtils.isBlank((CharSequence)jsonDocument)) {
            return null;
        }
        log.trace("Trying to read json document: {}", (Object)jsonDocument);
        StringReader reader = new StringReader(jsonDocument);
        try {
            jsonNode = new ObjectMapper().readTree((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new de.captaingoldfish.scim.sdk.common.exceptions.IOException("Invalid content, the document could not be parsed", (Throwable)e, null, null);
            }
        }
        ((Reader)reader).close();
        return jsonNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends ObjectNode> T readJsonDocument(String jsonDocument, Class<T> type) {
        log.trace("Trying to read json document: {}", (Object)jsonDocument);
        try (StringReader reader = new StringReader(jsonDocument);){
            JsonNode jsonNode = new ObjectMapper().readTree((Reader)reader);
            T t = JsonHelper.copyResourceToObject(jsonNode, type);
            return t;
        }
        catch (IOException e) {
            throw new de.captaingoldfish.scim.sdk.common.exceptions.IOException("Invalid content, the document could not be parsed", (Throwable)e, null, null);
        }
    }

    public static Optional<ArrayNode> getArrayAttribute(JsonNode jsonNode, String name) {
        JsonNode attribute = Objects.requireNonNull(jsonNode, "jsonNode must not be null").get(name);
        if (attribute == null) {
            return Optional.empty();
        }
        if (attribute.isArray()) {
            return Optional.of((ArrayNode)attribute);
        }
        throw new IncompatibleAttributeException("attribute with name '" + name + "' is not of type array", null, null, null);
    }

    public static Optional<ObjectNode> getObjectAttribute(JsonNode jsonNode, String name) {
        JsonNode attribute = Objects.requireNonNull(jsonNode, "jsonNode must not be null").get(name);
        if (attribute == null) {
            return Optional.empty();
        }
        if (attribute.isObject()) {
            return Optional.of((ObjectNode)attribute);
        }
        throw new IncompatibleAttributeException("attribute with name '" + name + "' is not of type object", null, null, null);
    }

    public static Optional<List<String>> getSimpleAttributeArray(JsonNode jsonNode, String attributeName) {
        return JsonHelper.getSimpleAttributeArray(jsonNode, attributeName, String.class);
    }

    public static <T> Optional<List<T>> getSimpleAttributeArray(JsonNode jsonNode, String attributeName, Class<T> type) {
        Optional<ArrayNode> simpleArrayOptional = JsonHelper.getArrayAttribute(jsonNode, attributeName);
        if (!simpleArrayOptional.isPresent()) {
            return Optional.empty();
        }
        ArrayNode simpleArray = simpleArrayOptional.get();
        ArrayList arrayResult = new ArrayList();
        for (JsonNode node : simpleArray) {
            JsonHelper.getAsAttribute(node, type).ifPresent(arrayResult::add);
        }
        return Optional.of(arrayResult);
    }

    public static Optional<String> getSimpleAttribute(JsonNode jsonNode, String name) {
        return JsonHelper.getSimpleAttribute(jsonNode, name, String.class);
    }

    public static <T> Optional<T> getSimpleAttribute(JsonNode jsonNode, String name, Class<T> type) {
        JsonNode attribute = Objects.requireNonNull(jsonNode, "jsonNode must not be null").get(name);
        if (attribute == null) {
            return Optional.empty();
        }
        if (attribute.isNull()) {
            return Optional.empty();
        }
        if (attribute.isArray()) {
            throw new IncompatibleAttributeException(String.format("attribute '%s' is not of type %s", name, type.getSimpleName()), null, null, "invalidValue");
        }
        return JsonHelper.getAsAttribute(attribute, type);
    }

    public static JsonNode removeAttribute(JsonNode jsonNode, String attributeName) {
        return ((ObjectNode)jsonNode).remove(attributeName);
    }

    public static JsonNode removeSimpleAttributeFromArray(JsonNode jsonNode, String value) {
        JsonNode simpleNode;
        if (jsonNode == null) {
            return null;
        }
        if (!jsonNode.isArray()) {
            log.info("Cannot remove value '{}' from a json node that is not a simple array", (Object)value);
            return jsonNode;
        }
        int index = -1;
        for (int i = 0; i < jsonNode.size() && !(simpleNode = jsonNode.get(i)).isObject() && !simpleNode.isArray(); ++i) {
            if (!simpleNode.textValue().equals(value)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            ((ArrayNode)jsonNode).remove(index);
        } else {
            log.info("Could not remove value '{}' from json array because its sub-elements are not primitive types", (Object)value);
        }
        return jsonNode;
    }

    public static JsonNode addAttribute(JsonNode jsonNode, String attributeName, JsonNode newAttriute) {
        return ((ObjectNode)jsonNode).set(attributeName, newAttriute);
    }

    public static JsonNode addAttributeToArray(JsonNode jsonArray, JsonNode newAttriute) {
        return ((ArrayNode)jsonArray).add(newAttriute);
    }

    public static <T> JsonNode writeValue(JsonNode jsonNode, String attributeName, T value) {
        TextNode valueNode = new TextNode(String.valueOf(value));
        return ((ObjectNode)jsonNode).replace(attributeName, (JsonNode)valueNode);
    }

    public static JsonNode replaceNode(JsonNode jsonNode, String attributeName, JsonNode replaceNode) {
        return ((ObjectNode)jsonNode).replace(attributeName, replaceNode);
    }

    private static <T> Optional<T> getAsAttribute(JsonNode attribute, Class<T> type) {
        if (String.class.equals(type)) {
            return Optional.of(attribute.asText());
        }
        if (Boolean.class.equals(type)) {
            return Optional.of(attribute.asBoolean());
        }
        if (Integer.class.equals(type)) {
            return Optional.of(attribute.asInt());
        }
        if (Long.class.equals(type)) {
            return Optional.of(attribute.asLong());
        }
        if (Float.class.equals(type)) {
            return Optional.of(Float.valueOf((float)attribute.asDouble()));
        }
        if (Double.class.equals(type)) {
            return Optional.of(attribute.asDouble());
        }
        if (byte[].class.equals(type)) {
            if (attribute.isBinary()) {
                try {
                    return Optional.of(attribute.binaryValue());
                }
                catch (IOException e) {
                    throw new IncompatibleAttributeException("binary attribute value could not be read", (Throwable)e, null, "invalidValue");
                }
            }
            try {
                return Optional.of(Base64.getDecoder().decode(attribute.textValue()));
            }
            catch (IllegalArgumentException e) {
                throw new IncompatibleAttributeException(String.format("attribute value '%s' is not of type %s", new Object[]{attribute.textValue(), Type.BINARY}), (Throwable)e, null, "invalidValue");
            }
        }
        throw new IncompatibleAttributeException(String.format("attribute '%s' is not of type %s", attribute, type.getSimpleName()), null, null, "invalidValue");
    }

    public static <T extends ObjectNode> T copyResourceToObject(JsonNode resource, Class<T> type) {
        if (resource == null) {
            return null;
        }
        if (resource.isArray()) {
            throw new IncompatibleAttributeException("operation not possible for array", null, null, "invalidParameters");
        }
        if (type.isAssignableFrom(resource.getClass())) {
            return (T)((ObjectNode)resource);
        }
        ObjectNode newInstance = (ObjectNode)JsonHelper.getNewInstance(type, resource);
        resource.fields().forEachRemaining(stringJsonNodeEntry -> JsonHelper.addAttribute((JsonNode)newInstance, (String)stringJsonNodeEntry.getKey(), (JsonNode)stringJsonNodeEntry.getValue()));
        return (T)newInstance;
    }

    public static <T extends ScimObjectNode> T getNewInstance(Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            return (T)((ScimObjectNode)constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new InternalServerException("could not create instance of type '" + type + "': " + e.getMessage(), e, null);
        }
        catch (NoSuchMethodException e) {
            throw new InternalServerException("missing no args constructor for type '" + type + "': " + e.getMessage(), e, null);
        }
    }

    private static <T extends JsonNode> T getNewInstance(Class<T> type, JsonNode resource) {
        try {
            if (resource != null && resource.size() != 0) {
                try {
                    Constructor<T> constructor = type.getConstructor(JsonNode.class);
                    return (T)((JsonNode)constructor.newInstance(resource));
                }
                catch (NoSuchMethodException constructor) {
                }
                catch (InvocationTargetException e) {
                    throw new InternalServerException("could not create instance of type '" + type + "': " + e.getMessage(), e, null);
                }
            }
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            return (T)((JsonNode)constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new InternalServerException("could not create instance of type '" + type + "': " + e.getMessage(), e, null);
        }
        catch (NoSuchMethodException e) {
            throw new InternalServerException("missing no args constructor for type '" + type + "': " + e.getMessage(), e, null);
        }
    }

    public static Optional<JsonNode> getSimpleAttributeByName(JsonNode jsonNode, String attributeName) {
        String[] nameParts = attributeName.split("\\.");
        JsonNode subNode = jsonNode.get(nameParts[0]);
        if (nameParts.length == 1) {
            return Optional.ofNullable(subNode);
        }
        return Optional.ofNullable(subNode.get(nameParts[1]));
    }

    public static boolean isValidJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return false;
        }
        try {
            JsonParser parser = new ObjectMapper().getFactory().createParser(json);
            while (parser.nextToken() != null) {
            }
            return true;
        }
        catch (IOException ex) {
            log.info(ex.getMessage());
            log.trace(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public static String toJsonString(JsonNode jsonNode) {
        try {
            return new ObjectMapper().writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException(e.getMessage(), e);
        }
    }

    public static String toPrettyJsonString(JsonNode jsonNode) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException(e.getMessage(), e);
        }
    }

    public static boolean isEmpty(JsonNode jsonNode) {
        return jsonNode.size() == 0;
    }

    public static <T extends JsonNode> boolean containsEqualObject(List<T> originalNodes, T jsonNode) {
        return originalNodes.parallelStream().anyMatch(originalNode -> JsonHelper.isEqual(originalNode, jsonNode));
    }

    public static boolean isEqual(JsonNode node1, JsonNode node2) {
        if (node1 == null && node2 == null) {
            return true;
        }
        if (node1 == null || node2 == null) {
            return false;
        }
        return node1.equals((o1, o2) -> {
            boolean isO2Null;
            boolean isO1Null = o1 == null || o1.isNull();
            boolean bl = isO2Null = o2 == null || o2.isNull();
            if (isO1Null && isO2Null) {
                return 0;
            }
            if (isO1Null || isO2Null) {
                return 1;
            }
            if (o1.isNumber() && o2.isNumber()) {
                return o1.longValue() == o2.longValue() ? 0 : 1;
            }
            if (o1.isNumber() && o2.isNumber()) {
                return o1.longValue() == o2.longValue() ? 0 : 1;
            }
            return o1.equals(o2) ? 0 : 1;
        }, node2);
    }

    @Generated
    private JsonHelper() {
    }
}

