/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.utils;

import de.captaingoldfish.scim.sdk.common.exceptions.InvalidDateTimeRepresentationException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeUtils.class);
    private static final String YEAR_FRAGMENT = "([1-9]\\d\\d\\d|0\\d\\d\\d)";
    private static final String MONTH_FRAGMENT = "(0[1-9]|1[0-2])";
    private static final String DAY_FRAGMENT = "(0[1-9]|[12]\\d|3[01])";
    private static final String HOUR_FRAGMENT = "([01]\\d|2[0-3])";
    private static final String MINUTE_FRAGMENT = "[0-5]\\d";
    private static final String SECOND_FRAGMENT = "[0-5]\\d(\\.\\d+)?";
    private static final String END_OF_DAY_FRAGMENT = "24:00:00(\\.0+)?";
    private static final String TIMEZONE_OFFSET_FRAGMENT = "(Z|([+\\-])((0\\d|1[0-3]):[0-5]\\d|14:00))";
    private static final String XSD_DATE_TIME_PARTIAL_FORMAT = "([1-9]\\d\\d\\d|0\\d\\d\\d)-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01])T(([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?|24:00:00(\\.0+)?)";
    public static final int DEFAULT_INSTANT_FRACTIONAL_DIGITS_FORMAT = 3;
    public static final String XSD_DATE_TIME_FORMAT = "([1-9]\\d\\d\\d|0\\d\\d\\d)-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01])T(([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?|24:00:00(\\.0+)?)(Z|([+\\-])((0\\d|1[0-3]):[0-5]\\d|14:00))";

    public static Instant parseDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        String errorMessage = "value '" + dateTime + "' does not match the xsd:dateTime definition: " + XSD_DATE_TIME_FORMAT;
        String tmpDateTime = dateTime;
        if (tmpDateTime.matches(XSD_DATE_TIME_PARTIAL_FORMAT)) {
            tmpDateTime = tmpDateTime + "Z";
        }
        if (!tmpDateTime.matches(XSD_DATE_TIME_FORMAT)) {
            throw new InvalidDateTimeRepresentationException(errorMessage, null, null, null);
        }
        if (tmpDateTime.matches(".*?24:00:00(\\.0+)?.*")) {
            tmpDateTime = tmpDateTime.replace("24:00:00", "23:59:59");
        }
        try {
            return OffsetDateTime.parse(tmpDateTime).toInstant();
        }
        catch (DateTimeParseException ex) {
            throw new InvalidDateTimeRepresentationException(errorMessage, (Throwable)ex, null, null);
        }
    }

    @Generated
    private TimeUtils() {
    }
}

